/*
 * File: heat.l256r2.c
 *   By: Dave Hiebeler
 *       hiebeler@turing.cs.rpi.edu
 *       Feb. 1990
 *
 * The "heat" rule in the linear neighborhood.
 *
 * Parm2 is the constant added in to every cell after it takes on the
 * average value of the neighborhood.
 *
 * A random starting config works with some settings of the parameters.
 * For other settings, you may want to use a "hot array with a cold hole",
 * as described in "heat.m256.c".  In this case, however, the "hole"
 * should be on the bottom line of the array.
 *
 */


#include "CMnborhood.h"

byte heat(), heat_exit();
static CM_field_id_t heat_sum;


void
init_function()
{

    update_function = heat;
    exit_function = heat_exit;
    parm2 = 2;
    heat_sum = CM_allocate_heap_field(11);
}


byte
heat()
{
    CM_u_move_zero_1L(heat_sum, 11);
    CM_u_add_3_3L(heat_sum, heat_sum, LR2_LL, 11, 11, 8);
    CM_u_add_3_3L(heat_sum, heat_sum, LR2_L, 11, 11, 8);
    CM_u_add_3_3L(heat_sum, heat_sum, LR2_C, 11, 11, 8);
    CM_u_add_3_3L(heat_sum, heat_sum, LR2_R, 11, 11, 8);
    CM_u_add_3_3L(heat_sum, heat_sum, LR2_RR, 11, 11, 8);
    CM_u_truncate_constant_3_1L(heat_sum, heat_sum, 5, 11);
    CM_u_add_constant_2_1L(heat_sum, parm2, 8);
    CM_u_move_1L(cell, heat_sum, 8);
}


byte
heat_exit()
{
    CM_deallocate_heap_field(heat_sum);
}
