#ifndef lint
static char SCCSid[] = "@(#) ./xtools/quick/qxcntr.c 07/23/93";
#endif

#include <stdio.h>
#include "tools.h"
#include "xtools/basex11.h"

#include <math.h>

extern XBWindow *XBQGetWindow();
void XBQiContourFindImapEqual();

static int      YIncreasingUp = 0;
static int      MappingType   = 0;
static int      SaveMap       = 0;
static int      GetMap        = 0;
static double   imap[256];

/*@
     XBQContour - display a contour plot on the display.

     Input Parameters:
.    mesh - mesh of values
.    x,y  - coordinates of mesh
.    nx,ny - size of mesh
.    nc    - number of colors.  Must be at least 2.

     Note:
     This uses the "quick" window; if there is no "quick" window, 
     one is created.
@*/
void XBQContour( mesh, x, y, nx, ny, nc )
double *mesh, *x, *y;
int    nx, ny, nc;
{
int           i, j, n;
double        *px = 0, *py = 0, maxv, minv;
XBWindow      *XBWin = XBQGetWindow( "Contour", "" );
unsigned char *map;

if (!XBWin) return;

XBUniformHues( XBWin, nc + 2 );

/* if x,y, null, generate those too */
if (!x) {
    px = (double *)MALLOC( nx * sizeof(double) );
    for (i=0; i<nx; i++) px[i] = i*(1.0/(nx-1));
    x  = px;
    }
else {
    px = 0;
    }
if (!y) {
    py = (double *)MALLOC( ny * sizeof(double) );
    for (j=0; j<ny; j++) py[j] = j*(1.0/(ny-1));
    y = py;
    }
else {
    py = 0;
    }

map = (unsigned char *) MALLOC( XBWin->w * XBWin->h );    CHKPTR(map);

if (!SaveMap || GetMap) {
    if (MappingType == 0) {
	n    = nx * ny;
	minv = maxv = mesh[0];
	for (i=0; i<n; i++) {
	    if (mesh[i] > maxv) maxv = mesh[i];
	    else if (mesh[i] < minv) minv = mesh[i];
	    }
	for (i=0; i<nc; i++) 
	    imap[i] = (double)(i + 1)*(maxv - minv) / nc + minv;
	}
    else {
	XBQiContourFindImapEqual( mesh, nx*ny, nc, imap );
	}
    if (SaveMap) GetMap = 0;
    }

if (YIncreasingUp) {
    XBContourDrawWithMapYup( XBWin, mesh, nx, ny, x, y, imap, nc, map, 
			     XBWin->w, XBWin->h, 0, 0, 1 );
    }
else {
    XBContourDrawWithMap( XBWin, mesh, nx, ny, x, y, imap, nc, map, 
			  XBWin->w, XBWin->h, 0, 0, 1 );
    }

FREE( map );
if (px) FREE( px );
if (py) FREE( py );
}


/*@
  XBQContourYdirection - Set whether Y is up or down (down is default)

  Input Parameter:
. flag - 1 for y increases UP, 0 for y increases down
@*/
void XBQContourYdirection( flag )
int flag;
{
YIncreasingUp = flag;
}


/*@
   XBQContourMappingType - Set the mapping type (equal spaced (0) or
   uniformly distributed (1)

   Input Parameter:
.  flag - 1 for uniformly distributed or 0 for equally spaced contours.  
   equally spaced is the default.
@*/
void XBQContourMappingType( flag )
int flag;
{
MappingType = flag;
}

/*@
  XBQContourSaveMapping - set whether contour plot should recompute 
  contour levels for each plot

  Input Parameter:
. flag - if 0, recompute each time, else, use first plot for limits  

  Note:
  Also see XBQContourSetMapping
@*/
void XBQContourSaveMapping( flag )
int flag;
{
SaveMap = flag;
if (flag)
    GetMap = 0;
}

/*@
  XBQContourSetMapping - set a uniform mapping for a contour plot

  Input Parameter:
. nc - number of colors
. minz - minimum value
. maxz - maximum value

  Note:
  Also see XBQContourSaveMapping
@*/
void XBQContourSetMapping( nc, minz, maxz )
int    nc;
double minz, maxz;
{
int i;
for (i = 0; i<nc; i++) 
    imap[i] = minz + i * (maxz - minz) / (nc - 1.0);
GetMap = 0;
}

#ifdef OLD_SORT
/*
    Used by the routine to do the floating-point sort
 */
static int rcompare( p1, p2 )
double *p1, *p2;
{
if (*p1 < *p2) return -1;
if (*p1 > *p2) return 1;
return 0;
}
#endif

/*
    The "equal area" approach can be too informative sometimes;
    data that is insignificant can show up as important.
    The EqualRTol (relative) and EqualATol (absolute) tolerances
    allow the user to insure that the levels have a certain
    minimum spacing
 */
static double EqualRTol = 0.0;
static double EqualATol = 0.0;

void XBQiContourFindImapEqual( p, n, ncolor, imap )
double *p, *imap;
int    n, ncolor;
{
double *p1, *p2, dp, *cc, botval, rtol;
int    nc;

/* make a copy of the data for sorting */
cc = p1 = (double *)MALLOC( n * sizeof(double) ); CHKPTR(cc);
nc = n;
p2 = p;
while (nc--) *p1++ = *p2++;

/* sort the data */
#ifdef OLD_SORT
qsort( (char *)cc, n, sizeof(double), rcompare );
#else
SYDsort( n, cc );
#endif

/* relative change in data must be more than EqualRTol; by multiplying
   through by the range of the data, this test will always succeed */
rtol = (cc[n-1] - cc[0]) * EqualRTol;

/* run through the sorted data, setting imap[i] to the value at the i*ncolor
   position */
p1 = cc;
/* the number of values to run through is always (nvals/ncolors), where
   both are number remaining (corrects for rounding errors).  Finally, if
   the special case to insure that each value is "large enough" exhausts the
   supply of data before all of the colors are used up, the last value is
   duplicated for the rest of the map. */
while (ncolor) {
    *imap++ = *p1;
    nc = n / ncolor--;
    /* As a special case, make sure that the next value will be
       sufficiently different.  This isn't optimal, but it is better
       than nothing.  It might be better to make the data unique after
       sorting before doing this step.  However, if there aren't any
       values left, don't do this check. */
    botval = *p1;
    n      -= nc;
    p1     += (n > 0 || nc == 0) ? nc : nc - 1;
    while (/* ncolor > 0 && */ n > 0 && *p1 - botval <= rtol) {
        n--;
        if (n > 0) p1++;
        }
    }
FREE( cc );
}

/*@
     XBQContourQuadrilaterals - display a contour plot on the display.

     Input Parameters:
.    mesh - mesh of values
.    x,y  - coordinates of mesh (size is nx x ny)
.    nx,ny - size of mesh
.    nc    - number of colors.  Must be at least 2.

     Note:
     This uses the "quick" window; if there is no "quick" window, 
     one is created.

     x and y must be given.
@*/
void XBQContourQuadrilaterals( mesh, x, y, nx, ny, nc )
double *mesh, *x, *y;
int    nx, ny, nc;
{
int           i, j, n;
double        *px = 0, *py = 0, maxv, minv;
XBWindow      *XBWin = XBQGetWindow( "Contour", "" );
unsigned char *map;

if (!XBWin) return;

XBUniformHues( XBWin, nc + 2 );

if (!x || !y) {
    SETERRC(1,"x and y must be specified");
    return;
    }

map = (unsigned char *) MALLOC( XBWin->w * XBWin->h );    CHKPTR(map);

if (!SaveMap || GetMap) {
    if (MappingType == 0) {
	n    = nx * ny;
	minv = maxv = mesh[0];
	for (i=0; i<n; i++) {
	    if (mesh[i] > maxv) maxv = mesh[i];
	    else if (mesh[i] < minv) minv = mesh[i];
	    }
	for (i=0; i<nc; i++) 
	    imap[i] = (double)(i + 1)*(maxv - minv) / nc + minv;
	}
    else {
	XBQiContourFindImapEqual( mesh, nx*ny, nc, imap );
	}
    if (SaveMap) GetMap = 0;
    }
/*
if (YIncreasingUp) {
    XBContourDrawWithMapYup( XBWin, mesh, nx, ny, x, y, imap, nc, map, 
			     XBWin->w, XBWin->h, 0, 0, 1 );
    }
else {
 */
    XBContourQuadrilaterals( XBWin, mesh, nx, ny, x, y, imap, nc, map, 
			     XBWin->w, XBWin->h, 0, 0, 1 );
/*     } */

FREE( map );
}
