#include <stdio.h>
#include "tools.h"
#include "xtools/basex11.h"

#include <math.h>

#define X_SIZE 11
#define Y_SIZE 13

main( argc, argv )
int argc;
char **argv;
{
XBWindow *XBWin;
double   mesh[X_SIZE*Y_SIZE], x[X_SIZE*Y_SIZE], y[X_SIZE*Y_SIZE], r, xx, yy;
unsigned char *map;
double   imap[16];
int      i, j;
int      px = -1, py = -1, pw = 200, ph = 200;
int      nx = X_SIZE, ny = Y_SIZE;

XBWin = XBWinCreate();
if (SYArgHasName( &argc, argv, 1, "-help" )) {
    fprintf( stderr, "%s Contour example\n", argv[0] );
    exit(0);
    }
XBGetArgs( &argc, argv, 1, &px, &py, &pw, &ph );
if (XBQuickWindow( XBWin, "", "Contour", px, py, pw, ph )) {
    fprintf( stderr, "Check your DISPLAY variable\n" );
    exit(0);
    }
map = (unsigned char *)MALLOC( XBWin->w * XBWin->h ); CHKPTR(map);
SYArgGetInt( &argc, argv, 1, "-nx", &nx );
SYArgGetInt( &argc, argv, 1, "-ny", &ny );
if (nx > X_SIZE) nx = X_SIZE;
if (ny > Y_SIZE) ny = Y_SIZE;
XBUniformHues( XBWin, 16 );

/* Setup the data */
for (i=0; i<nx; i++)
    for(j=0; j<ny; j++) {
	xx = x[i + j * nx] = i * (1.0/(nx-1));
	yy = y[i + j * nx] = j * (1.0/(ny-1)) + 0.1*sin(2*3.1415926*xx);
        r  = sqrt( (xx - 0.5) * (xx - 0.5) + (yy - 0.5) * (yy - 0.5));
        mesh[i + j * nx] = (r == 0) ? 1.0 : sin(4.0*r) / (4.0 * r);
        }
for (i=0; i<16; i++) 
    imap[i] = (double)(i + 1) /  16.0;

XBContourQuadrilaterals( XBWin, mesh, nx, ny, x, y, imap, 16, map, 
                         XBWin->w, XBWin->h, 0, 0, 0 );
XBContourDrawQuadrilaterals( XBWin, nx, ny, x, y, XBWin->background, 
				  XBWin->w, XBWin->h, 0, 0 );
sleep(5);
}
