/* 
   This defines a structure that contains pointers to routines for
   manipulating vectors.  These are patterned after the Level-1
   Blas, but with some additions that have proved useful.
   These include routines to allocate and free vectors.

   Note that the routines that are normally thought of as returning a
   value (e.g., dot, norm) return their value through an argument.
   This allows these routines to be used with other datatype, such
   as float and dcomplex.

   These are for parallel vectors, vectors that lie across the memory 
   of several processors.

 */

#ifndef __PVEC
#define __PVEC
#include "vectors/vector.h"
#include "comm/comm.h"
#include "comm/procset.h"

typedef struct {
    int     n;
    ProcSet *pset;
    } VEPDefaultUsrCntx;

extern VEPDefaultUsrCntx *VEPCreateDefaultUsrCntx();
extern void              VEPDestroyDefaultUsrCntx(); 

void DVPdot();
void DVPnorm();
void DVPmax();
void DVPscal();
void DVPcopy();
void DVPswap();
void DVPset();
void DVPaxpy();
void DVPaypx();
void DVPwaxpy();
void **DVPobtain_vectors();
void DVPrelease_vectors();
void *DVPCreateVector();
void DVPDestroyVector();
void DVPSetDefaultFunctions();

#endif

