#ifndef lint
static char SCCSid[] = "@(#) ./vectors/pvec.c 07/23/93";
#endif

#include "tools.h"
#include "inline/dot.h"
#include "system/flog.h"
#include <math.h>
#include "vectors/pvec.h"               /*I "vectors/pvec.h" I*/

/*
   This file contains routines for Parallel vector operations.
   Basically, these are just the local routine EXCEPT for the
   Dot products and norms.  Note though that they use the
   processor subset to 
 */

/*@
   DVPdot - Dot product for parallel double precision vectors.

   Input Parameters:
.  N     - Vector context
.  x,y   - vectors to form dot product of

   Output Parameter:
.  z     - result
 @*/
void DVPdot( N, x, y, z )
VEPDefaultUsrCntx *N;
register double *x, *y, *z;
{
double sum, work;
DVdot( (VEDefaultUsrCntx*)N, x, y, &sum );
GDSUM( &sum, 1, &work, N->pset );
*z = sum;
}

/*@
   DVPnorm - Two norm for parallel double precision vectors.

   Input Parameters:
.  N     - Vector context
.  x     - vector to form 2-norm of

   Output Parameter:
.  z     - result
 @*/
void DVPnorm( N, x, z )
VEPDefaultUsrCntx *N;
register double *x, *z;
{
register int n = N->n;
double sum = 0.0, work;

SQR(sum,x,n);
GDSUM( &sum, 1, &work, N->pset );
*z = sqrt( sum );
}
/*@
   DVPmax - Max norm for parallel double precision vectors.

   Input Parameters:
.  N     - Vector context
.  x     - vector to form max-norm of
.  idx   - index of maximum element.  If there are several elements with the
           maximum value, the index of one (probably but no necessarily the
	   first) is returned.

   Output Parameter:
.  z     - result
 @*/
void DVPmax( N, x, idx, z )
VEPDefaultUsrCntx *N;
int              *idx;
double           *x, *z;
{
double work;

/* Find the local max */
DVmax( N, x, idx, z );

/* Find the global max */
if (!idx) {
    GDMAX( z, 1, work, N->pset );
    }
else {
    /* Need to use special linked max */
    SETERRC( 1, "Parallel max with index not yet supported" );
    }
}

/*@
   VEPCreateDefaultUsrCntx - Creates a default user context for 
   parallel vectors.

   Input Parameters:
.     n  -  vector length on this processor
.     pset - set of processors on which this vector is stored
 @*/
VEPDefaultUsrCntx *VEPCreateDefaultUsrCntx(n, pset)
int     n;
ProcSet *pset;
{
VEPDefaultUsrCntx *v;

v       = NEW(VEPDefaultUsrCntx);
v->n    = n;
v->pset = pset;

return v;
}

/*@
   VEPDestroyDefaultUsrCntx - Destroys a default user context for 
   parallel vectors.

   Input Parameter:
.  v - vector context to free
 @*/
void VEPDestroyDefaultUsrCntx(v)
VEPDefaultUsrCntx *v;
{
FREE(v);
}

/*@
  DVPSetDefaultFunctions - Set vector operations for parallel double
  precision vectors.

  Input parameter:
. vopP - Vector context  
 @*/
void DVPSetDefaultFunctions( vopP )
VECntx *vopP;
{
/* We take advantage of the fact that the first word in the context for
   both uniprocessor and parallel vectors is the length of the local
   vector */	
DVSetDefaultFunctions( vopP );
vopP->dot    = DVPdot;
vopP->norm   = DVPnorm;
vopP->max    = DVPmax;
vopP->tdot   = DVPdot;
}
