#ifndef lint
static char SCCSid[] = "@(#) ./sparse/row/solvetra.c 07/23/93";
#endif

/*
    This file contains a simple sparse solve routine for solving the
    problem A^T x = b.  This is done by using the factors of A:
    A = LU; then A^T = U^TL^T and thus the solution is arrived at by
    solving U^T y = b followed by L^T x = y .  Because row storage is
    used for the regular factors, column storage is used for the transposes.
 */

#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"
#include "inline/spops.h"

/*
  SpRSolveTrans - Solve a system of equations using the TRANSPOSE of
                 a factored matrix.

  Input Parameters:
.  BB - Split matrix already processed by Factor
.  b  - Right-hand-side
.  x  - solution
 */
int SpRSolveTrans( BB, b, x )
SpMatSplit *BB;
double     *b, *x;
{
int err;
if (BB->factor->map) 
    err = 1;
else
    err = SpiRSolveBaseTrans( BB, x, b );
return err;
}

/*
   This is a solve that does not involve any mappings 
 */
int SpiRSolveBaseTrans( BB, x, b )
SpMatSplit  *BB;
double      *x, *b;
{
int      i, n, *nzs;
register double       *v, alpha;
register int          *vi, nz;
SpMat    *B = BB->factor;
SpVec    *row, **rs;
SpRowMat *R = (SpRowMat *)B->data;

n      = B->rows;
/* forward solve the lower triangular (actually the transpose of the
   upper triangular factor) */
nzs    = BB->nzl;
rs     = R->rs;
for (i=0; i<n; i++) {
    row  = *rs++;
    nz   = *nzs++;
    v    = row->v + nz;
    vi   = row->i + nz;
    nz   = row->nz - nz;
    x[i] = b[i] * v[0];
    v++; vi++; nz--;
    alpha= x[i];
    SPARSEDENSESMAXPY(b,alpha,v,vi,nz);
    }

/* backward solve the upper triangular (actually the transpose of the
   lower triangular factor) */
nzs--; rs--;
for (i=n-1; i>=1; i--) {
    nz   = *nzs--;
    row  = *rs--;
    v    = row->v;
    vi   = row->i;
    alpha= x[i];
    SPARSEDENSESMAXPY(x,alpha,v,vi,nz);
    }
return ERR_NONE;
}


