#ifndef lint
static char SCCSid[] = "@(#) ./sparse/fblock/fballoc.c 07/23/93";
#endif

#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"          
#include "sparse/fblock/spfbpriv.h"   
#include "inline/blas2.h"

extern void SpFBMult();
void   SpFBDestroy();
SpMat  *SpFBCreate();
int    SpFBComputeFactor();
void   SpFBSolve();
void   SpFBScatterFromRow(), SpFBGatherToRow();
static SpOps _SpBlockOps = { SpFBMult, 0, 0,
			     SpFBSolve, 0, 
			   0, 0, 
			   SpFBDestroy, 
			   (void *(*)())SpFBCreate,
			   0,
			   0, 0, SpFBComputeFactor, 
			   0, 0, 
			0/* SpFBGatherToRow */, 0, SpFBScatterFromRow, 0, 
			   0, 
			   0, 1, 1 };

/*
    Allocation of blocked matrices.  The idea here is to provide
    pointers to user-defined (and allocated!) data.  Operations
    (such as generating a matrix factor) that add elements use a
    user-defined routine to allocate these.  Note that many elements
    may be allocated at a time.
 */

/*@
   SpFBCreate - Allocate an n x m sparse matrix stored as blocks

   Input Parameters:
.   n - number of rows
.   m - number of columns
.   mmax - estimated number of elements in each row (this many elements
          will be pre-allocated; this value may be set to zero, in which
	  case space will be allocated as required.)
 @*/
SpMat *SpFBCreate( n, m, mmax, bsize )
int  n, m, mmax, bsize;
{
SpMat     *mat;
SpFBRowMat *R;
SpFBVec    *vs, **nb;
int       i;

mat       = NEW(SpMat);     CHKPTRV(mat,0);
mat->ops  = &_SpBlockOps;
R         = NEW(SpFBRowMat); CHKPTRV(R,0);
mat->data = (void *)R;
nb        = (SpFBVec **) MALLOC( n*(sizeof(SpFBVec *) +
					  sizeof(SpFBVec)) ); CHKPTRV(nb,0);
SPiInitPool( &mat->pool ); CHKERRV(0,0);
R->bsize  = bsize;
R->rs     = nb;
R->nfbvecs= n / bsize;

mat->rows  = n;
mat->cols  = m;
mat->nz    = 0;
mat->alloc_incr     = 5;
mat->alloc_together = 1;
mat->element_length = sizeof(double *);
mat->is_sorted      = 1;                /* This means that the columns
					   are in sorted order */
mat->map   = 0;
mat->type  = MATBLOCK;
vs = (SpFBVec *) (R->rs + n);
for (i=0; i<n; i++) {
    R->rs[i]   = vs;
    vs->maxn   = mmax;
    vs->nz     = 0;
    vs->dloc   = -1;
    /* allocate from chunck */
    if (mmax > 0) {
	/* WRONG */
	SPMallocNV( mat, mmax, &vs->v, &vs->i ); CHKERRV(0,0);
	}
    else {
	vs->v = 0;
	vs->i = 0;
	}
    vs++;
    }

return mat;
}

/*@
  SpFBDestroy - Free a sparse matrix stored as blocks

  Input Parameters:
. mat - matrix to free
 @*/
void SpFBDestroy( mat )
SpMat *mat;
{
SpiPoolFree( &mat->pool );
if (mat->map) SpDestroyMap( mat->map );
/* SpDestroyBlk( (SpRowMat *)mat->data ); */
FREE( ((SpFBRowMat *)mat->data)->rs );
FREE( mat->data );
FREE( mat );
}

/*@
    SpFBSetElm - Set a single element in a blocked sparse matrix.
                This is the same as the unblocked, except the value
                is a pointer to user-defined and allocated space.

    Input Parameters:
.   mat     - matrix to set element in
.   row,col - row and column to set
.   val     - value to set
@*/
void SpFBSetElm( mat, row, col, val )
SpMat     *mat;
int       row, col;
double    val;    
{
SpFBRowMat *R;
SpFBVec    *x;
int       nzx, *ix, k, a, b, t;

SPLITTOMAT(mat);
R   = GETBROWMAT(mat);
x   = R->rs[row]; 
nzx = x->nz;
ix  = x->i;

/* Find location for value.  */
a = 0; 
b = nzx;    /* b is one greater */
#define PRESORT
#ifdef PRESORT
while (b-a > 5) {
    t = (b+a)/2;
    if (ix[t] > col)
	b = t;
    else
	a = t;
    }
#endif
ix = ix + a;
for (k=a; k<b; k++) {
    if (*ix >= col) {
	if (*ix == col) {
	    x->v[k] = val;
	    return;
	    }
	break;
	}
    ix++;
    }
SpFBiInsertValue( mat, x, col, val, k );
}

/*
   Insert a value.  It is KNOWN not to exist.
   What we need is an even more general routine, so that there are fewer
   routines.  Perhaps the insert routines should only know the number of
   bytes of the object (or perhaps longs, and insist on even multiple of
   longs?)
 */
int SpFBiInsertValue( mat, x, col, value, k )
SpMat  *mat;
SpFBVec  *x;
int    col, k;
double value;
{
int             nzx = x->nz, n;
register int    *ix, m, *oi;
register double *px, *op;
double *Px, *SPiPoolAlloc();
int    *Ix;

/* Insert value before the kth */
/* bump up the existing value OR allocate new space */
if (x->maxn <= x->nz) {
    /* get more space and insert */
    n  = x->nz + mat->alloc_incr;
    Px = SPiPoolAlloc( &mat->pool, n * (sizeof(double) + sizeof(int)) );
    Ix = (int *)(Px + n);
    CHKPTRV(Px,1);

    px = Px;
    ix = Ix;
    oi = x->i;
    op = x->v;
    for (m=0; m<k; m++) {
	px[m] = op[m];
	ix[m] = oi[m];
	}
    px[k] = value;
    ix[k] = col;
    for (m=k+1; m<=nzx; m++) {
	px[m] = op[m-1];
	ix[m] = oi[m-1];
	}
    if (x->maxn > 0)
	SPFreeNV(mat,x->maxn,x->v,x->i);
    x->v = px;
    x->i = ix;
    x->maxn = x->nz + mat->alloc_incr;
    }
else {
    /* Space is available in this vector */
    px = x->v + k;
    ix = x->i + k;
    nzx= x->nz - k;
    for (m=nzx; m>0; m--) {
	px[m] = px[m-1];
	ix[m] = ix[m-1];
	}
    px[0] = value;
    ix[0] = col;
    }
x->nz++;
if (mat->nz >= 0) mat->nz++;
return ERR_NONE;
}

/*
   Eventually (soon) we'll need routines to set at least a row at a time,
   perhaps more.
 */

static double vtmp[10000]; /* !! */

void SpFBScatterFromRow( mat, row, nz, i, v )
SpMat  *mat;
int    row, *nz, **i;
double **v;
{
SpFBRowMat *R = (SpFBRowMat *)mat->data;
SpFBVec    *vs;
int        j, bsize, nnz, off;

if (row < 0 || row >= mat->rows) {
    *nz = 0;
    return;
    }
bsize = R->bsize;
vs    = R->rs[row / bsize];

if (nz)
    *nz = vs->nz * R->bsize;
if (i)
    *i  = vs->i;
if (v) {
    nnz = vs->nz * bsize;
    off = row % bsize;
    for (j=0; j<nnz; j++) {
	vtmp[j] = vs->v[off+j*bsize];
	}
    *v  = vtmp;
    }
}
