#ifndef LINT
static char SCCSid[] = "@(#) ./sparse/diag/diagtosp.c 07/23/93";
#endif

/*
   This file contains routines for converting from sparse diagonal format
   to general sparse format.  Note that the inverse conversion is 
   more difficult because it is not unique.
 */

#include "tools.h"
#include "sparse/spmat.h"
#include "sparse/sppriv.h"
#include "sparse/diag/diag.h"                 

/*@
  SpDiagToSp - Convert to sparse format for a matrix.  
   
   Description:
   The destination matrix has
   nrow rows, and the indicies are (irow(row),icol(col)) if the 
   indicies in the diagonal matrix are (row,col).  If irow or icol is null,
   the identity mapping is used.

   Input Parameters:
.   nmat  - diagonal format matrix to convert
.   nrow - number of rows in result matrix
.   irow - use the rows irow[0] to irow[nrow-1]
.   icol - ditto for cols
 @*/
SpMat *SpDiagToSp( nmat, nrow, irow, icol )
SpMat *nmat;
int   nrow, *irow, *icol;
{
SpMatDiag *mat = (SpMatDiag *)nmat->data;
SpDiag *csd, **sd = mat->sd;
int            nsd = mat->nsd, nd, nr, row, sr, rinc, dinc, *doff, d;
int            rrow, ccol;
double         *dv, **pdv;
SpMat   *B;
SpVec   *sv;
SpRowMat *R;

B = SpCreate( nrow, nrow, 0 );           CHKERRV(0,0);
R = (SpRowMat *)B->data;
while (nsd--) {
    csd = *sd++;
    nd  = csd->nd;
    nr  = csd->nr;
    doff= csd->doff;
    pdv = csd->v;
    rinc= csd->rinc;
    dinc= csd->dinc;
    sr  = csd->sr;

    /* Allocate the rows for this block of elements */
    for (row=0; row<nr; row++) {
	rrow     = irow ? irow[sr+row*rinc] : sr + row*rinc;
	sv       = R->rs[rrow];
	SPMallocNV( B, nd, &sv->v, &sv->i ); CHKERRV(1,0);
	sv->maxn = nd;
	sv->nz   = nd;
        }

    /* copy in these diagonals into the sparse rows */
    switch (csd->kind) {
	case DIAG_GENERAL:
	case DIAG_UNITSTRIDE:
	for (d=0; d<nd; d++) {
	    dv = *pdv++;
	    for (row=0; row<nr; row++) {
		rrow     = irow ? irow[sr+row*rinc] : sr + row*rinc;
		sv       = R->rs[rrow];
		ccol     = icol ? icol[*doff+row*rinc] : *doff + row*rinc;
		sv->i[d] = ccol;
		sv->v[d] = *dv;
		dv       += dinc;
		}
	    doff++;
	    }
	break;
	
	case DIAG_CONSTANT:
	/* Diags are constant values */
	dv = (double *)pdv;
	for (d=0; d<nd; d++) {
	    for (row=0; row<nr; row++) {
		rrow     = irow ? irow[sr+row*rinc] : sr + row*rinc;
		sv       = R->rs[rrow];
		ccol     = icol ? icol[*doff+row*rinc] : *doff + row*rinc;
		sv->i[d] = ccol;
		sv->v[d] = *dv;
		}
	    doff++;
	    dv++;
	    }
	break;
	
	case DIAG_USER:
	/* We don't know what to do in this case */
	break;
	}
    }
return B;
}

