/*
      These are some routines needed for the Jacobi preoconditioner.
*/
#include "solvers/svctx.h"
#include "solvers/svpriv.h"
#include <math.h>

/*ARGSUSED*/
void SViCreateJacobi(ctx,mat)
SVctx *ctx;
SpMat *mat;
{
  SVJacobictx *lctx;
  lctx = NEW(SVJacobictx); CHKPTR(lctx);
  ctx->method = ITGMRES; 
  ctx->private = (void *) lctx;
  ctx->is_iter = 1;

  ctx->setup   = SViSetupJacobi;
  ctx->solve   = SViSolveJacobi;
  ctx->destroy = SViDestroyJacobi;
}
/*------------------------------------------------------------------*/
void SViSetupJacobi(ctx)
SVctx *ctx;
{
  SVJacobictx *lctx = (SVJacobictx *) ctx->private;
  int         i,n = ctx->size;
  double      t1;

  t1 = SYGetCPUTime();
  lctx->diag = (double *) MALLOC(n*sizeof(double)); CHKPTR(lctx->diag);
  SpGetDiagonal(ctx->mat,0,0,n-1,lctx->diag); CHKERR(1);
  for (i=0; i<n; i++) lctx->diag[i] = 1.0/lctx->diag[i];

  ctx->itctx = ITCreate(ctx->method);  CHKERR(1);
  DVSetDefaultFunctions(ctx->itctx->vc); CHKERR(1);
  ctx->itctx->amult = SViMult;
  ctx->itctx->tamult= SViMultTrans;
  ctx->itctx->binv  = SViApplyJacobiPreconditioner;
  /* put dummy values in vec_sol and vec_rhs */
  ctx->itctx->vec_sol = (void *) 1; 
  ctx->itctx->vec_rhs = (void *) 1; 
  ctx->itctx->usr_monitor = 0; 

  ctx->flops  = n;
  ctx->memory = n*sizeof(double);
  ctx->nzorig = SpNz(ctx->mat);
 
  ctx->setupcalled = 1;
  ctx->t_setup += SYGetCPUTime() - t1;
}
/*------------------------------------------------------------------*/
int SViSolveJacobi(ctx,b,x)
SVctx  *ctx;
double *b,*x;
{
  int         its;
  double      t1;
  if (!ctx->setupcalled) (*ctx->setup)(ctx); CHKERRV(1,-1);
  if (!ctx->solvecalled) {
      t1 = SYGetCPUTime();
      ITSetUp(ctx->itctx,(void *) ctx); CHKERRV(1,-1);
      ctx->t_setup += SYGetCPUTime() - t1;
      }
  ctx->solvecalled = 1;

  t1 = SYGetCPUTime();
  SViManageInitialGuess( ctx, x );
  ctx->itctx->vec_rhs = (void *) b;
  ctx->itctx->vec_sol = (void *) x;
  its = ITSolve(ctx->itctx,(void *) ctx);
  SVGetITFlops(ctx,2*ctx->nzorig,2*ctx->size);
  ctx->its = its;
  ctx->t_solve += SYGetCPUTime() - t1;
  return its;
}
/*------------------------------------------------------------------*/
void SViDestroyJacobi(ctx)
SVctx *ctx;
{
  SVJacobictx *lctx = (SVJacobictx *) ctx->private;
  VEDestroy(ctx->itctx->vc);
  ITDestroy(ctx->itctx,ctx);
  FREE(lctx->diag); FREE(ctx->private); FREE(ctx);
}
/*------------------------------------------------------------------*/
void SViApplyJacobiPreconditioner(ctx,x,y)
SVctx  *ctx;
double *x,*y;
{
  register double *d = ((SVJacobictx *)ctx->private)->diag;
  register int    n = ctx->size, i;

  ctx->nbinv++;

  /* Using a for-loop encourages the compiler to unroll the loop */
  for (i=0; i<n; i++) y[i] = d[i] * x[i];
}
