c$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
c$$$                                                           $$$
c$$$        Set up stuff for Bill Gropp's solver routine       $$$
c$$$                                                           $$$
c$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$

        PROGRAM MAIN
        integer   ITRICHARDSON, ITCHEBYCHEV, ITCG, ITGMRES, 
     *       ITTCQMR, ITBCGS, ITCGS, ITTFQMR
        parameter (ITRICHARDSON = 0, ITCHEBYCHEV = 1, ITCG = 2, 
     *       ITGMRES = 3, ITTCQMR = 5, ITBCGS = 6, ITCGS = 7,
     *       ITTFQMR = 8)

        integer   SVLU, SVJACOBI, SVSSOR, SVILU, SVICC, SVICCJP,SVNOPRE
        parameter ( SVLU = 0, SVJACOBI = 1, SVSSOR = 2, SVILU = 3 )
        parameter ( SVICC = 4, SVICCJP = 5, SVNOPRE = 8)

        integer   ORDER_RCM, ORDER_QMD, ORDER_ND, ORDER_1WD
        parameter ( ORDER_RCM = 0, ORDER_QMD = 1, ORDER_ND = 2 )
        parameter ( ORDER_1WD = 3 )
       
        integer   svcreate, svsetup
        integer   svsolve, SVSetRelativeTol
        integer   spdncreatefromdata
        integer   spdnclamptosparse, smatrix
        integer   pmatrix, solver, err, its
        

        double precision b(3) , x(3), a(3,3)

c       initialize the problem
c	call sysetfptraps()
	b(1) = 3
	b(2) = 5
	b(3) = 21
	a(1,1) = 1
	a(1,2) = 1
	a(1,3) = 1
	a(2,1) = 0
	a(2,2) = 1
	a(2,3) = -2
	a(3,1) = 0
	a(3,2) = 0
	a(3,3) = 3

c$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
c$$$                                                              $$$
c$$$          Setup for solver routines                           $$$
c$$$                                                              $$$
c$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$


c$$$
c$$$ create matrix wrapper for B.Gropp's routines
c$$$ where pmatrix is the "pointer" to Matrix used by the routines
c$$$

        pmatrix = SpDnCreateFromData(3,3,3,a)

c$$$
c$$$  Create a sparse matrix from dense matrix
c$$$

c      smatrix = spdnclamptosparse(pmatrix, 0.0d0, 17)
c$$$
c$$$  create solver context
c$$$

        solver = svcreate(pmatrix,SVLU)
c$$$
c$$$  setup solver context, using a preconditioner. 
c$$$  note that svset<precondmat and svsetacc are called before
c$$$  svsetup(solver)
c$$$

c       call svsetprecondmat( solver, smatrix)
c       call SVSetAccelerator(solver, ITGMRES)

        err = svsetup(solver)
c       err = SVSetRelativeTol(solver,1.d-8)

c$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
c$$$                                                               $$$
c$$$          Done setting up stuff for Bill's routines            $$$
c$$$                                                               $$$
c$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$



c$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$
c$$$                                                                 $$$
c$$$ Solve the matrix with Bill Gropp's Linear Solver Routine        $$$
c$$$                                                                 $$$
c$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$$       



c$$$
c$$$ Zero the solution vector to pass into svsolve
c$$$

        do i = 1,3
           x(i) = 0.0d0
        end do

c$$$
c$$$ Solve the linear system
c$$$
        its = svsolve(solver, b, x)

c$$$
c$$$ copy the solution vector to the RHS for Lauri's use
c$$$

        do i = 1, 3
	  print*, 'x(',i,') = ',x(i)
        end do


        stop
	end












