c
c     Fortran program to test Fortran interface to solvers routines
c
c
C
C      Include file for parameters for Simplified Linear Equation Solvers
       INTEGER SVLU, SVJacobi, SVSSOR, SVILU, SVICC, SVICCJP, SVBDD, 
     *         SVOSM, SVNOPRE
       PARAMETER( SVLU = 0, SVJacobi = 1, SVSSOR = 2, SVILU = 3, 
     *            SVICC = 4, SVICCJP = 5, SVBDD = 6, SVOSM = 7,
     *            SVNOPRE = 8 )
       INTEGER  ORDERRCM, ORDERQMD, ORDERND, ORDER1WD
       PARAMETER ( ORDERRCM = 0, ORDERQMD = 1, ORDERND = 2, 
     *             ORDER1WD = 3 )
       INTEGER PIVOT_NONE, PIVOT_PRE_SYM, PIVOT_PRE_NONSYM, PIVOT_ACTIVE
       PARAMETER ( PIVOT_NONE = 0, PIVOT_PRE_SYM = 1, 
     *             PIVOT_PRE_NONSYM = 2, PIVOT_ACTIVE = 3 )
       INTEGER ITRICHARDSON, ITCHEBYCHEV, ITCG, ITGMRES, 
     *         ITCGSPLIT, ITTCQMR, ITBCGS, ITCGS, ITTFQMR, ITLSQR,
     *         ITPREONLY
       PARAMETER( ITRICHARDSON = 0, ITCHEBYCHEV = 1, ITCG = 2, 
     *         ITGMRES = 3, ITCGSPLIT = 4, ITTCQMR = 5, ITBCGS = 6, 
     *         ITCGS = 7, ITTFQMR = 8, ITLSQR = 9, ITPREONLY = 10 )
C
C      End of Include file for parameters for 
C      Simplified Linear Equation Solvers
c
       integer   spcreate, svcreate
       integer   svsolve
c
c
       parameter ( N = 20 )
       integer          matrix, solver, flag, its
       double precision b(N), x(N), r(N), norm
c
c   create example right hand side 
c
       do 10 i=1,N
          b(i) = i
 10    continue
c
c   create example matrix, 1D discrete Laplaciain
c
       flag = 0
       matrix = spcreate(N,N,0)
       if ( matrix .eq. 0 ) goto 100

       flag = 1
       call spaddvalue(matrix,2.d0,0,0)
       call spaddvalue(matrix,-1.d0,0,1)
       do 20 i=1,N-2
         call spaddvalue(matrix,-1.d0,i,i-1)
         call spaddvalue(matrix,2.d0,i,i)
         call spaddvalue(matrix,-1.d0,i,i+1)
 20    continue
       call spaddvalue(matrix,2.d0,N-1,N-1)
       call spaddvalue(matrix,-1.d0,N-1,N-2)
c
c       call spprint(0,matrix)
c
c   create solver context 
c
       flag = 2
       solver = svcreate(matrix,SVSSOR)
       if ( solver .eq. 0 ) goto 100
c
c   set nested dissection for matrix ordering 
c
       call svsetluordering(solver,ORDER_ND)
c
c   setup solver context    
c
       flag = 3
       call svsetup(solver)
       call svsetrelativetol(solver,1.d-8)
c
c   solve a linear system
c
       flag = 4
       its = svsolve(solver,b,x)
       if ( its .eq. -1 ) goto 100
c
c   free the space used by solver
c
       flag = 5
       call svdestroy(solver)
c
c   calculate residual
c
       flag = 6
       call spmult(matrix,x,r)
       norm = 0.d0
       do 30 i=1,N
         r(i) = b(i) - r(i)
         norm = norm + r(i)*r(i)
 30    continue
       norm = dsqrt(norm)
       print*, 'Iterations ',its, ' Norm of residual',norm
c
c   free the space used by matrix
c
       flag = 7
       call spdestroy(matrix)
       stop 

 100   continue
       print*, 'Error in call to libraries',flag
       end
