#ifndef lint
static char SCCSid[] = "@(#) ./comm/io/piounbuf.c 07/23/93";
#endif

#include "tools.h"
#include "comm/comm.h"
#include "comm/io/pio.h"
#ifndef SEEK_SET
#include <unistd.h>
#endif

#define READ  (*fp->read)
#define WRITE (*fp->write)
#define LSEEK (*fp->lseek)

/* Eventually, this could buffer data, particularly if the data is 
   contiguous.  It will be slow until it DOES buffer the data.

   This routine should be paired up with the one to handle waiting until
   the buffer is empty.
 */
void PIiRwriter( fp, buf, n, offset )
PIFILE *fp;
char   *buf;
int    n, offset;
{
int nbytes, err;
int lroot;

lroot  = PSROOT(fp->procset);
if (PImytid == lroot) {
    /* printf( "lWriting %d bytes at offset %d\n", n-sizeof(long), offset ); */
    LSEEK( fp->fd, offset, SEEK_SET );
    err = WRITE( fp->fd, buf+sizeof(long), n );
    if (err != n) {
	SETERRC(1,"Write failed" );
	}
    while (fp->rcnt && PInprobe(fp->mtype)) {
	PIbrecv( fp->mtype, fp->sbuf, fp->bsize, MSG_OTHER );
	nbytes = PIsize() - sizeof(long);
	if (nbytes < 0) fp->rcnt--;
	else {
	    /* printf( "Writing %d bytes at offset %d\n", 
	               nbytes, fp->sbuf[0] ); */
	    LSEEK( fp->fd, fp->sbuf[0], SEEK_SET );
	    err = WRITE( fp->fd, fp->sbuf+1, nbytes );
	    if (err != nbytes) {
		SETERRC(1,"Write failed");
		}
	    }
	}
    }
else {
    PIbsend( fp->mtype, buf, n + sizeof(long), lroot, MSG_OTHER );
    }
}

/*ARGSUSED*/
void PIiRwriterWait( fp, datatype, finalloc )
PIFILE *fp;
int    datatype, finalloc;
{
int nbytes, myroot;

myroot   = PSROOT(fp->procset);
if (PImytid == myroot) {
    /* Act as a server for the other nodes */
    while (fp->rcnt) {
	PIbrecv( fp->mtype, fp->sbuf, fp->bsize, datatype );
	nbytes = PIsize() - sizeof(long);
	if (nbytes < 0) fp->rcnt--;
	else {
	    LSEEK( fp->fd, fp->sbuf[0], SEEK_SET );
	    WRITE( fp->fd, fp->sbuf+1, nbytes );
	    }
	}
    }
else {
    /* Send I'm done message */
    PIbsend( fp->mtype, &myroot, 0, myroot, MSG_INT );
    }
}

/* 
   Eventually, this could buffer data, particularly if the data is 
   contiguous.  It will be slow until it DOES buffer the data.

   This is the algorithm:  Each processor sends a request consisting of
   and offset and a length.  The data is then returned to the sender.
   A request of 0 bytes indicates that that processor has completed.
*/
void PIiRreader( fp, buf, n, offset )
PIFILE *fp;
char   *buf;
int    n, offset;
{
int nbytes, err, from, ibuf[2]; 
int lroot;

lroot  = PSROOT(fp->procset);
/* printf( "[%d] lroot = %d\n", PImytid, lroot ); */
if (PImytid == lroot) {
    while (fp->rcnt && PInprobe(fp->mtype)) {
	PIbrecv( fp->mtype, ibuf, 2*sizeof(int), MSG_INT );
	if (PIsize() <= 0) fp->rcnt--;
	else {
	    from   = PIfrom();
	    nbytes = ibuf[1]; 
	    LSEEK( fp->fd, ibuf[0], SEEK_SET );
	    err = READ( fp->fd, fp->sbuf+1, nbytes );
	    if (err != nbytes) {
		SETERRC(1,"Read failed");
	        }
	    PIbsend( fp->mtype, fp->sbuf+1, nbytes, from, MSG_OTHER );
	    }
        }    
/*    printf("!%d\n", offset); */
    LSEEK( fp->fd, offset, SEEK_SET );
    err = READ( fp->fd, buf+sizeof(long), n );
#ifdef DEBUG_ALL
    if (err != n) {
	char ebuf[100];
	sprintf( ebuf, "Read failed, read %d expected %d bytes", err, n );
	SETERRC(1,ebuf );
	}
#endif
    }   
else {
    ibuf[0] = offset;
    ibuf[1] = n ;
    PIbsend( fp->mtype, ibuf, 2*sizeof(int), lroot, MSG_INT );
    PIbrecv( fp->mtype, buf+sizeof(long), n+sizeof(long), MSG_OTHER );
    }
}

void PIiRreaderWait( fp, datatype )
PIFILE *fp;
int    datatype;
{
int nbytes, myroot, from, err;

myroot   = PSROOT(fp->procset);
if (PImytid == myroot) {
    while (fp->rcnt) {
	PIbrecv( fp->mtype, fp->sbuf, 2*sizeof(int), MSG_INT );
	if (PIsize() <= 0) fp->rcnt--;
	else {
	    from   = PIfrom();
	    nbytes = fp->sbuf[1];
	    /* printf( "Writing %d bytes at offset %d\n", 
	       nbytes, fp->sbuf[0] ); */
	    LSEEK( fp->fd, fp->sbuf[0], SEEK_SET );
	    err = READ( fp->fd, fp->sbuf+1, nbytes );
	    if (err != nbytes) {
		SETERRC(1,"Read failed");
		}
	    PIbsend( fp->mtype, fp->sbuf+1, nbytes, from, MSG_OTHER );
	    }
	}
    }
else {
    /* Send I'm done message */
    PIbsend( fp->mtype, &myroot, 0, myroot, MSG_INT );
    }
}
