
#ifndef MSG_GLOBAL
/* I need to get these message types from a registry and MSGTYPERANGE */
#if defined(ncube) || defined(eui)
#define MSG_GLOBAL      0x4000
#define MSG_GLOBAL_UP   (MSG_GLOBAL | MSG_UP)
#define MSG_GLOBAL_DN   (MSG_GLOBAL | MSG_DN)
#define MSG_UP          0x2000
#define MSG_DN          0x0000
#define MSG_LEFT        0x0800
#define MSG_RIGHT       0x0000
#define MSG_PHASE_SHFT  14
#define MSG_PKTCNT_SHFT 8
#define MSG_PKTCNT_MASK 0x0007
#define MSG_NAME_MASK   0x00ff
#else
#define MSG_GLOBAL      0x20000000
#define MSG_GLOBAL_UP   (MSG_GLOBAL | MSG_UP)
#define MSG_GLOBAL_DN   (MSG_GLOBAL | MSG_DN)
#define MSG_UP          0x10000000
#define MSG_DN          0x00000000
#define MSG_PHASE_SHFT  27
#define MSG_LEFT        0x04000000
#define MSG_RIGHT       0x00000000
#define MSG_PKTCNT_SHFT 19
#define MSG_PKTCNT_MASK 0x0000007f
#define MSG_NAME_MASK   0x0000ffff
#endif
/*
   This sets the message type to use.  Note that these CAN be selected
   by the ANY_TYPE type, so the user must be careful when using them.
   The approach is to use a type field with the following elements:
   global (bit 29) up/down (bit 28) phase (bit 27)
   left/right (bit 26) packet_count (bits 25-19) procset_name (bits 0-15)
   (These are for 32 bit types.  16 bit types are more constrained.)

   Note that LEFT/RIGHT and PKTCNT may not be used in some cases.
 */   
#define GMSGPHASE(pset,lphase) {\
lphase = (pset)->ctxoff; (pset)->ctxoff = !lphase ; \
lphase <<= MSG_PHASE_SHFT; lphase |= ((pset)->name & MSG_NAME_MASK);}

#define GMSGTYPE(pset,dir) ((MSG_GLOBAL | dir) | ((pset)?((pset)->name):0))
#define GMSGTYPEPKT(pset,dir,cnt,phase) \
(MSG_GLOBAL | dir | (((cnt)&MSG_PKTCNT_MASK)<<MSG_PKTCNT_SHFT) | \
    ((phase)<<MSG_PHASE_SHFT ) | ((pset) ? (pset)->name:0))

extern void (*PIcomb)();
extern void (*PIscatter)();
extern void (*PIcol)();
extern void (*PIsync)();

/* See the comments in global.c about this */
extern int  _PIPKTSIZE;

/* Ready-receiver threshold */
extern int _PIRRSIZE;

/* For the global operations on all nodes using tree or ring */
extern int _PILCHILD, _PIRCHILD, _PIPARENT, _PIPHASE, _PIAM_LEFT;
extern int _PIRIGHT, _PILEFT;

/* For ... */
extern int _PINONASSOCIATIVE;

#endif
