/*
   This is a test program for the mesh communications code.
   This times the communication
 */
#include "comm/comm.h"
#include "blkcm/bc.h"
#include "blkcm/mesh.h"

double *BuildDomain();
extern char *malloc();

main( )
{
BCPGM      *Program;
double     *p0, t0, t1, dclock();
int        nx, ny, mx, my, pgmn, i, cnt;

/*
   Allocate some meshes and set initial data (index location).  There are
   four domains arranged in a four-by-four pattern, with the edges connected
   periodically.

   +---+---+
   | 2 | 3 |
   +---+---+
   | 0 | 1 |
   +---+---+

   There is one domain per processor.
 */
nx = 30;
ny = 40;
mx = nx + 2;
my = ny + 2;

p0 = BuildDomain( nx, ny, mx, my, MYPROCID*nx*ny );
Program = BCBuildMesh( mx, my, 0, nx, ny, p0+(mx+1), BCBuildProcMap( 2, 2 ) );

/* Initialize the communication */
BCcompile( Program, 
 	      BCOPTION_BUFFER | BCOPTION_PAIRSYNC | BCOPTION_TRIMMOVE );
/* 	      BCOPTION_BUFFER | BCOPTION_PAIRSYNC ); */
/* BCcompile( Program, BCOPTION_BUFFER ); */
/* Experimentally, using PAIRSYNC reduced time from .001374 to .001246 */

GSYNC(0);
t0 = dclock();
/* Do the exchanges */
cnt = 100;
while (cnt--)
    BCexec( Program, 0 );
t1 = dclock();
t1 = (t1 - t0)/100.0;
printf( "time for a share of boundaries is %f\n", t1 );
exit( 0 );
}

double *BuildDomain( nx, ny, mx, my, off )
int nx, ny, mx, my, off;
{
double *p, *p1;
int    n, i;
p = p1 = (double *)malloc( (unsigned)(mx * my * sizeof(double) ) );
n = mx * my;
while (n--)
    *p1++ = 0.0;
p1 = p + 1 + mx;      /* buffer size of 1 assumed */
i  = off;
while (ny--) {
    n = nx;
    while (n--)
        *p1++ = i++;
    p1 += mx - nx;
    }
return p;
}

