/*
 *
 * $Source: /filesv/usr/local/proj/sphinx/spx2/src/lib/auth/RCS/read_certif.c,v $
 *
 *
 *  MODULE NAME:    read_certif.c
 *
 *
 *  AUTHORS:
 *
 *	K. Alagappan
 *
 */


/*
 * COPYRIGHT (C) 1992 DIGITAL EQUIPMENT CORPORATION
 * ALL RIGHTS RESERVED
 *
 * "Digital Equipment Corporation authorizes the reproduction,
 * distribution and modification of this software subject to the following
 * restrictions:
 * 
 * 1.  Any partial or whole copy of this software, or any modification
 * thereof, must include this copyright notice in its entirety.
 *
 * 2.  This software is supplied "as is" with no warranty of any kind,
 * expressed or implied, for any purpose, including any warranty of fitness 
 * or merchantibility.  DIGITAL assumes no responsibility for the use or
 * reliability of this software, nor promises to provide any form of 
 * support for it on any basis.
 *
 * 3.  Distribution of this software is authorized only if no profit or
 * remuneration of any kind is received in exchange for such distribution. 
 * 
 * 4.  This software and all application programs are to be used only for
 * non-commercial purposes. However, media costs associated with the
 * distribution of the software or application programs may be recovered.
 *
 */


/*
 *  This program reads a file of text as hex bytes and produces the 
 *  buffer of the binary values.
 *
 *  The file name is taken from the first parameter on the command
 */

#include <stdio.h>
#include "cdc.h"

int read_certif(issuer, subject, asn1_certif, certiflen)
char *issuer;
char *subject;
char *asn1_certif;
int  *certiflen;
{
  char certifile[60], domain[FULLNAME_SZ], new_subj[40], new_issu[40];
  int i, hex1,hex2;
  FILE *f;

  if ((strcmp(subject, ".") == 0) || (strcmp(issuer,".") == 0)) {
    strcpy(domain, get_domain_name(NULL));
    i = strlen(domain);
  }
  if (strcmp(subject,".") == 0) {
    while (domain[--i] != '=');
    strcpy(new_subj, &domain[++i]);
  } else strcpy(new_subj, subject);
  if (strcmp(issuer,".") == 0) {
    while (domain[--i] != '=');
    strcpy(new_issu, &domain[++i]);
  } else strcpy(new_issu, issuer);

  if (subject[0] != '\0') {
    strcpy(certifile, new_issu);
    strcat(certifile, "_certif_");
    strcat(certifile, new_subj);
  } else strcpy(certifile, issuer);

  if ((f = fopen(certifile,"r")) == NULL) {
    printf("%s: Could not open - %s\n",__FILE__,certifile);
    return(-1);
  }
  /* loop through file */
  i = 0;
  while ( fscanf(f," %1x%1x",&hex1,&hex2) == 2) {
    asn1_certif[i] = (hex1<<4)+hex2;
    i++;
  }
  close(f);
  *certiflen = i;
  return(0);
}
