/* Copyright 1989 Dave Bayer and Mike Stillman. All rights reserved. */
#include "vars.h"
#include "stats.h"

poly divnode ;
extern int autoReduce ;	/* >0 means don't autoreduce */
extern int showpairs ;	/* >0 means call spairs_flush */

init_division()
{
    divnode = p_listhead() ;
}
 
deb_print(f, n)
poly f ;
int n ;
{
	int i ;

	print("[") ;
	for (i=1; i<n; i++) {
		p_pprint(stdout, f, i) ;
		print(", ") ;
	}
	p_pprint(stdout, f, n) ;
	print("]\n") ;
}

poly 
reduce(M, f)
gmatrix M ;
poly *f ;
{
    mn_standard i ;
    allocterm t ;
    poly inresult ;
 
    inresult = divnode ;
    while (*f ISNT NULL) {
	if (mo_find_div(M, INITIAL(*f), &i, t)) {
            special_sub(f, LEAD_COEF(*f), t, i->standard) ;
        } else if (autoReduce <= 0) {
            inresult->next = *f ;
            inresult = *f ;
            *f = (*f)->next ;
        } else {
	    inresult->next = *f ;
	    return(divnode->next) ;
	}
    }
    inresult->next = NULL ;
    return(divnode->next) ;
}
 
division(M, f, g, h)
gmatrix M ;
poly *f ;
poly *g, *h ;
{
    poly inresult ;
    mn_standard i ;
    allocterm t ;
 
    STAT(stdiv) ;
    *g = NULL ;
    inresult = divnode ;
    while (*f ISNT NULL) {
	STAT(stloop) ;
	if (mo_find_div(M, INITIAL(*f), &i, t)) {
            special_sub(g, LEAD_COEF(*f), t, i->change) ;
            special_sub(f, LEAD_COEF(*f), t, i->standard) ;
        } else if (autoReduce <= 0) {
            inresult->next = *f ;
            inresult = *f ;
            *f = (*f)->next ;
        } else {
	    inresult->next = *f ;
	    *f = NULL ;
	    *h = divnode->next ;
	    return ;
	}
    }
    inresult->next = NULL ;
    *h = divnode->next ;
}
 
/*------ calc. standard basis routines -----------------*/
 
boolean 
calc_standard(M, deg, B)
gmatrix M ;
int deg ;
variable *B ;
{
    mn_standard i, j ;
    poly h, hrep ;
 
    if (ncols(M) > 0) {
	prflush(".") ;
	if (showpairs > 0)
	  spairs_flush(M);
    }
    mo_reset(M, &i, &j) ;
    while (mo_next_pair(M, deg, &i, &j)) {
        calc_s_pair(M, i, j, &h, &hrep) ;
        send_off(M, deg, B, h, hrep) ;
    }
    return(mo_iscomplete(M, deg)) ;
}
 
extern int showapair;

send_off(M, deg, B, h, hrep)
gmatrix M ;
int deg ;
variable *B ;
poly h, hrep ;
{
    if (showapair) {
	spairs_flush(M);
	showapair = 0;
    }
    if (h ISNT NULL) {
        ins_elem(M, deg, h, hrep) ;
	if (verbose > 0) {
	    prflush("m") ;
	    if (showpairs > 2) spairs_flush(M);
	}
    } else if (hrep ISNT NULL) {
        send_poly(B, hrep, deg) ;
	if (verbose > 0) {
	    prflush("s") ;
	    if (showpairs > 3) spairs_flush(M);
	}
    } else if (verbose > 0) {
	prflush("o") ;
	if (showpairs > 3) spairs_flush(M);
    }
    intr_shell() ;
} /* 5/18/89 DB 5/6 */
 
 
calc_s_pair(M, i, j, h, hrep)
gmatrix M ;
mn_standard i, j ;
poly *h, *hrep ;
{
    allocterm s1, s2 ;
    poly f, k ;
 
    tm_joinminus(INITIAL(i->standard),
                 INITIAL(j->standard),
                 s1, s2) ;
    f = mult_sub(s1, i->standard,
                 s2, j->standard) ;
    k = mult_sub(s1, i->change,
                 s2, j->change) ;
    division(M, &f, hrep, h) ;
    p_add(hrep, &k) ;
}
 
ins_elem(M, deg, h, hrep)
gmatrix M ;
int deg ;
poly h, hrep ;
{
    mn_standard i ;
 
    make2_monic(&h, &hrep) ;
    i = (mn_standard) get_slug(std_stash) ;
    i->standard = h ;
    i->change = hrep ;
    i->next = M->stdbasis ;
    i->ismin = (char) TRUE ;
    M->stdbasis = i ;
    M->nstandard++ ;
    M->modtype = MSTD ;
    mo_insert(M, INITIAL(h), i) ;
    if (autoReduce <= 0) auto_reduce(M, deg, h, hrep) ;
}
 
auto_reduce(M, deg, h, hrep)
gmatrix M ;
int deg ;
poly h, hrep ;
{
    mn_standard i ;
    field a ;
 
    i = M->stdbasis->next ;	/* don't start with current (h,hrep) */
    while ((i ISNT NULL) AND (degree(M, i->standard) IS deg)) {
        if (occurs_in(i->standard, INITIAL(h), &a)) {
            special_sub(&i->standard, a, zerodegs, h) ;
            special_sub(&i->change, a, zerodegs, hrep) ;
        }
	i = i->next ;
    }
}
 
boolean 
occurs_in(f, t, a)
poly f ;
term t ;
field *a ;
{
    int comp ;
 
    while (f ISNT NULL) {
        comp = tm_compare(INITIAL(f), t) ;
        if (comp IS LT) return(FALSE) ;
        if (comp IS EQ) {
            *a = LEAD_COEF(f) ;
            return(TRUE) ;
        }
        f = f->next ;
    }
    return(FALSE) ;
}
 
/*-----------------------------------------------------------*/
 
orig_gens(M, deg, intval, box)
gmatrix M ;
int deg, intval ;
variable *box ;
{
    int i ;
    poly f, h, hrep, k ;
 
    for (i=1; i<=LENGTH(M->gens); i++)
        if (DREF(M->deggens, i) IS deg) {
            f = p_copy(PREF(M->gens, i)) ;
            division(M, &f, &hrep, &h) ;
	    if ((intval < 0) OR (intval >= i)) {
		k = e_sub_i(i) ;
		p_add(&hrep, &k) ;
	    } 
            send_off(M, deg, box, h, hrep) ;
        }
}
 
ins_generator(box, f, deg)
variable *box ;
poly f ;
int deg ;
{
    poly h, hrep ;
    int i ;
    gmatrix M ;

    M = VAR_MODULE(box) ;
    h = reduce(M, &f) ;

    if (h IS NULL) return ;
    make1_monic(&h) ;
    pl_insert(&(M->gens), h) ;
    i = LENGTH(M->gens) ;
    dl_insert(&(M->deggens), deg) ;
    h = p_copy(h) ;
    if ((box->intval < 0) OR (box->intval >= i))
	hrep = e_sub_i(i) ;
    else hrep = NULL ;
    ins_elem(M, deg, h, hrep) ;
}
