/* Copyright 1989 Dave Bayer and Mike Stillman. All rights reserved. */
#include "hull.h"

extern int verbose;
static facet_id = 0;

link *
new_link()
/* return new link */
{
	return (link *) get_slug(h_linkstash);
}

void
free_link(p)
link *p;
/* dispose of storage for link p */
{
	free_slug(h_linkstash, p);
}	

facet *
new_facet()
/* return new facet */
{
	facet *p;
	
	p = (facet *) get_slug(h_facetstash);
	p->p = NULL;
	p->spawn = NULL;
	p->up = NULL;
	p->dn = NULL;
	p->v = NULL;
	p->light = 0;
	p->critical = 0;
	p->dark = 0;
	p->verified = 0;
	p->id = ++facet_id;
	return p;
}

void
free_facet(p)
facet *p;
/* dispose of storage for facet p */
{
	free_slug(h_facetstash, p);
}

void
join_links(fup, fdn)
facet *fup, *fdn;
{
	link *lup, *ldn;
	lup = new_link();
	ldn = new_link();
	
	lup->p = fup->dn;
	fup->dn = lup;
	lup->f = fdn;
	
	ldn->p = fdn->up;
	fdn->up = ldn;
	ldn->f = fup;
}

void
cut_links(fup, fdn)
facet *fup, *fdn;
{
#ifdef ANSI
 #pragma unused(fup,fdn)
#endif
}

void
write_normal(f, p, i1, i2, i3, i4)
facet *f;
matrix *p;
int i1, i2, i3, i4;
/* write equation of face formed by rows i1..3, v.x > c for i4 */
{
	matrix *q;
	vector *v, *w;
	long s;
	
	q = new_matrix(0,4);
	v = add_vectors(1L, p->v[i2], -1L, p->v[i1]);
	q = adjoin_row(q, v);
	free_vector(v); 
	v = add_vectors(1L, p->v[i3], -1L, p->v[i1]);
	q = adjoin_row(q, v);
	free_vector(v);
	v = add_vectors(1L, p->v[i4], -1L, p->v[i1]);
	w = normal_vector(q,v);
	s = dot_prod(w,v);
	ERROR_IF(s == 0, "write_normal");
	if (s < 0) neg_vector(w);
	f->c = dot_prod(w, p->v[i1]);
	f->v = w;
	free_vector(v);
}

facet **
tope3(p)
matrix *p;
{
	facet **q;
	facet *f0, *f1, *f2, *f3;
	facet *f01, *f02, *f03, *f12, *f13, *f23;
	facet *f012, *f013, *f023, *f123;
	void screen_tope();
	
	q = (facet **) gimmy(3*sizeof(facet *));
	f0 = new_facet(4);
	f1 = new_facet(4);
	f2 = new_facet(4);
	f3 = new_facet(4);
	f01 = new_facet(4);
	f02 = new_facet(4);
	f03 = new_facet(4);
	f12 = new_facet(4);
	f13 = new_facet(4);
	f23 = new_facet(4);
	f012 = new_facet(4);
	f013 = new_facet(4);
	f023 = new_facet(4);
	f123 = new_facet(4);
	q[0] = f0;
	f0->p = f1;
	f1->p = f2;
	f2->p = f3;
	q[1] = f01;
	f01->p = f02;
	f02->p = f03;
	f03->p = f12;
	f12->p = f13;
	f13->p = f23;
	q[2] = f012;
	f012->p = f013;
	f013->p = f023;
	f023->p = f123;
	join_links(f012,f01); join_links(f012,f02); join_links(f012,f12);
	join_links(f013,f01); join_links(f013,f03); join_links(f013,f13);
	join_links(f023,f02); join_links(f023,f03); join_links(f023,f23);
	join_links(f123,f12); join_links(f123,f13); join_links(f123,f23);
	join_links(f01,f0); join_links(f01,f1);
	join_links(f02,f0); join_links(f02,f2);
	join_links(f03,f0); join_links(f03,f3);
	join_links(f12,f1); join_links(f12,f2);
	join_links(f13,f1); join_links(f13,f3);
	join_links(f23,f2); join_links(f23,f3);
	f0->v = copy_vector(p->v[0]);
	f1->v = copy_vector(p->v[1]);
	f2->v = copy_vector(p->v[2]);
	f3->v = copy_vector(p->v[3]);
	write_normal(f012, p, 0,1,2,3);
	write_normal(f013, p, 0,1,3,2);
	write_normal(f023, p, 0,2,3,1);
	write_normal(f123, p, 1,2,3,0);
	return q;
}

void
output_pos_coords(p, fp)
facet *p;
FILE *fp;
{
	int i;
	long *v, max, w[4], d;
	
	v = p->v->v;
	max = 0;
	for (i=0; i<4; ++i)
		if (v[i] > max) max = v[i];
	for (i=0; i<4; ++i)
		w[i] = max - v[i];
	d = 0;
	for (i=0; i<4; ++i)
		d = gcd_long(d, w[i]);
	if (d != 0)
		for (i=0; i<4; ++i)
			w[i] /= d;
	for (i=0; i<4; ++i)
		fprintf(fp, " %ld", w[i]);
	fprintf(fp, "\n");
}

void
output_coords(p, fp)
facet *p;
FILE *fp;
{
	int i;
	long *v;
	
	v = p->v->v;
	for (i=0; i<4; ++i)
		fprintf(fp, " %ld", v[i]);
	fprintf(fp, "\n");
}

void
output_point(p, fp)
facet *p;
FILE *fp;
{
	double x1, x2, x3;
	
	x1 = p->v->v[0] -  p->v->v[1];
	x2 = p->v->v[2] -  p->v->v[3];
	x3 = (p->v->v[0] + p->v->v[1] 
		- p->v->v[2] -  p->v->v[3]) / sqrt(2.);
	fprintf(fp, "%f %f %f", x1, x2, x3);
	output_coords(p, fp);
}

void
output_edge(p, fp)
facet *p;
FILE *fp;
{
	link *q;
	
	q = p->dn;
	fprintf(fp, "%d ", q->f->id);
	q = q->p;
	fprintf(fp, "%d ", q->f->id);
	q = p->up;
	fprintf(fp, "%d ", q->f->id);
	q = q->p;
	fprintf(fp, "%d ", q->f->id);
	fprintf(fp, "\n");	
}

void
output_face(p, fp)
facet *p;
FILE *fp;
{
	double x1, x2, x3;
	
	x1 = p->v->v[0] -  p->v->v[1];
	x2 = p->v->v[2] -  p->v->v[3];
	x3 = (p->v->v[0] + p->v->v[1] 
		- p->v->v[2] -  p->v->v[3]) / sqrt(2.);
	fprintf(fp, "%f %f %f %f", x1, x2, x3, (double) 2*p->c);
	output_pos_coords(p, fp);
}

void
output_tope(q)
facet **q;
{
	facet *p;
	int v, e, f;
	
	ERROR_IF(h_fout == NULL, "output_tope");
	for (v=0, p=q[0]; p!=NULL; p=p->p) p->id = ++v;
	for (e=0, p=q[1]; p!=NULL; p=p->p) p->id = ++e;
	for (f=0, p=q[2]; p!=NULL; p=p->p) p->id = ++f;
	fprintf(h_fout, "%d %d %d 1\n", v, e, f);
	for (p=q[0]; p!=NULL; p=p->p) output_point(p, h_fout);
	for (p=q[1]; p!=NULL; p=p->p) output_edge(p, h_fout);
	for (p=q[2]; p!=NULL; p=p->p) output_face(p, h_fout);
	fprintf(h_fout, "v 0 0 0 \n");
}

void
count_tope(q)
facet **q;
{
	facet *p;
	int v, e, f, d;
	void screen_tope();
	
	for (v=0, p=q[0]; p!=NULL; p=p->p) ++v;
	for (e=0, p=q[1]; p!=NULL; p=p->p) ++e;
	for (f=0, p=q[2]; p!=NULL; p=p->p) ++f;
	for (d=0, p=q[2]; p!=NULL; p=p->p) if (p->verified == 1) ++d;
	if (verbose > 0)
		printf("(v,e,f) = (%d,%d,%d),   %d of %d faces verified  \t%d%%\n",
			v, e, f, d, f, (d*100)/f);
	if (v+f-e != 2) screen_tope(q);
}

void
screen_tope(q)
facet **q;
{
	facet *p, *p2;
	int v, e, f, i;
	link *r;
	
	for (v=0, p=q[0]; p!=NULL; p=p->p) ++v;
	for (e=0, p=q[1]; p!=NULL; p=p->p) ++e;
	for (f=0, p=q[2]; p!=NULL; p=p->p) ++f;
	for (i=0; i<=2; ++i) {
		printf("dimension %d\n", i);
		for (p=q[i]; p!=NULL; p=p->p) {
			printf("  %d: %d%d%d ", 
				p->id, p->light, p->critical, p->dark);
			if (i==2) {
				if (p->verified == 1) printf("! ");
				else printf("? ");
			}
			if (p->spawn != NULL) printf(" (%d) ", p->spawn->id);
			if (i<2) {
				printf(" up= ");
				for (r=p->up; r!=NULL; r=r->p) 
					printf("%2d ", r->f->id);
			}  
			if (i>0) {
				printf(" dn= ");
				for (r=p->dn; r!=NULL; r=r->p) 
					printf("%2d ", r->f->id);
			}
			if (i!=1 && p->v!=NULL) {
				printf("  (%ld, %ld, %ld, %ld)", 
					p->v->v[0], p->v->v[1], p->v->v[2], p->v->v[3]);
				if (i==2) printf(" . x >= %ld\t\t", p->c);
				if (i==2)
					for (p2=q[0]; p2!=NULL; p2=p2->p)
						if (dot_prod(p->v, p2->v) == p->c)
							printf("%2d ", p2->id);
			} 
			printf("\n");
		}
	}
	PAUSE;
}
