/*********************************/
/*                               */
/*  Russell Runtime Environment  */
/*                               */
/*********************************/

#define _RUNTIME_

#include "gc/gc.h"

#ifdef M68K_SUN
#   define M68K
	     /* Doesn't run on an HP machine yet. */
#endif

/* bad address, known to code generator.  Should be cheap to load */
/* into a register.                                               */

#define UNINIT (0x0)

/*  max size objects supported by freelist (larger objects may be   */
/*  allocated, but less efficiently)                                */
/* at the beginning of long_RT.s, the following statement should be	*/
/* inserted:								*/
/*      asm(".set MAXOBJSZ,0x200")      if HBLKSIZE/2 == 0x200          */

/* (slow) general purpose allocation routines */
extern struct obj * ralloc();

extern struct obj * ralloc_comp();

/*  function-valued objects */

struct funcobj {
    int fo_arlgth;      /* Act. record length.  Negative if heap a.r. may be */
			/* required.                                         */
    struct obj *fo_ep;
    struct obj *((*fo_ip)());
};

char * startup_sfp; /* Frame pointer for Russell startup routine */

