/* Copyright Per Bothner 1987. Read the file Q-INFO */
#include "types.h"
#include "debug.h"
#include <stdio.h>
/*#include <parsefile.h>*/
#include <stdarg.h>
void RunError(int code, const char *format, ...)
{
    va_list args;
    if (code)
	fprintf(stderr, "ERROR(%x): ", code);
    else fprintf(stderr, "ERROR: ");
    va_start(args, format);
    vfprintf(stderr, format, args);
    va_end(args);
    fflush(stderr);
/*    if (Debug & DebugAbort) abort(); */
  }

static char *(LevelNames[]) = { "Inf", "Nte", "Wrn", "Err", "Ftl"};

int CheckErrorLevel(char *message)
  { int level;
    for (level = FtlMessage; level >= InfMessage; level--)
	if (message[0] == LevelNames[level][0])
	    if (message[1] != ' ') break;
	    else return level;
    return -1;
  }

void ErrorPrint(char when,
	   int level,
	   struct Location *sourcePos,
	   FILE *file,
	   char *message,
	   va_list argList)
{
    fputc(when, file);
    fputs(LevelNames[level], file);
    if (sourcePos != NULL)
	fprintf(file, ", line %d", sourcePos->lineNo);
    fputs(": ", file);
    vfprintf(file, message, argList);
    fputc('\n', file);
}

#if 0
void ErrorPrint(char when,
	   int level,
	   struct Location *sourcePos,
	   ostream& outs,
	   char *message,
	   va_list argList)
{
    outs << when << LevelNames[level];
    if (sourcePos != NULL)
	outs << ", line " << (int)sourcePos->lineNo;
    outs << ": ";
#if 1
    char buf[1024]
    vsprintf(buf, message, argList);
    outs << buf;
#else
    outs.vform(message, argList);
#endif
    outs << '\n';
}
#endif
