#include "def.h"
#include "macro.h"

#ifdef SCHURTRUE
#define LENGTH 100
#define DEPTH 100
#include <memory.h> /* for memcpy (3C) */

static char (* ps)[LENGTH] = NULL;/* permutationen */
static short (* ms)[3]   = NULL; 	/* maximal place  at 0 */
/* end of first increasing part at 1 */
/* length of the perm at 2 */
static short stacklevel; 		/* the actuell level */
static short permlength;		/* the length of the permutation */

typedef  char axk[LENGTH] ;
typedef  short axl[3] ;
static INT add_schur_schur_co();
static INT scan_schur_co();
static INT newtrans_main();
static INT newtrans_printstack();

schur_ende() /* AK 100692 */
{
	if (ps != NULL) 
		free(ps);
	if (ms != NULL) 
		free(ms);
}

static INT newtrans_main(perm,erg) OP perm,erg;
/* AK 020290 V1.1 */ /* AK 200891 V1.3 */
{
	short i,j;
	extern short permlength;
	extern short stacklevel;
	extern char (* ps)[LENGTH];
	extern short   (* ms)[3];

	if (ps == NULL) {
		ps = (axk * )  calloc(DEPTH,sizeof(axk));
		if (ps == NULL) {
			error("newtrans_main:no memory");};
		}
	if (ms == NULL) {
		ms = (axl *) calloc(DEPTH,sizeof(axl));
		if (ms == NULL) {
			error("newtrans_main:no memory");};
		}

	newtrans_start(perm);
mainaa:
	if (ms[stacklevel][1] == ms[stacklevel][0])
	/* this means it is grassmanian */
	{
		OP ent=callocobject(); /* eintrag */
		INT insert_erg;
		init(MONOM,ent);
		init(PARTITION,S_MO_S(ent));
		m_il_v((INT) ms[stacklevel][1] + 1, S_PA_S(S_MO_S(ent)));
		M_I_I(1L,S_MO_K(ent));
		for (i=(short)0,j=(short)0; i<= ms[stacklevel][1]; i++)
		    if (  (ps[stacklevel] [i]) - i - 1 > 0 ) {
			M_I_I((INT) (ps[stacklevel] [i]) - i - 1L,
			    S_PA_I(S_MO_S(ent),j)); j++; }
		M_I_I((INT)j, S_PA_L(S_MO_S(ent))); /* j eingefuegt AK 170790 */
		insert_erg=insert(ent,erg,add_koeff,comp_monomvector_monomvector);
		if (insert_erg == INSERTEQ) freeall(ent);
		stacklevel--;
	}
	else newtrans_nextstep();
	/* compute next level from last entry in stack */
	if (stacklevel != -1) goto mainaa;
	return(OK);
}


INT newtrans_nextstep() 
/* AK 200891 V1.3 */
{
	extern short permlength;
	extern short stacklevel;
	extern char (* ps )[LENGTH];
	extern short (* ms)[3];

	short i,j;
	short maxplace =  ms [stacklevel][0];
	/* the position before the last decrease */
	char maxentry = ps  [stacklevel][ms [stacklevel][0]];
	/* this is the entry at the maximal place */
	char rightlessvalue;
	/* this is the value on this place */
#ifdef UNDEF
	short numberofsons=0;
	/* the number of transitions */
#endif
	short minimalleftvalue;
	/* the minimal value to the left which is allowed
	to be exchanged with entry on the maxplace */
	short startloop;

	/* first we look whether we could reduce the length of the perm */

	for (i=ms[stacklevel][2] -1; i>0; i--)
		if (ps[stacklevel][i] == (char)i+1) ms[stacklevel][2]--;
		else break;
	/* now we have reduced the length of the alphabet */

	/* now we compute these rightvalues */
	for (i=ms[stacklevel][2] - 1; i> 0 ; i--)
		if ( ps [stacklevel][i] < maxentry) break;
	/* i is now the required place */
	rightlessvalue =  ps [stacklevel][i];
	/* now we have to exchange */
	ps  [stacklevel][i] =  maxentry;
	ps  [stacklevel][maxplace] =  rightlessvalue;

	/* you must look whether rightlessvalue == 1
because this means you have to enlarge the permutation */

	startloop = maxplace-1;
	if (rightlessvalue == 1)
	{
		ms[stacklevel][2]++;
		for (i=ms[stacklevel][2]-1; i>0 ; i--)
			ps[stacklevel][i]=ps[stacklevel][i-1]+1;
		ps[stacklevel][0]=(char)1;
		ms[stacklevel][0]++;
		ms[stacklevel][1]++;
		rightlessvalue=2;
		maxplace++;
		startloop=0;
	}

	/* now we have to compute all possible changes to the left */
	minimalleftvalue = 0;
	for (i=startloop; i>=0; i--)
	{
		if (( ps  [stacklevel][i] < rightlessvalue)
		    && ((short) ps  [stacklevel][i] > minimalleftvalue))
		{
			/* now these things have to be copied and to be exchanged */
			if (stacklevel+1 == DEPTH)
			/* this means the stack is to small */
			{ fprintf(stderr,"ERROR:stackoverflow\n"); exit(); };
			/* you generate a copy of the upper stack-entry */

			if (i>0)
			{
				memcpy(	&(ps[stacklevel+1][0]),
				    &(ps[stacklevel][0]),
				    (int)(ms[stacklevel][2]));
				memcpy(	&(ms[stacklevel+1][0]),
				    &(ms[stacklevel][0]),6);
			}
			/* you got a copy */

			ps [stacklevel][maxplace]=ps[stacklevel][i];
			ps [stacklevel][i]=rightlessvalue;
			minimalleftvalue = (short)ps[stacklevel][maxplace];
			/* we have now to compute the new values for
		minstack and ms */
			for (j=ms[stacklevel][1]+1;j<ms[stacklevel][2];j++)
				if (ps[stacklevel][j] < ps[stacklevel][j-1])
					break;
			ms[stacklevel][1] = j-1;
			/* this is the new value of the minstackentry */

			for (j=ms[stacklevel][0];j>=0;j--)
				if (ps[stacklevel][j] > ps[stacklevel][j+1])
					break;
			ms[stacklevel][0] = j;
			/* this is the new value of the msentry */
			if (minimalleftvalue == (rightlessvalue - 1)) return(0);
			else stacklevel++;
		}
		if ((i==0)&&(minimalleftvalue==0))
		/* you have to enlarge the permutation */
		{
			ms[stacklevel][2]++;
			for (i=ms[stacklevel][2]-1; i>0 ; i--)
				ps[stacklevel][i]=ps[stacklevel][i-1]+1;
			ps[stacklevel][0]=(char)1;
			ms[stacklevel][1]++;
			ms[stacklevel][0]++;
			rightlessvalue++;
			maxplace++;
			ps [stacklevel][maxplace]=ps[stacklevel][i];
			ps [stacklevel][i]=rightlessvalue;
			minimalleftvalue = (short)ps[stacklevel][maxplace];
			/* we have now to compute the new values for
		minstack and ms */
			for (j=ms[stacklevel][1]+1;j<ms[stacklevel][2];j++)
				if (ps[stacklevel][j] < ps[stacklevel][j-1])
					break;
			ms[stacklevel][1] = j-1;
			/* this is the new value of the minstackentry */

			for (j=ms[stacklevel][0];j>=0;j--)
				if (ps[stacklevel][j] > ps[stacklevel][j+1])
					break;
			ms[stacklevel][0] = j;
			/* this is the new value of the msentry */
			return(0);
		}
	}
	stacklevel--;
	return OK;
}


static INT newtrans_printstack()
/* AK 200891 V1.3 */
{
	/* the routine prints the stack */
	short i,j;
	extern short stacklevel;
	extern char (* ps) [LENGTH];
	extern short (* ms)[3];

	for (i=0;i<=stacklevel;i++)
	{
		for (j=0;j<ms[i][2];j++)
			printf(" %d ",(short)ps[i][j]);
		printf(":%d %d %d\n",ms[i][0],ms[i][1],ms[i][2]);
	};
	return(OK);
}


INT newtrans_start(perm) OP perm;
/* AK 221289 V1.1 */ /* AK 200891 V1.3 */
{
	short i;
	extern short permlength;
	extern short stacklevel;
	extern char (* ps) [LENGTH];
	extern short (* ms)[3];

	permlength = S_P_LI(perm);
	if (permlength > LENGTH)
	/* the error condition the perm do not fit into the stack */
	{
		printf("please enter a permutation of a length <= %d\n",LENGTH);
		return(ERROR);
	}
	stacklevel = (short)0;
	ms[0][2]=permlength;

	for (i=0; i<permlength ; i++)
	{
		ps  [stacklevel][i] = (char)S_P_II(perm,i);
	}
	/* now we are looking for the first and the last decrease */
	for (i=1; i<permlength ; i++)
		if (ps [stacklevel][i] < ps [stacklevel][i-1]) break;
	/* now i is the index of the first decrease */
	ms [stacklevel][1] = i-1;


	for (i=permlength-2 ;i>=0; i--)
		if (ps [stacklevel][i] > ps [stacklevel][i+1]) break;
	/* now i+1 is the index of the last decrease */
	ms [stacklevel][0] = i;
	return OK;
}

INT newtrans(perm,c) OP perm,c;
/* AK 221289 V1.1 */ /* AK 130891 V1.3 */
	{ 
	INT erg = OK;
	if (not EMPTYP(c)) 
		erg += freeself(c);
	if (einsp_permutation(perm)) {
		OP a = callocobject();
		erg += b_skn_s(callocobject(),callocobject(),NULL,c);
		erg += M_I_I(1L,S_S_K(c));
		erg += M_I_I(0L,a);
		erg += b_i_pa(a,S_S_S(c));
		goto newtrans_label;
		}
	erg += init(BINTREE,c);
	erg += newtrans_main(perm,c); 
	erg += t_BINTREE_SCHUR(c,c);
newtrans_label:
	if (erg != OK)
		error("newtrans:error during computation");
	return erg;
	}

INT newtrans_limit(perm,c,limit) OP perm,c,limit;
/* AK 221289 V1.1 */ /* AK 200891 V1.3 */
{ 
	INT erg = OK;
	erg += init(LIST,c); 
	erg += C_O_K(c,SCHUR); 
	erg += newtrans_main_limit(perm,c,limit); 
	return erg;
}

INT newtrans_main_limit(perm,c,limit) OP perm,c,limit;
/* limit is a limit on the length of the partitions */
/* AK 221289 V1.1 */ /* AK 200891 V1.3 */
{
	short i;
	extern short permlength;
	extern short stacklevel;
	extern char (* ps) [LENGTH];
	extern short (* ms)[3];

	if (ps == NULL) {
		ps= (char ** ) calloc(LENGTH * DEPTH,sizeof(char));
		if (ps== NULL) {error("newtrans_main_limit:no memory");};
		}
	if (ms == NULL) {
		ms = (short **) calloc(3 * DEPTH,sizeof(short));
		if (ms == NULL) {error("newtrans_main_limit:no memory");};
		}
	newtrans_start(perm);
mainaa:
	if (ms[stacklevel][1] == ms[stacklevel][0])
	/* this means it is grassmanian */
	{
		OP ent; /* eintrag */
		INT insert_erg;
		if ((INT)ms[stacklevel][1] + 1 <= S_I_I(limit))
		{
			/* partition ist kurz genug */
			ent=callocobject();
			b_pa_s(callocobject(),ent);
			init(PARTITION,S_S_S(ent));
			m_il_v((INT)ms[stacklevel][1] + 1, S_PA_S(S_S_S(ent)));
			M_I_I(1L,S_S_K(ent));
			for (i=0; i<= ms[stacklevel][1]; i++)
				M_I_I((INT) (ps[stacklevel] [i]) - i - 1,
				    S_PA_I(S_S_S(ent),i));
			if ( neqparts_partition(S_S_S(ent)))
			{
				insert_erg=insert(ent,c,add_koeff,comp_colex_schurmonom);
				if (insert_erg == INSERTEQ) freeall(ent);
			}
			else freeall(ent);
		}
		stacklevel--;
	}
	else newtrans_nextstep();
	/* compute next level from last entry in stack */
	if (stacklevel != -1) goto mainaa;
	return(OK);
}

#endif
/* schnitt.c */

INT schnitt_schur(a,b,c) OP a,b,c;
/* gemeinsame bestandteile der schurfunktionen a und b nach c*/
/* AK 310789 V1.0 */ /* AK 181289 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef SCHURTRUE
	OP zeigera, zeigerb;
	INT erg;

	if (not EMPTYP(c)) freeself(c); 
	zeigera=a; zeigerb=b;
	while(zeigera != NULL && zeigerb !=NULL)
	{
		erg =  comp(S_S_S(zeigera),S_S_S(zeigerb));
		if (erg == 0L)
		{
			OP neu = callocobject();
			init(SCHUR,neu);
			copy(S_S_S(zeigera),S_S_S(neu));
			if (ge(S_S_K(zeigerb),S_S_K(zeigera)))
				copy(S_S_K(zeigera),S_S_K(neu));
			else copy(S_S_K(zeigerb),S_S_K(neu));

			insert(neu,c,add_koeff,comp);
			zeigera=S_S_N(zeigera);
			zeigerb=S_S_N(zeigerb);
		}
		else if (erg < 0L) zeigera=S_S_N(zeigera);
		else if (erg > 0L) zeigerb=S_S_N(zeigerb);
	};
	return(OK);
#else
	error("schnitt_schur:SCHUR not available");
	return(ERROR);
#endif
}

INT tex_schur(poly) OP poly;
/* AK 101187 */ /* zur ausgabe eines Schurpolynoms */
/* AK 110789 V1.0 */ /* AK 181289 V1.1 */
/* AK 070291 V1.2 prints to texout */ /* AK 200891 V1.3 */
{
#ifdef SCHURTRUE
	OP zeiger = poly;

	fprintf(texout,"\\ ");
	if (EMPTYP(poly)) return(OK);
	while (zeiger != NULL)
	{
		if (not einsp (S_S_K(zeiger)))
			/* der koeffizient wird nur geschrieben wenn er
			ungleich 1 ist */
			tex(S_S_K(zeiger));
		fprintf(texout,"\\ $S_{ ");
		fprint(texout,S_S_S(zeiger));
		fprintf(texout," } $\\ ");
		zeiger = S_S_N(zeiger);
		if (zeiger != NULL) fprintf(texout," $+$ ");
		texposition += 15;
		if (texposition >70) {
			fprintf(texout,"\n");
			texposition = 0;
		}
	};
	fprintf(texout,"\\ ");
	texposition += 3;
	return(OK);
#else /* SCHURTRUE */
	return error("tex_schur:SCHUR not available");
#endif /* SCHURTRUE */
}



#ifdef  MATRIXTRUE 
#ifdef  SCHURTRUE 
INT compute_skewschur_with_alphabet_det(a,b,c) OP a,b,c;
/* skewschurpolyomial with det */
/* AK 090790 V1.1 */ /* AK 250291 V1.2 */ /* AK 200891 V1.3 */
{
	INT i,j,gli,kli;
	OP d = callocobject();
	OP h = callocobject();
	gli = S_SPA_GLI(a);
	kli = S_SPA_KLI(a); /* alt gli */
	m_ilih_m(gli,gli,d);
	for (i=0L; i<gli; i++)
		for (j=0L; j<gli; j++)
			{
			if (i >= (gli - kli) )
				m_i_i(S_SPA_GII(a,j)+j-i-
				      S_SPA_KII(a,i-gli+kli)
				      ,h);
			else
				m_i_i(S_SPA_GII(a,j)+j-i,h);
			compute_complete_with_alphabet(h,b,S_M_IJ(d,i,j));
			}
	det_mat_imm(d,c);
	freeall(d); return OK;
}
#endif /* SCHURTRUE */
#endif /* MATRIXTRUE */


#ifdef  MATRIXTRUE 
#ifdef  SCHURTRUE 
INT compute_schur_with_alphabet_det(a,b,c) OP a,b,c;
/* schurpolyomial with det */ 
/* AK 090790 V1.1 */ /* AK 200891 V1.3 */
{
	INT i,j;
	OP d = callocobject();
	OP h = callocobject();
	m_ilih_m(S_PA_LI(a),S_PA_LI(a),d);
	for (i=0L; i<S_PA_LI(a); i++)
		for (j=0L; j<S_PA_LI(a); j++)
			{
			M_I_I(S_PA_II(a,j)+j-i,h);
			compute_complete_with_alphabet(h,b,S_M_IJ(d,i,j));
			}
	det_mat_imm(d,c);
	freeall(d); return OK;
}
#endif /* SCHURTRUE */
#endif /* MATRIXTRUE */


#ifdef SCHURTRUE
INT compute_schur(part,erg) OP part,erg;
/* AK 161187 */ /* AK 110789 V1.0 */ /* AK 181289 V1.1 */ /* AK 260291 V1.2 */
/* AK 200891 V1.3 */
{
	OP l=callocobject();
	weight( part,l);
	compute_schur_with_alphabet(part,l,erg);
	freeall(l);
	return(OK);
}
#endif /* SCHURTRUE */

#ifdef SCHURTRUE
INT t_POLYNOM_MONOMIAL(a,b) OP a,b;
/* assumes a is symmetric */
/* AK 080591 V1.2 */ /* AK 200891 V1.3 */
	{
	OP c,d,e;
	INT erg = OK;
	if (not EMPTYP(b)) erg += freeself(b);
	c = callocobject();
	erg += copy(a,c);
	e = callocobject();
	while (not nullp(c))
		{
		d = callocobject();
		erg += m_v_s(S_PO_S(c),d);
		erg += copy(S_PO_K(c),S_S_K(d));
		erg += compute_monomial_with_alphabet(
				S_S_S(d),S_V_L(S_PO_S(c)),e);
		mult_apply(S_PO_K(c),e);
		erg += sub(c,e,c);
		insert(d,b,NULL,NULL);
		}	
	erg += freeall(e);
	erg += freeall(c);
	return erg;
	}
#endif /* SCHURTRUE */

#ifdef SCHURTRUE
INT t_POLYNOM_POWER(a,b) OP a,b;
/* assumes a is symmetric */
/* AK 080591 V1.2 */		/* AK 200891 V1.3 */
	{
	OP c,d,e,f;
	OP pa,z;
	INT pain,i;
	INT erg = OK;
	if (not EMPTYP(b)) 
		erg += freeself(b);
	c = callocobject();
	erg += copy(a,c);
	e = callocobject();
	while (not nullp(c))
		{
		d = callocobject();
		z = c; pa = c; 
		pain = 0L;
		while (z != NULL)
			{
			erg += m_v_pa(S_PO_S(z),d);
			if ((i=indexofpart(d)) > pain) 
				{
				pain = i;
				pa = z;
				}
			z = S_PO_N(z);
			}
		/* pain ist index der lex kleinsten partition
                   pa der zugehoerige POLYNOM zeiger */
		erg += m_v_s(S_PO_S(pa),d);
		erg += copy(S_PO_K(pa),S_S_K(d));
		erg += compute_power_with_alphabet(
				S_S_S(d),S_V_L(S_PO_S(pa)),e);
		z = e;
		while (z != NULL)
			{
			if (EQ(S_PO_S(z),S_PO_S(pa)))
			/* find coeff of the leading monom */
				{
				f = callocobject();
				copy(S_PO_K(z),f);
				invers_apply(f);
				mult_apply(f,e);
				freeall(f);
				break;
				}
			z = S_PO_N(z);
			}
		mult_apply(S_PO_K(pa),e);
		erg += sub(c,e,c);
		insert(d,b,NULL,NULL);
		}	
	erg += freeall(e);
	erg += freeall(c);
	return erg;
	}
#endif /* SCHURTRUE */

static INT c_m_w_a_vp(a,b,c) OP a,b,c;
/* AK 200891 V1.3 */
	{
	OP e,f,g;
	INT erg = OK,i;
	e = callocobject();
	erg += first_permutation(b,e);
	f = callocobject();
	m_l_v(b,f);
	for (i=0L;i<S_I_I(b);i++)
		if (i < S_PA_LI(a)) m_i_i(S_PA_II(a,i),S_V_I(f,i));
		else m_i_i(0L,S_V_I(f,i));
	/* f is vector */
	do 
		{
		g = callocobject();
		b_skn_po(callocobject(),callocobject(),NULL,g);
		m_i_i(1L,S_PO_K(g));
		operate_perm_vector(e,f,S_PO_S(g));
		insert(g,c,NULL,NULL);
		} while(next(e,e));

	/* nur koeff mit 1 */
	g = c;
	while (g != NULL)
		{
		if (not einsp(S_PO_K(g)))
			m_i_i(1L,S_PO_K(g));
		g = S_PO_N(g);
		}

	erg += freeall(f);
	erg += freeall(e);
	return erg;
	}

#ifdef PARTTRUE
INT compute_monomial_with_alphabet(number,l,res) OP number,res,l;
/* AK 090790 V1.1 */ /* AK 090591 V1.2 */ /* AK 200891 V1.3 */
	{
	INT erg = OK;
	if (S_O_K(l) != INTEGER)
		return error("compute_monomial_with_alphabet: l no INTEGER");
	if (not EMPTYP(res)) 
		erg += freeself(res);
	if (S_O_K(number) == PARTITION)
		{
		if (S_PA_K(number) != VECTOR) 
			{
			OP c = callocobject();
			erg += t_VECTOR_EXPONENT(number,c);
			erg += compute_monomial_with_alphabet(c,l,res);
			erg += freeall(c);
			return erg;
			}
		/* number is VECTOR partition */
		if (GR(S_PA_L(number),l))
			return OK;  /* sind 0 */
		erg += c_m_w_a_vp(number,l,res);
		return erg;
		}
	else if (S_O_K(number) == INTEGER)
		{
		OP c = callocobject();
		erg += m_i_pa(number,c);
		erg += compute_monomial_with_alphabet(c,l,res);
		erg += freeall(c);
		return  erg;
		}
	else
	  return error("compute_monomial_with_alphabet:number wrong type");
	}

#endif /* PARTTRUE */
#ifdef PARTTRUE

#ifdef SCHURTRUE
INT compute_complete_with_alphabet(number,l,res) OP number,res,l;
/* AK 090790 V1.1 */ /* AK 260291 V1.2 */ /* AK 200891 V1.3 */
	{
	OP b;
	INT erg=OK;
	if (not EMPTYP(res)) 
		erg += freeself(res);

	if (nullp(number)) 
		return M_I_I(1L,res); 
	if (negp(number)) 
		return M_I_I(0L,res); 

	b = callocobject();
	erg += m_i_pa(number,b);
	erg += compute_schur_with_alphabet(b,l,res);
	erg += freeall(b); 
	return erg;
	}
#endif /* SCHURTRUE */
	
#endif /* PARTTRUE */
#ifdef PARTTRUE
INT compute_power_with_alphabet(label,l,result) OP l,label,result;
/* AK 120391 V1.2 */ /* AK 200891 V1.3 */
{
	INT erg = OK;
	INT i;
	OP zw;

	if (not EMPTYP(result)) 
		erg += freeself(result);
	if (S_O_K(label) == INTEGER)
		{
		erg += init(POLYNOM,result);
		for (i=0L;i<S_I_I(l); i++)
			{
			zw = callocobject();
			erg += m_iindex_iexponent_monom(i,S_I_I(label),zw);
			insert(zw,result,NULL,NULL);
			}
		}
	else if (S_O_K(label) == PARTITION)
		{
		zw = callocobject();
		erg += m_scalar_polynom(cons_eins,result);
		for (i=0L; i<S_PA_LI(label); i++)
			{
			erg += compute_power_with_alphabet(S_PA_I(label,i),
							          l,zw);
			erg += mult_apply(zw,result);
			}
		erg += freeall(zw);
		}
	else    {
		printobjectkind(label);
		erg = error("compute_power_with_alphabet:wrong kind of label");
		}

	if (erg != OK)
		error("compute_power_with_alphabet:error during computation");
	return erg;
}
#endif /* PARTTRUE */

#ifdef PARTTRUE
#ifdef SCHURTRUE
INT compute_schur_with_alphabet(part,l,erg) OP part,erg,l;
/* AK 101187 */
/* AK 161187 l ist die laenge des alphabets */
/* AK 110789 V1.0 */ /* AK 181289 V1.1 */ /* AK 150591 V1.2 */
/* AK 200891 V1.3 */
{
	OP e,d;
	INT i,eintrag;

	if (not EMPTYP(erg))
		freeself(erg);

	if (GR(S_PA_L(part),l))
		{
		return M_I_I(0L,erg);
		}
	e=callocobject();
	d=callocobject();
	b_s_po(callocobject(),d);
	m_l_v(l,S_PO_S(d));
	/* die datenstruktur fuer das startpolynom wird erzeugt */
	for (i=0L;i<S_PO_SLI(d);i++)
	{
		eintrag=S_PO_SLI(d)-1-i;
		M_I_I(eintrag,S_PO_SI(d,i));
	};
	for (i=0L;i<S_PA_LI(part);i++)
	{
		eintrag=S_PO_SII(d,i);
		eintrag+=S_PA_II(part,S_PA_LI(part)-1L-i);
		M_I_I(eintrag,S_PO_SI(d,i));
	};
	last_permutation(l,e);
	divideddiff_permutation(e,d,erg);
	freeall(d);
	freeall(e);
	return(OK);
}
#endif /* SCHURTRUE */
#endif /* PARTTRUE */

INT m_pa_s(part,schur) OP part, schur;
/* AK 090790 V1.1 */ /* AK 260291 V1.2 */ /* AK 050891 V1.3 */
{
#ifdef SCHURTRUE
	OP p = callocobject();
	copy_partition(part,p);
	return b_pa_s(p,schur);
#else
	error("m_pa_s:SCHUR not available");
	return(ERROR);
#endif
}


INT b_pa_s(part,schur) OP part, schur;
/* AK 140687 */ /* erzeugt aus einer part eine schurfunction */
/* AK 110789 V1.0 */ /* AK 241189 V1.1 */
/* AK 200891 V1.3 */
{
#ifdef SCHURTRUE
	INT erg=OK;
	erg += b_skn_s(part,callocobject(),NULL,schur);
	erg += M_I_I(1L,S_S_K(schur));
	return erg;
#else
	error("b_pa_s:SCHUR not available");
	return(ERROR);
#endif
}

INT m_v_s(vec,schur) OP vec, schur;
/* AK 110187 */
/* erzeugt aus einen vector eine schurfunction vec wird nicht freigegeben */
/* AK 110789 V1.0 */ /* AK 170590 V1.1 */
/* AK 200891 V1.3 */
{
#ifdef SCHURTRUE
	INT erg=OK;
	erg += b_skn_s(	callocobject(), callocobject(),
	    NULL, schur);
	erg += m_v_pa(vec,S_S_S(schur));
	erg += M_I_I(1L,S_S_K(schur));
	return erg;
#else
	error("m_v_s:SCHUR not available");
	return(ERROR);
#endif
}

INT addinvers_schur(von,nach) OP von, nach;
/* AK 110789 V1.0 */ /* AK 201289 v1.1 */ /* AK 200891 V1.3 */
{
#ifdef SCHURTRUE
	return addinvers_polynom(von,nach); 
#else /* SCHURTRUE */
	return error("addinvers_schur:SCHUR not available");
#endif /* SCHURTRUE */
}


INT addinvers_apply_schur(von) OP von;
/* AK 201289 V1.1 */ /* AK 200891 V1.3 */
{ 
	return(addinvers_apply_polynom(von)); 
}


#ifdef HOMSYMTRUE 
INT add_homsym_homsym(a,b,c) OP a, b, c;
/* AK 200891 V1.3 */
{
	return add_schur_schur_co(a,b,c,HOM_SYM);
}
#endif /* HOMSYMTRUE */

#ifdef SCHURTRUE 
INT add_schur_schur(a,b,c) OP a, b, c;
/* AK 200891 V1.3 */
{
	return add_schur_schur_co(a,b,c,SCHUR);
}
#endif /* SCHURTRUE */

#ifdef SCHURTRUE
static INT add_schur_schur_co(a,b,c,typ) OP a, b, c;OBJECTKIND typ;
/* AK 110789 V1.0 */ /* AK 201289 V1.1 */ /* AK 050891 V1.3 */
{
	add_polynom_polynom(a,b,c); 
	if (listp(c))
		C_O_K(c,typ); 
	return(OK);
}
#endif /* SCHURTRUE */



INT mult_scalar_schur(von,nach,ergebnis) OP von, nach, ergebnis;
/* AK 110789 V1.0 */ /* AK 050891 V1.3 */
/* nach: SCHUR */
{
#ifdef SCHURTRUE
	INT erg = OK;
	if (nullp(von))  /* AK 141091 */
		return m_i_i(0L,ergebnis);
	erg += mult_scalar_polynom(von,nach,ergebnis);
	C_O_K(ergebnis,SCHUR);
	return erg;
#else
	error("mult_scalar_schur:SCHUR not available");
	return(ERROR);
#endif
}



INT m_skn_s(self,koeff,n,ergebnis) OP self,koeff,n,ergebnis;
/* AK 200891 V1.3 */
	{
#ifdef SCHURTRUE
	m_skn_po(self,koeff,n,ergebnis);
	C_O_K(ergebnis,SCHUR);
#else
	return error("m_skn_s:SCHUR not available");
#endif
	}

INT b_skn_s(self,koeff,n,ergebnis) OP self,koeff,n,ergebnis;
/* AK 110789 V1.0 */ /* AK 130391 V1.2 */
/* AK 130891 V1.3 */
{
#ifdef SCHURTRUE
	INT erg = OK;
	erg += b_skn_po(self,koeff,n,ergebnis);
	erg += C_O_K(ergebnis,SCHUR);
	if (erg != OK) 		
		error("b_skn_s:error during computation");
	return erg;
#else
	return error("b_skn_s:SCHUR not available");
#endif
}

#ifdef SCHURTRUE
INT objectread_schur(filename,poly) OP poly; FILE *filename;
/* AK 291086 */ /* AK 110789 V1.0 */ /* AK 221289 V1.1 */
/* AK 200891 V1.3 */
{
	char antwort[2];

	b_skn_s(	callocobject(), callocobject(), callocobject(), poly);
	objectread(filename,PARTITION,S_S_S(poly));
	objectread(filename,INTEGER,S_S_K(poly));
	fscanf(filename,"%s",antwort);
	if (antwort[0] == 'j') 		objectread(filename,SCHUR,S_S_N(poly));
	else if (antwort[0] == 'n')     { 
		free(S_S_N(poly)); 
		C_S_N(poly,NULL); 
	}
	else error("objectread_schur:wrong data");
	return(OK);
}

INT objectwrite_schur(filename,poly) FILE *filename; OP poly;
/* AK 291086 */ /* AK 110789 V1.0 */ /* AK 221289 V1.1 */
/* AK 200891 V1.3 */
{
	objectwrite(filename,S_S_S(poly));
	objectwrite(filename,S_S_K(poly));
	if (not lastp(poly))
	{ 
		fprintf(filename,"j\n"); 
		objectwrite(filename,S_S_N(poly)); 
	}
	else fprintf(filename,"n\n");
	return(OK);
}

INT scan_homsym(a) OP a; 
/* AK 050891 V1.3 */
{
	return scan_schur_co(a,HOM_SYM);
}
INT scan_schur(a) OP a; 
/* AK 050891 V1.3 */
{
	return scan_schur_co(a,SCHUR);
}

static INT scan_schur_co(a,typ) OP a; OBJECTKIND typ;
/* AK  zum einlesen einer schurfunktion */
/* AK 110789 V1.0 */ /* AK 221289 V1.1 */ /* AK 050891 V1.3 */

{
	char antwort[2];
	OBJECTKIND kind;

	b_skn_s( callocobject(), callocobject(), callocobject(), a);
	C_O_K(a,typ);
	printeingabe("Input of a partition type monom"); /* AK 050891 */
	scan(PARTITION,S_S_S(a));
	printeingabe("Input of coefficent");
	kind = scanobjectkind();
	scan(kind,S_S_K(a));
	printeingabe("one more monom y/n");
	scanf("%s",antwort);
	if (antwort[0]  == 'y') 		
		scan_schur_co(S_S_N(a),typ);
	else { 
		free(S_S_N(a)); 
		C_S_N(a,NULL); 
	}
	return(OK);
}
#endif

#ifdef SCHURTRUE
OP s_s_s(a) OP a;
/* AK 110789 V1.0 */ /* AK 181289 V1.1 */ /* AK 020791 V1.2 */
/* AK 200891 V1.3 */
{ return(s_mo_s(s_l_s(a))); }

OP s_s_k(a) OP a;
/* AK 110789 V1.0 */ /* AK 181289 V1.1 */ /* AK 020791 V1.2 */
/* AK 200891 V1.3 */
{ return(s_mo_k(s_l_s(a))); }

OP s_s_n(a) OP a;
/* AK 110789 V1.0 */ /* AK 181289 V1.1 */ /* AK 020791 V1.2 */
/* AK 200891 V1.3 */
{ return(s_l_n(a)); }

OP s_s_si(a,i) OP a; INT i;
/* AK 110789 V1.0 */ /* AK 181289 V1.1 */ /* AK 020791 V1.2 */
/* AK 200891 V1.3 */
{ return(s_pa_i(s_mo_s(s_l_s(a)),i)); }

OP s_s_sl(a) OP a;
/* AK 110789 V1.0 */ /* AK 181289 V1.1 */ /* AK 020791 V1.2 */
/* AK 200891 V1.3 */
{ return(s_pa_l(s_mo_s(s_l_s(a)))); }

INT s_s_ki(a) OP a;
/* AK 110789 V1.0 */ /* AK 181289 V1.1 */ /* AK 020791 V1.2 */
/* AK 200891 V1.3 */
{ return(s_mo_ki(s_l_s(a))); }

INT s_s_sii(a,i) OP a; INT i;
/* AK 110789 V1.0 */ /* AK 181289 V1.1 */ /* AK 020791 V1.2 */
/* AK 200891 V1.3 */
{ return(s_pa_ii(s_mo_s(s_l_s(a)),i)); }


INT s_s_sli(a) OP a;
/* AK 110789 V1.0 */ /* AK 181289 V1.1 */ /* AK 020791 V1.2 */
/* AK 200891 V1.3 */
{ return(s_pa_li(s_mo_s(s_l_s(a)))); }

INT c_s_n(a,b) OP a,b;
/* AK 110789 V1.0 */ /* AK 181289 V1.1 */ /* AK 020791 V1.2 */
/* AK 200891 V1.3 */
{ 
	OBJECTSELF c; 
	c = s_o_s(a); 
	c.ob_list->l_next = b; 
	return(OK); 
}
#endif /* SCHURTRUE */

/* testschur.c */
#ifdef SCHURTRUE
INT test_schur()
/* AK 181289 V1.1 */ /* AK 020791 V1.2 */
/* AK 200891 V1.3 */
{
	OP a = callocobject();
	OP b = callocobject();
	OP c = callocobject();

	printeingabe("test_schur:scan(a)");
	scan(SCHUR,a);
	println(a);
	printeingabe("test_schur:copy(a,b)");
	copy(a,b);
	println(b);
	printeingabe("test_schur:add(a,b,b)");
	add(a,b,b);
	println(b);
	printeingabe("test_schur:mult(a,b,b)");
	mult(a,b,b);
	println(b);
	printeingabe("test_schur:addinvers(b,a)");
	addinvers(b,a);
	println(a);
	printeingabe("test_schur:mult_apply(b,a)");
	mult_apply(b,a);
	println(a);

	freeall(a);
	freeall(b);
	freeall(c);
	return(OK);
}
#endif

#ifdef SCHURTRUE
INT mult_apply_schur(a,b) OP a,b;
/* AK  080890 V1.1 */
/* AK 200891 V1.3 */
{
	OP c = callocobject();
	*c = *b; 
	C_O_K(b,EMPTY); 
	mult(a,c,b);
	freeall(c);
	return OK;
}
#endif /* SCHURTRUE */

#ifdef SCHURTRUE
INT mult_schur_schur(a,zwei,c) OP a, zwei, c;
/* 221086 */ /* AK 110789 V1.0 */ /* AK 181289 V1.1 */ /* AK 050891 V1.3 */
{
	OP y, einszeiger, zweizeiger;

	zweizeiger = zwei;
	while (zweizeiger != NULL)
	{
		einszeiger = a;
		while (einszeiger != NULL)
		{
			y = callocobject();
			outerproduct_schur
			    (S_S_S(einszeiger), S_S_S(zweizeiger), y);
			mult(S_S_K(einszeiger),y,y);
			mult(S_S_K(zweizeiger),y,y);
			insert(y,c,add_koeff,comp_monomvector_monomvector);
			/* insert changed AK 111188 */
			einszeiger = S_S_N(einszeiger);
		};
		zweizeiger = S_S_N(zweizeiger);
	};
	return(OK);
}
#endif /* SCHURTRUE */


#ifdef SCHURTRUE
INT m_part_part_perm(a,b,c) OP a,b,c;
/* AK 050988 die permutation c zur multiplikation
zweier Schurfunktionen mit index a und b wird berechnet */
/* AK 110789 V1.0 */ /* AK 181289 V1.1 */ /* AK 200891 V1.3 */
{
	OP d = callocobject();
	OP z;
	INT i,j,k,l;
	/* a ist laenge des vectors */
	k = S_PA_II(a,S_PA_LI(a)-1);
	l = S_PA_II(b,S_PA_LI(b)-1);
	m_il_v( S_PA_LI(a) + S_PA_LI(b) + k + l  ,d);
	z = S_V_S(d);
	for (i=0L; i< S_PA_LI(a); i++,z++) M_I_I(S_PA_II(a,i),z);
	for (j=0L ; j < k; j++,i++,z++) M_I_I(0L,z);
	for (j=0L; j < S_PA_LI(b); j++,i++,z++) M_I_I(S_PA_II(b,j),z);
	for (j=0L ; j<l; j++,i++,z++) M_I_I(0L,z);
	lehmercode_vector(d,c);
	freeall(d);
	return(OK);
}
#endif /* SCHURTRUE */


#ifdef SCHURTRUE
INT outerproduct_schur(a,zwei,c) OP a, zwei, c;
/* AK 071086 */ /* AK 110789 V1.0 */ /* AK 181289 V1.1 */
/* AK 050891 V1.3 */
/* a:  PARTITION
   zwei: PARTITION
   c: wird SCHUR */
{
	OP   d=callocobject();
	if (not EMPTYP(c) ) 
		freeself(c);
	m_part_part_perm(a,zwei,d);
	newtrans(d,c);
	freeall(d); return(OK);
}
#endif /* SCHURTRUE */

#ifdef SCHURTRUE
INT m_perm_schur(a,b) OP a,b;
/* AK 270788 */
/* zerlegt das Schubertpolynom X_a  in eine Summe
von Schurpolynomen */
/* AK 110789 V1.0 */ /* AK 181289 V1.1 */ /* AK 200891 V1.3 */
{
	OP c = callocobject();
	if (not EMPTYP(b)) freeself(b);
	copy(a,c); newtrans(c,b); freeall(c); return(OK);
}
#endif /* SCHURTRUE */

INT outerproduct_schur_limit(a,zwei,c,l) OP a, zwei, c,l;
/* 071086 */ /* a zwei sind partitionen */ /* AK 071189  */
/* AK 181289 V1.1 */ /* AK 180391 V1.2 */ /* AK 200891 V1.3 */
{
#ifdef SCHURTRUE
	OP   d=callocobject();
	if (not EMPTYP(c)) 
		freeself(c);
	m_part_part_perm(a,zwei,d);
	newtrans_limit(d,c,l);
	freeall(d);
	return(OK);
#else
	error("outerproduct_schur_limit:SCHUR not available");
	return(ERROR);
#endif
}


#ifdef SCHURTRUE
INT comp_colex_schurmonom(a,b) OP a,b;
/* AK 091189 */ /* AK V1.1 201189 */
/* AK 200891 V1.3 */
{
	if (S_O_K(a) != MONOM) {
		fprintf(stderr,"comp_colex_schurmonom:a = ");
		debugprint(a);
		error("comp_colex_schurmonom:kind(a) != MONOM");
	}
	if (S_O_K(b) != MONOM) {
		fprintf(stderr,"comp_colex_schurmonom:b = ");
		debugprint(b);
		error("comp_colex_schurmonom:kind(b) != MONOM");
	}
	return(comp_colex_part(S_MO_S(a),S_MO_S(b)));
}
#endif /* SCHURTRUE */

INT comp_colex_part(a,b) OP a,b;
/* a,b partitions colex order */
/* AK V1.1 151189 */
/* AK 200891 V1.3 */
{
#ifdef PARTTRUE
	INT i = S_PA_LI(a)-1L;
	INT j = S_PA_LI(b)-1L;
	INT erg;

	if (S_O_K(a) != PARTITION) 
		error("comp_colex_part:kind != PARTITION");
	if (S_O_K(b) != PARTITION) 
		error("comp_colex_part:kind != PARTITION");
	

	for (;(i >= 0L) || (j>=0L); i--,j--)
	{
		if (i<0L) return(1L);
		if (j<0L) return(-1L);
		erg = S_PA_II(a,i) - S_PA_II(b,j);
		if (erg <0L) return(1L);
		if (erg >0L) return(-1L);
	}
	return(0L);
#else
	return error("comp_colex_part:PART not available");
#endif
}


#ifdef MATRIXTRUE
#ifdef SCHURTRUE
INT hall_littlewood_tafel(a,b) OP a,b;
/* AK 191289 a ist grad der sn b wird tafel */ /* AK 201289 V1.1 */
/* AK 200891 V1.3 */
{
	INT i,j;
	OP c = callocobject();
	OP d = callocobject();
	OP z,zz;
	makevectorofpart(a,c);
	m_ilih_nm(S_V_LI(c),S_V_LI(c),b);



	for (i=0L;i<S_V_LI(c);i++)
	{
		hall_littlewood(S_V_I(c,i),d);
		z = d;
		while (z != NULL) {
			zz = S_MO_S(S_L_S(z)); /* partition */
			for (j=0;j<S_V_LI(c);j++)
				if (EQ(zz,S_V_I(c,j))) break;
			copy(S_MO_K(S_L_S(z)),S_M_IJ(b,i,j));
			/* koef sind polynom */
			z = S_L_N(z);
		}
	}

	freeall(c);
	freeall(d);
	return(OK);
}
#endif /* SCHURTRUE */
#endif /* MATRIXTRUE */

#ifdef SCHURTRUE
INT hall_littlewood_alt(a,b) OP a,b;
/* AK 191289 a ist partition 
b wird das zugehoerige hall littlewood polynom */
/* mittels d_ij = langsam */ /* schneller morris mit skew schur */
/* AK 201289 V1.1 */
/* AK 200891 V1.3 */
{
	INT i,j;
	OP c = callocobject();

	if (not EMPTYP(b)) 
		freeself(b);
	init_hall_littlewood(a,c);

	for (i = 0;i<S_PA_LI(a);i++)
		for (j = i+1;j<S_PA_LI(a);j++)
			hall_littlewood_dij(c,c,i,j);

	reorder_hall_littlewood(c,b);
	return freeall(c); 
}
#endif /* SCHURTRUE */


INT init_hall_littlewood(a,b) OP a,b;
/* AK 200891 V1.3 */
{
	b_skn_s(callocobject(),callocobject(),NULL,b);
	copy_partition(a,S_S_S(b));
	m_skn_po(callocobject(),callocobject(),NULL,S_S_K(b));
	m_il_v(1L,S_PO_S(S_S_K(b)));
	M_I_I(0L,S_PO_SI(S_S_K(b),0L));
	M_I_I(1L,S_PO_K(S_S_K(b)));
	return(OK);
}

#ifdef SCHURTRUE
INT reorder_hall_littlewood(a,b) OP a,b;
/* AK 191289 
es werden die partitionen wieder neu sortiert
in die ansteigende form */
/* a is SCHUR */
/* AK 200891 V1.3 */
{
	OP z = a,d,e;
	OP zz,zzz;
	INT i,j;
	if (S_O_K(a) != SCHUR)
		return error("reorder_hall_littlewood: a not SCHUR ");
	if (a == b) { 
		zz = callocobject(); 
		*zz = *b;
		C_O_K(b,EMPTY);
		reorder_hall_littlewood(zz,b); 
		freeall(zz); 
		return OK;
		}
	if (not EMPTYP(b)) freeself(b);
	b_sn_l(NULL,NULL,b);
	C_O_K(b,SCHUR);
	while (z != NULL)
	{
		d = callocobject();
		zz = S_L_S(z); /* zz ist monom */
		copy_monom(zz,d);
		zzz = S_MO_S(d); /* zzz ist partition */
re_again:
		for (i=1;i<S_PA_LI(zzz);i++)
		{
			
			if (S_PA_II(zzz,0L) < 0L)
			{
				freeall(d); 
				goto re_while_ende;
			}
			else if (S_PA_II(zzz,i) == S_PA_II(zzz,i-1) -1)
			{
				freeall(d); 
				goto re_while_ende;
			}
			else if (S_PA_II(zzz,i) < S_PA_II(zzz,i-1) )
			{
				addinvers_apply(S_MO_K(d));
				INC_INTEGER(S_PA_I(zzz,i));
				DEC_INTEGER(S_PA_I(zzz,i-1));
				swap(S_PA_I(zzz,i),S_PA_I(zzz,i-1));
				goto re_again;
			}
		}
		for (i=0L;i<S_PA_LI(zzz);i++) if (S_PA_II(zzz,i)>0L) break;
		/* noch nach links schieben */
		for (j=i;j<S_PA_LI(zzz);j++)
			M_I_I(S_PA_II(zzz,j),S_PA_I(zzz,j-i));
		M_I_I(S_PA_LI(zzz)-i,S_PA_L(zzz));
		
		e = callocobject();
		b_sn_l(d,NULL,e);
		C_O_K(e,SCHUR);
		insert(e,b,add_koeff,comp_monomvector_monomvector);
re_while_ende:
		z = S_L_N(z);
	}
	if (S_L_S(b) == NULL) 
		freeself(b);
	return(OK);
}
#endif /* SCHURTRUE */

#ifdef SCHURTRUE 
INT hall_littlewood_dij(a,b,i,j) OP a,b; INT i,j;
/* AK 181289 
bei der berechnung von hall littlewood polynomen benoetigt
man die anwendung vomuliplikation mit
(1 + t * d_ij + t^2 * d_ij^2 ... )
eingabe: a = hall_littlewood polynom
	 i<j indices
ausgabe: b neues hall_littlewood polynom 
*/
/* hall littlewood polynome sind schurpolynome mit polynomen in t als koeff*/
/* AK 201289 V1.1 */
/* AK 200891 V1.3 */
{
	INT k,tt;
	OP sp = callocobject();
	OP z,zz,zzz;

	copy_list(a,sp); /* funktioniert auch beim aufruf mit gleichen variablen */
	copy_list(sp,b); /* die multiplikation mit 1 */
	for (k=1;;k++)
	{
		tt = 0L;
		z = sp;
		while (z != NULL)
		{
			zz = S_L_S(z);
			zzz = S_MO_S(zz);
			if (j <= S_PA_LI(zzz)) /* index j zulaessig */
				if (S_PA_II(zzz,i) >= (k-i) ) {
					OP d = callocobject();
					OP e = callocobject();
					tt = 1L;
					copy(zz,d);
					M_I_I(S_PA_II(zzz,i)-k,S_PA_I(S_MO_S(d),i));
					M_I_I(S_PA_II(zzz,j)+k,S_PA_I(S_MO_S(d),j));
					b_skn_po(callocobject(),callocobject(),NULL,e);
					m_il_v(1L,S_PO_S(e));
					M_I_I(k,S_PO_SI(e,0L));
					M_I_I(1L,S_PO_K(e)); /* e = t^k */
					mult(e,S_MO_K(d),S_MO_K(d));
					insert(d,b,add_koeff,comp_monomvector_monomvector);
					/* add(d,b,b);*/
					freeall(e);/*freeall(d);*/
				}
			z = S_L_N(z);
		}
		if (tt == 0L) break; /* ende */
	}
	freeall(sp);
	return(OK);
}
#endif /* SCHURTRUE */

INT tex_hall_littlewood(a) OP a;
/* AK 191289 tex ausgabe */
/* AK 200891 V1.3 */
{ 
	tex(a); 
}


#ifdef SKEWPARTTRUE
#ifdef SCHURTRUE
INT m_skewpart_skewperm(a,b) OP a,b;
/* AK 221289 V1.1 */ /* AK 010791 V1.2 */
/* es wird die permutation fuer die berechnung der skew schur funktion
berechnet */
/* vgl. m_part_part_perm() */
/* AK 130891 V1.3 */
{
	OP d = callocobject(); /* d wird der code vector */
	OP c = callocobject(); /* c gewicht der kleineren partition */
	INT k,i,j,h;
	INT lg = S_SPA_GLI(a);
	INT lk = S_SPA_KLI(a); /* die laengen der beiden partitionen */

	weight(S_SPA_K(a),c);
	k = S_PA_II(S_SPA_G(a),lg-1L);
	/* k ist der letzte eintrag in der groesseren partition */
	m_il_v(S_I_I(c) + k + S_PA_LI(S_SPA_G(a)),d);
	freeall(c);
	for (i=0L;i<lg-lk;i++) M_I_I(S_SPA_GII(a,i),S_V_I(d,i));
	/* zuerst werden die teile aus der grossen partition kopiert */
	h = i; /* h ist laufindex durch vector */
	/* i ist laufindex durch grosse partition j durch kleine */
	for (j=0L;j<lk;j++,i++,h++)
	{
		if (j==0L) /* error in version < 010791 */
			for (k=0L;k<S_SPA_KII(a,j);k++,h++)
				M_I_I(0L,S_V_I(d,h));
		else
			for (k=0L;k<S_SPA_KII(a,j)-S_SPA_KII(a,j-1L);k++,h++)
				M_I_I(0L,S_V_I(d,h));
		M_I_I(S_SPA_GII(a,i)-S_SPA_KII(a,j),S_V_I(d,h));
	}
	for (;h<S_V_LI(d);h++) 
		M_I_I(0L,S_V_I(d,h));
	lehmercode_vector(d,b);
	freeall(d);
	return(OK);
}
#endif /* SCHURTRUE */
#endif /* SKEWPARTTRUE */

#ifdef SCHURTRUE
#ifdef SKEWPARTTRUE
INT part_part_skewschur(a,b,c) OP a,b,c;
/* AK 221289 V1.1 */ /* AK 010791 V1.2 */
/* a ist die groessere partition */
/* AK 130891 V1.3 */
{
	OP d,e;
	INT i,j;
	INT erg = OK;

	if (not EMPTYP(c)) 
		freeself(c);
	i = S_PA_LI(a)-1;
	j = S_PA_LI(b)-1;
	if (j > i) return(OK);
	for(;j>=0;j--,i--)
		if (S_PA_II(a,i) < S_PA_II(b,j)) 
			return(OK);
	/* zuerst test ob b kleiner a */
	/* falls nicht ist das ergebnis ein leeres object */
	d = callocobject();
	e = callocobject();
	erg += b_gk_spa(callocobject(),callocobject(),d);
	erg += copy_partition(a,S_SPA_G(d));
	erg += copy_partition(b,S_SPA_K(d));
	erg += m_skewpart_skewperm(d,e);
	erg += newtrans(e,c);
	erg += freeall(d); 
	erg += freeall(e); 
	if (erg != OK)
		error("part_part_skewschur:error during computation");
	return erg;
}
#endif /* SKEWPARTTRUE */
#endif /* SCHURTRUE */

#ifdef SCHURTRUE
#ifdef SKEWPARTTRUE

INT hall_littlewood(a,b) OP a,b;
/* AK 221289 V1.1 
die zweite methode, siehe morris 1963 */
/* Math. Zeit 81 112-123 (1963) */
/* AK 200891 V1.3 */
{
	OP c,d,e,f,g,z,zz;
	INT i;
	INT dt=0L;
	if (not EMPTYP(b) ) 
		freeself(b);
	if (S_PA_LI(a) == 1L) 
		{
		b_skn_s(callocobject(),callocobject(),NULL,b);
		copy(a,S_S_S(b));
		b_skn_po(callocobject(),callocobject(),NULL,S_S_K(b));
		M_I_I(1L,S_PO_K(S_S_K(b)));
		m_il_v(1L,S_PO_S(S_S_K(b)));
		M_I_I(0L,S_PO_SI(S_S_K(b),0L));
		return(OK);
		}
	/* wenn die laenge groesser 1 ist */

	b_sn_l(NULL,NULL,b); C_O_K(b,SCHUR);
	c = callocobject(); d = callocobject(); e = callocobject();
	g = callocobject();
	copy_partition(a,c); 
	DEC_PARTITION(c);
	hall_littlewood(c,d);
	if (dt) { fprintf(stderr, "d = "); fprintln(stderr,d); }
	weight_partition(c,e);
	copy(d,c);
	z = c; 
	while (z != NULL)
		{
		INC_PARTITION(S_S_S(z));
	/* m_i_i statt M_I_I wg. MSC */
		m_i_i(	S_PA_II(a,S_PA_LI(a)-1L),
	/* s_s_si statt S_S_SI wg. MSC */
			s_s_si(z,S_S_SLI(z)-1L)
		     );
		z = S_S_N(z);
		}
	f = callocobject();
	reorder_hall_littlewood(c,f);
if (not EMPTYP(f)) insert(f,b,add_koeff,comp_monomvector_monomvector); else free(f);
	if (dt) { fprintf(stderr, "b = "); fprintln(stderr,b); }
	copy(d,c);
	for (i=1L;i<=S_I_I(e); i++)
		{
		if (not EMPTYP(g))
			freeself(g);
		m_i_pa(e,g);M_I_I(i,S_PA_I(g,0L));
		if (not EMPTYP(d))
			freeself(d);
		z = c; /* c ist das ergebnis der rekursion */
		b_sn_l(NULL,NULL,d); C_O_K(d,SCHUR);
		while (z != NULL)
			{
			f = callocobject();
	if (dt) { fprintf(stderr, "g = "); fprintln(stderr,g); }
	if (dt) { fprintf(stderr, "z = "); fprintln(stderr,z); }
			part_part_skewschur(S_S_S(z),g,f);
	if (dt) { fprintf(stderr, "f = "); fprintln(stderr,f); }
			if (not EMPTYP(f)) {
				zz = f;
				while (zz != NULL) {
					mult(S_S_K(zz),S_S_K(z),S_S_K(zz));
					zz = S_S_N(zz); }
			insert(f,d,add_koeff,comp_monomvector_monomvector);
				}
			else free(f);
			z = S_S_N(z);
			}
	/* d ist nun die liste mit den expansion der skewpartition */
	if (dt) { fprintf(stderr, "d = "); fprintln(stderr,d); }
		z = d; 
	/* nun noch die multiplikation mit t^i */
		if (not EMPTYP(g))
			freeself(g);
		b_skn_po(callocobject(),callocobject(),NULL,g);
		M_I_I(1L,S_PO_K(g));
		m_il_v(1L,S_PO_S(g));
		M_I_I(i,S_PO_SI(g,0L));
	while (z != NULL)
		{
		INC_PARTITION(S_S_S(z));
	/* m_i_i statt M_I_I wg. MSC */
		m_i_i(	S_PA_II(a,S_PA_LI(a)-1L)+i,
	/* s_s_si statt S_S_SI wg. MSC */
			s_s_si(z,S_S_SLI(z)-1L)
		     );
/* alt:
		M_I_I(		S_PA_II(a,S_PA_LI(a)-1L)+i,
				S_PA_I(	S_S_S(z),
					S_PA_LI(S_S_S(z))-1L)
		     ); */
		mult(g,S_S_K(z),S_S_K(z));
		z = S_S_N(z);
		}

	f = callocobject();
	reorder_hall_littlewood(d,f);
	insert(f,b,add_koeff,comp_monomvector_monomvector);

		}

	freeall(e); freeall(d); freeall(c);freeall(g);
	return(OK);
}
#endif /* SKEWPARTTRUE */
#endif /* SCHURTRUE */

#ifdef SCHURTRUE
INT add_apply_schur_schur(a,b) OP a,b;
/* AK 200891 V1.3 */
	{
	OP c = callocobject();
	copy_polynom(a,c);
	return(insert(c,b,add_koeff,comp_monomvector_monomvector));
	}
#endif /* SCHURTRUE */

#ifdef SCHURTRUE
INT add_apply_schur(a,b) OP a,b;
/* AK 220390 V1.1 */
/* AK 200891 V1.3 */
{
	if (EMPTYP(b)) return(copy_polynom(a,b));
	switch(S_O_K(b)) {
		case SCHUR: return(add_apply_schur_schur(a,b));
		default:
			printobjectkind(b);
			error("add_apply_schur:wrong second type");
			return(ERROR);
		}
}
#endif /* SCHURTRUE */

#ifdef SCHURTRUE
INT dimension_schur(a,b) OP a,b;
/* computes the dimension of the corresponding representation */
/* AK 020890 V1.1 */
/* AK 200891 V1.3 */
{
OP z = a;
OP erg = callocobject();
m_i_i(0L,b); /* frees b */
while (z != NULL)
	{
	dimension(S_S_S(z),erg);
	add(erg,b,b);
	z = S_S_N(z);
	}
freeall(erg);return OK;
}
#endif /* SCHURTRUE */


#ifdef SCHURTRUE
INT add_staircase_part(a,n,b) OP a,n,b;
/* adds the vector 0,1,...,n-1 to the partition a */
/* AK 050990 V1.1 */
/* AK 200891 V1.3 */
	{
	OP c = callocobject();
	INT i,j;
	m_l_v(n,c);
	for (i=S_V_LI(c)-1L,j=S_PA_LI(a)-1L;i>=0L;i--,j--)
		if (j>=0L) M_I_I(S_PA_II(a,j)+i,S_V_I(c,i));
		else M_I_I(i,S_V_I(c,i));
	if (not EMPTYP(b)) freeself(b);
	b_ks_pa(VECTOR,c,b);
	return OK;
	}
#endif /* SCHURTRUE */

#ifdef SCHURTRUE
INT mod_part(a,b,c) OP a,b,c;
/* the single parts of partition a mod b gives c */
/* AK 050990 V1.1 */
/* AK 200891 V1.3 */
	{
	INT i;
	if (a != c) copy(a,c);
	for (i=0;i<S_PA_LI(c);i++)
		M_I_I(S_PA_II(c,i) % S_I_I(b), S_PA_I(c,i));
	return OK;
	}
#endif /* SCHURTRUE */

#ifdef SCHURTRUE
INT p_root_schur(a,n,p,b) OP a,n,p,b;
/* a ist schur n ist integer p ist integer b wird schur */
/* AK 050990 V1.1 */
/* wie folgt wird gerechnet: addiere 0,..,n-2,n-1 zu den
partitionen, die die laenger als n sind werden gestrichen,
dann die partition modulo p, dann wieder zu aufsteigenden
partitionen um sortieren */
/*dies entspricht dem einsetzen von p-ten einheitswurzeln */
/* AK 200891 V1.3 */
	{
	OP z,c,d;
	if (a == b ) { c = callocobject(); copy(a,c);
		p_root_schur(c,n,p,b); freeall(c); return OK; }

	z = a;
	if (not EMPTYP(b) ) freeself(b);
	b_sn_l(NULL,NULL,b);C_O_K(b,SCHUR);

	while (z != NULL)
		{
		if (S_S_SLI(z) <= S_I_I(n)) 
			{
			c = callocobject();
			d = callocobject();
			p_root_part(S_S_S(z),n,p,c);
			b_skn_s(c,callocobject(),NULL,d);
			copy(S_S_K(z),S_S_K(d));
			insert(d,b,NULL,NULL);
			}
		z = S_S_N(z);
		}
	reorder_hall_littlewood(b,b);
	return OK;
	}
#endif /* SCHURTRUE */

#ifdef SCHURTRUE
INT p_root_part(a,n,p,b) OP a,n,p,b;
/* a ist part, n ist integer, p ist integer */
/* AK 050990 V1.1 */
/* AK 200891 V1.3 */
	{
	INT i;
	OP c = callocobject();
	m_l_v(n,c);
	for (i=0L; i<S_V_LI(c); i++) M_I_I(i,S_V_I(c,i));
	add_staircase_part(a,n,b);
	mod_part(b,p,b); 
	sub(S_PA_S(b),c,S_PA_S(b));
	freeall(c); return OK;
	}
#endif /* SCHURTRUE */

#ifdef SCHURTRUE
INT m_i_schur(a,b) INT a; OP b;
/* changes a INT into a SCHURpolynomial with this INT as 
koeffizent and labeled by the part with one zero part */
/* AK 181290 V1.1 */
/* AK 200891 V1.3 */
{
	OP c = callocobject();
	m_i_i(a,c); 
	m_scalar_schur(c,b); 
	freeall(c);
	return OK;
}
#endif /* SCHURTRUE */

#ifdef SCHURTRUE
INT m_scalar_schur(a,b)  OP a,b;
/* changes a scalar into a SCHURpolynomial with this scalar as 
koeffizent and labeled by the part with one zero part */
/* AK 181290 V1.1 */ /* AK 200891 V1.3 */
{
	if (not EMPTYP(b)) freeself (b);
	b_skn_s(callocobject(),callocobject(),NULL,b);
	copy(a,S_SCH_K(b));
	b_ks_pa(VECTOR,callocobject(),S_SCH_S(b));
	m_il_v(1L,S_PA_S(S_S_S(b)));
	M_I_I(0L,S_PA_I(S_S_S(b),0L));
	return OK;
}
#endif /* SCHURTRUE */

#ifdef SCHURTRUE 
INT mult_power_schur(a,b,c) OP a,b,c;
/* a is INTEGER
   b is SCHUR
   c becomes SCHUR */
/* AK 200891 V1.3 */
{
	OP z=b;
	OP d;
	INT erg = OK;
	erg += init(SCHUR,c);
	while (z != NULL)
		{
		d = callocobject();
		erg += mult_power_part(a,S_S_S(z),d);
		erg += mult_apply(S_S_K(z),d);
		erg += add_apply(d,c);
		z = S_S_N(z);
		}
	return erg;
}
#endif /* SCHURTRUE */

#ifdef SCHURTRUE
INT mult_power_part(a,b,c) OP a,b,c;
/* a is INTEGER
   b is PARTITION
   c becomes SCHUR */
/* AK 200891 V1.3 */
{
	OP d,e;
	INT i,j;
	INT erg=OK;
	e = callocobject();
	erg += init(SCHUR,e);
	for (i=0L; i<S_I_I(a)+S_PA_LI(b); i++)
		{
		d = callocobject();
		erg += b_skn_s(callocobject(),callocobject(),NULL,d);
		erg += M_I_I(1L,S_S_K(d));
		erg += b_ks_pa(VECTOR,callocobject(),S_S_S(d));
		erg += m_il_v(S_I_I(a)+S_PA_LI(b),S_PA_S(S_S_S(d)));
		for (j=0L;j<S_I_I(a);j++)
			erg += M_I_I(0L,S_S_SI(d,j));
		for (j=0L;j<S_PA_LI(b);j++)
			erg += M_I_I(S_PA_II(b,j),S_S_SI(d,j+S_I_I(a)));
		/* now we have copied the partition with leading zeros */
		erg += M_I_I(S_I_I(a)+S_S_SII(d,i),S_S_SI(d,i));
		insert(d,e,NULL,NULL);
		}
	erg += reorder_hall_littlewood(e,c);
	erg += freeall(e);
	return erg;
}
#endif /* SCHURTRUE */

#ifdef SCHURTRUE
INT add_schur(a,b,d) OP a,b,d;
/* AK 050891 V1.3 */
{
	INT erg = OK;

		switch(S_O_K(b))
		{
		case INTEGER: /* AK 210891 */
			if (S_I_I(b) == 0L) erg += copy(a,d);	
			else erg += ERROR;
			break;
		case MONOM: erg += add_monom_schur(b,a,d);break;
		case PARTITION : erg += m_pa_s(b,d);
				erg += add(a,d,d);break;
		case SCHUR : erg += add_schur_schur(a,b,d);break;
		default :
			printobjectkind(b);
			return error("add_schur:wrong second type");
		};
	if (erg != OK) /* AK 210891 */
		error("add_schur:error during computation");
	return erg;
}
#endif /* SCHURTRUE */

#ifdef HOMSYMTRUE
INT add_homsym(a,b,d) OP a,b,d;
/* AK 050891 V1.3 */
{
	INT erg = OK;

		switch(S_O_K(b))
		{
		case MONOM: erg += add_monom_homsym(b,a,d);break;
		case PARTITION : erg += m_pa_h(b,d);
				erg += add(a,d,d);break;
		case HOM_SYM : erg += add_homsym_homsym(a,b,d);break;
		default :
			{
				printobjectkind(b);
				return error("add_schur:wrong second type");
			}
		};
	return erg;
}
#endif /* HOMSYMTRUE */

#ifdef SCHURTRUE
INT mult_schur(a,b,d) OP a,b,d;
/* AK 050891 V1.3 */
{
	INT erg = OK;
		switch(S_O_K(b))
		{
		case CYCLOTOMIC: /* AK 260991 */
		case SQ_RADICAL: /* AK 260991 */
		case POLYNOM: /* AK 260991 */
		case LONGINT: /* AK 260991 */
		case BRUCH:
		case INTEGER:  erg+= mult_scalar_schur(b, a, d);break;
		case SCHUR:  erg+=mult_schur_schur(a, b, d);break;
		default: 
				printobjectkind(b);
				error("mult_schur:wrong second type");
				return ERROR;
		};
	return erg;
}
#endif /* SCHURTRUE */

#ifdef HOMSYMTRUE
INT mult_homsym(a,b,d) OP a,b,d;
/* AK 060891 V1.3 */
{
	INT erg = OK;
		switch(S_O_K(b))
		{

		case BRUCH:
		case CYCLOTOMIC:
		case SQ_RADICAL:
		case LONGINT:
		case INTEGER:  erg+= mult_scalar_homsym(b, a, d);break;
		case MATRIX:   erg+= mult_scalar_matrix(a,b,d); break;
		case HOM_SYM:  erg+=mult_homsym_homsym(a, b, d);break;
		default: 
				printobjectkind(b);
				error("mult_homsym:wrong second type");
				return ERROR;
		};
	return erg;
}

INT mult_homsym_homsym(a,b,d) OP a,b,d;
/* AK 200891 V1.3 */
{
	OP z = a,y,c;
	INT erg = OK;

	init(HOM_SYM,d);
	while (z != NULL)
		{
		y = b;
		while (y != NULL)
			{
			c = callocobject();
			erg += b_skn_h(callocobject(),callocobject(),NULL,c);
			erg += mult(S_S_K(y),S_S_K(z),S_S_K(c));
			erg += append(S_S_S(y),S_S_S(z),S_S_S(c));
			insert(c,d,NULL,NULL);
			y = S_S_N(y);
			}
		z = S_S_N(z);
		}

	return erg;
}
#endif /* HOMSYMTRUE */
