#include "def.h"
#include "macro.h"

static struct partition * callocpartition();
static INT m060588();
static INT m060588b();

static struct partition **pa_sp = NULL;  /* speicher fuer partitionen */
static INT pa_index = -1L;
#define PASIZE 1000L

#define M_KL_PA(a,b,c) (b_ks_pa(a,callocobject(),c) || m_l_v(b,S_PA_S(c)))
#define B_KL_PA(a,b,c) (b_ks_pa(a,callocobject(),c) || b_l_v(b,S_PA_S(c)))

#ifdef PARTTRUE
INT partitionp(a) OP a;
/* AK 170692 */
{
	INT i;
	if ( S_O_K(a) != PARTITION ) return FALSE;
	if ( S_PA_K(a) == VECTOR )
		{
		INT m=1L;
		for (i=0L;i<S_PA_LI(a); i++)
			{
			if (S_O_K(S_PA_I(a,i)) != INTEGER) return FALSE;
			if (S_PA_II(a,i) < m) return FALSE;
			m = S_PA_II(a,i);
			}
		return TRUE;
		}
	if ( S_PA_K(a) == EXPONENT )
		for (i=0L;i<S_PA_LI(a); i++)
			if (S_O_K(S_PA_I(a,i)) != INTEGER) return FALSE;
	return FALSE;
}
#endif /* PARTTRUE */

#ifdef PARTTRUE
INT add_part_part(a,b,c) OP a,b,c;
/* c = a + b */ /* AK 071189 */ /* AK 181289 V1.1 */ /* AK090891 V1.3 */
/* componenten weise */
{
	INT i,j;
	if (not EMPTYP(c)) 
		freeself(c);
	if (le(S_PA_L(a),S_PA_L(b))) {
		copy_partition(b,c);
		for (i=S_PA_LI(a)-1L,j=S_PA_LI(b)-1L;i>=0L;i--,j--)
			add(S_PA_I(a,i),S_PA_I(b,j),S_PA_I(c,j));
		return(OK);
	}
	copy_partition(a,c);
	for (i=S_PA_LI(a)-1L,j=S_PA_LI(b)-1L;j>=0L;i--,j--)
		add(S_PA_I(a,i),S_PA_I(b,j),S_PA_I(c,i));
	return(OK);

}
#endif /* PARTTRUE */

#ifdef PARTTRUE
INT append_part_part(a,b,c) OP a,b,c;
/* AK 090891 V1.3 */
/* join the parts to one partition */
/* e.g. 233, 1224 --> 1222334 */
{
	OP d;
	INT erg = OK;
	if (S_O_K(b) != PARTITION) /* AK 040292 */
		return error("append_part_part: second OP  != PARTITION");
	d = callocobject();
	erg += append(S_PA_S(a),S_PA_S(b),d);
	erg += m_v_pa(d,c);
	erg += freeall(d);
	return erg; 
}
#endif /* PARTTRUE */ 

#ifdef PARTTRUE
INT add_partition(a,b,c) OP a,b,c;
/* AK 060789 V1.0 */ /* AK 280590 V1.1 */ /* AK 200891 V1.3 */
{
	INT erg = OK; /* AK 040292 */
	switch(S_O_K(b))
	{
	case PARTITION : erg += add_part_part(a,b,c); break;
#ifdef SCHURTRUE
	case SCHUR : erg += m_pa_s(a,c); erg+=add(c,b,c); break;
#endif /* SCHURTRUE */
	default : 
		{ 	printobjectkind(b);
			return error("add_partition:wrong second type");
		};
	}
	if (erg != OK) /* AK 040292 */
		return error("add_partition: error during computation");
}
#endif /* PARTTRUE */

#ifdef PARTTRUE
INT first_composition(w,parts,c) OP parts, w, c;
/* AK 090487 */ /* AK 201189 V1.1 */ /* AK 150591 V1.2 */ /* AK 200891 V1.3 */
{
	INT i,erg=OK;
	if (not EMPTYP(c)) 
		erg += freeself(c);
	erg += m_il_v(S_I_I(parts),c);
	erg += copy(w,S_V_I(c,0L));
	for (i=1L;i<S_V_LI(c);M_I_I(0L,S_V_I(c,i)),i++);
	C_O_K(c,COMP);
	return erg;
}
#endif /* PARTTRUE */

#ifdef PARTTRUE
INT next_composition(c,newcomp) OP c, newcomp;
/* AK 300889 */ /* AK 201189 V1.1 */ /* AK 200891 V1.3 */
{
	INT i,j,rest;
	/* c ist ein vector */
	/* newcomp ist ein vector */
	copy(c,newcomp);
	for (i=S_V_LI(newcomp)-2L,j=i+1L,rest=0L; i>=0L; i--,j--)
		if (S_V_II(newcomp,i) == 0L)
		{
			rest += S_V_II(newcomp,j);
			C_I_I(S_V_I(newcomp,j),0L);
		}
		else if (S_V_II(newcomp,i) > 0L)
		{
			DEC_INTEGER(S_V_I(newcomp,i));
			C_I_I(S_V_I(newcomp,j),S_V_II(newcomp,j)+1L+rest);
			return(OK);
		};
	return(LASTCOMP);
}
#endif /* PARTTRUE */


#ifdef PARTTRUE
INT fastconjugate_partition(part,b) OP part, b;
/* AK 220587 */
/* konjugierte einer partition nach satz in macdonald
aber auch nicht viel schneller als conjugatepartition */
/* AK 060789 V1.0 */ /* AK 240490 V1.1 */ /* AK 200891 V1.3 */
{
	INT i,j,k=0L,m;
	/* k ist die adresse an der geschrieben wird im b */
	INT erg = OK;

	if (S_O_K(part) != PARTITION) return ERROR;  /* AK 170692 */
	if (S_PA_K(part) == EXPONENT)  /* AK 170692 */
		{
		OP c = callocobject();
		erg += t_EXPONENT_VECTOR(part,c);
		erg += fastconjugate_partition(c,b);
		erg += freeall(c);
		erg += t_VECTOR_EXPONENT(b,b);
		return erg;
		}
	if (S_PA_K(part) != VECTOR) return ERROR;  /* AK 170692 */

	b_ks_pa(VECTOR,callocobject(),b);
	m_il_v(S_PA_II(part,S_PA_LI(part)-1L),S_PA_S(b));

	j = S_PA_LI(part) - 1L;
	/* dies sind die adressen in den beiden partitionen */
	m = S_PA_LI(b)+S_PA_LI(part)+1L;
	/* dies ist die laenge der permutation + 1 */
	for(	i=m-1L; i > 0L ; i--)
	{
		if (j>=0)
			if (i == S_PA_II(part,j)+j+1L ) j-- ;
			else {
				M_I_I(m-i- k - 1L,S_PA_I(b,k));
				k++ ;
			}
		else	{
			M_I_I(m-i- k - 1L,S_PA_I(b,k));
			k++ ;
		}
	}
	return(OK);
}
#endif /* PARTTRUE */

#ifdef PARTTRUE
INT ferrers_partition(part) OP part;
/* AK 060789 V1.0 */ /* AK 150690 V1.1 */ /* AK 200891 V1.3 */
{
	INT i,j;

	printf("\n");
	for (i=0L; i<S_PA_LI(part);i++)
	{
		for (j=0L;j<S_PA_II(part,i);j++) printf("**** ");
		printf("\n");
		for (j=0L;j<S_PA_II(part,i);j++) printf("**** ");
		printf("\n");
	};
	zeilenposition = 0L;
	return(OK);
}
#endif  /* PARTTRUE */

#ifdef PARTTRUE
INT fprint_partition(f,partobj) FILE	*f; OP partobj;
/* AK 140587 */ /* AK 060789 V1.0 */ /* AK 290890 V1.1 */ /* AK 200891 V1.3 */
{
	INT i;
	for(	i = 0L; i<S_PA_LI(partobj); i++)
		if (S_PA_II(partobj,i)<10)
		/*AK partitionsteile kleiner 10 werden als Zahlen geschrieben */
		{ 
			fprintf(f,"%d",S_PA_II(partobj,i));
			if (f == stdout) zeilenposition++; 
		}
		else if (S_PA_II(partobj,i)<16)
		/* A.K. partitionsteile von 10 bis 15 werden als 
			A,B,C,D,E,F geschrieben */
		{ 
			fprintf(f,"%c",S_PA_II(partobj,i)+55);
			if (f == stdout) zeilenposition++; 
		}
		else	{
			/* A.K. sonst werden die Teile als zahl mit 
			abschliessenden senkrechten Strich geschrieben */
			fprintf(f,"%c%d",'|',S_PA_II(partobj,i));
			if(f==stdout) 
				zeilenposition+=(1+intlog(S_PA_I(partobj,i)));
			};
	if ((f == stdout)&&(zeilenposition>70L))
	{ 
		fprintf(f,"\n"); 
		zeilenposition = 0L; 
	}
	return(OK);
}
#endif /* PARTTRUE */


INT gupta_nm(n,m,erg) OP n,m,erg;
/* AK 220888 
	vgl. Hansraj Gupta Proc London Math Soc 2 (39)
	1935 142-149 dort werden die Anzahlen der Partitionen von n
	bis n=300 aufgelistet. Zur Berechnung mittels einer
	Rekurssion werden die Zahlen (n,m) = Anzahl der Partitionen
	von n mit dem kleinsten Teil = m benoetigt
	Diese werden rekursiv berechnet, diese Zahlen 
	werden auch von dieser Prozedur berechnet
	*/
/* AK 060789 V1.0 */ /* AK 120390 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef PARTTRUE
	OP i,j,zw;


	if (not EMPTYP(erg)) if (S_O_K(erg) != INTEGER) freeself(erg);

	if (S_I_I(n) == S_I_I(m)) return(M_I_I(1L,erg));
	if (S_I_I(m) > S_I_I(n)/2L) return(M_I_I(0L,erg));

	i = callocobject(); j = callocobject(); zw = callocobject();
	/* initialisieren i = n-m, j = m, erg = 0 */
	M_I_I(S_I_I(n)-S_I_I(m),i); 
	COPY_INTEGER(m,j); 
	M_I_I(0L,erg);
	
	while(S_I_I(j) <= S_I_I(i) )
	{ 
		gupta_nm(i,j,zw); 
		if (S_O_K(zw) != INTEGER) add_apply(zw,erg); 
		else if (not NULLP_INTEGER(zw)) add_apply(zw,erg); 
		/* nicht aufrufen falls 0 */
		INC_INTEGER(j); 
	}

	if (S_O_K(zw) == INTEGER) free(zw); else freeall(zw); 
	free(i); free(j); /* beides INTEGER */
	return(OK);
#endif /* PARTTRUE */
}

INT gupta_tafel(mx,mat) OP mx,mat;
/* AK 220888 */
/* berechnet partitionen bis n=mx */
/* erstellt tafel */
/* AK 060789 V1.0 */ /* AK 120390 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef PARTTRUE
#ifdef MATRIXTRUE
	INT i,j,k;
	OP h = callocobject();
	OP l = callocobject();
	OP zw = callocobject();

	M_I_I(S_I_I(mx),h); 
	M_I_I((S_I_I(mx) / 2L)+1L,l);

	b_lh_m(l,h,mat); /* da sollen zahlen rein */

	for (i=0L; i< S_I_I(mx); i++)
	{
		for (j=0L;j<=i/2L;j++)
		{
			freeself(zw);
			M_I_I(0L,zw);
			for (k=0L; j+k < (i-j)/2L ; k++)
			/* die rekursion */
			{
				add_apply(S_M_IJ(mat,i-j-1L,j+k),zw);
			}
			inc(zw);
			copy(zw,S_M_IJ(mat,i,j));
		};
	}

	freeall(zw);
	return(OK);
#else /* MATRIXTRUE */
	return error("gupta_tafel: MATRIX not available");
#endif /* MATRIXTRUE */
#else /* PARTTRUE */
	return error("gupta_tafel: PARTITION not available");
#endif /* PARTTRUE */
}

INT gupta_nm_speicher(n,m,erg) OP n,m,erg;
/* AK 220888 mit speicher */
/* AK 120390 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef MATRIXTRUE
#ifdef PARTTRUE
	OP mat;

	if (S_I_I(n) == S_I_I(m)) return(M_I_I(1L,erg));
	if (S_I_I(m) > S_I_I(n)/2L) return(M_I_I(0L,erg));

	mat = callocobject();
	gupta_tafel(n,mat);
	copy(S_M_IJ(mat,S_I_I(n)-1L,S_I_I(m)-1L),erg);
	freeall(mat);
	return(OK);
#endif  /* PARTTRUE */
#else /* MATRIXTRUE */
	return error("gupta_nm_speicher: MATRIX not available");
#endif /* MATRIXTRUE */
}

#ifdef PARTTRUE
INT hook_length_augpart(p,i,j,erg) OP p,erg; INT i,j;
/* AK 060988 hakenlaenge */ 
/* AK 060789 V1.0 */ /* AK 080290 V1.1 */ /* AK 200891 V1.3 */
{
	INT e,k;
	if (not EMPTYP(erg)) 
		if (S_O_K(erg) != INTEGER) 
			freeself(erg);
	if (i >= S_PA_LI(p)) return(M_I_I(0L,erg));
	if (j >= S_PA_II(p,i)-i) return(M_I_I(0L,erg));
	e = S_PA_II(p,i) - j - i;
	/* nun noch die zeilen dazu */
	for (k=i-1L; k>= 0L; k--)
		if (S_PA_II(p,k) -1L -k >= j) 
			e++;
		else break;
	return(M_I_I(e,erg));
}
#endif /* PARTTRUE */

#ifdef PARTTRUE
INT hook_length(p,i,j,b) OP p,b; INT i,j;
/* AK 060988 hakenlaenge */ 
/* AK 060789 V1.0 */ /* AK 150690 V1.1 */ /* AK 200891 V1.3 */
{
	INT e,k;
	if (S_O_K(p) != PARTITION) 
		{
		printobjectkind(p); return error("hook_length:no part");
		}
	if (S_PA_K(p) == EXPONENT)  /* AK 170692 */
		{
		OP c = callocobject();
		e = t_EXPONENT_VECTOR(p,c);
		e += hook_length(c,i,j,b);
		e += freeall(c);
		return e;
		}
	if (S_PA_K(p) != VECTOR)
		return ERROR;

	if (not EMPTYP(b)) 
		freeself(b);
	if (i >= S_PA_LI(p)) 
		return(M_I_I(0L,b), OK);
	if (j >= S_PA_II(p,S_PA_LI(p)-1L-i)) 
		return(M_I_I(0L,b), OK);
	e = S_PA_II(p,S_PA_LI(p)-1L-i) - j;
	/* nun noch die zeilen dazu */
	for (k=i+1L; k<S_PA_LI(p); k++) 
		if (S_PA_II(p,S_PA_LI(p)-1L-k) -1L >= j) e++;
		else break;
	M_I_I(e,b);
	return(OK);
}
#endif /* PARTTRUE */

#ifdef PARTTRUE
INT dimension_partition(a,b) OP a,b;
/* AK 150988 */
/* es wird die dimension des durch die partition bezeichneten Characters der Sn
berechnet. Dazu wird die hakenformel verwendet */
/* AK 060789 V1.0 */ /* AK 080290 V1.1 */ /* AK 050391 V1.2 */ 
/* AK 200891 V1.3 */
{
	OP zaehler, nenner,  zw;
	INT i,j;
	INT erg = OK;

	if (S_O_K(a) != PARTITION) return ERROR; /* AK 170692 */
	if (S_PA_K(a) == EXPONENT) /* AK 170692 */
		{
		zw = callocobject();
		erg += t_EXPONENT_VECTOR(a,zw);
		erg += dimension_partition(zw,b);
		erg += freeall(zw);
		return erg;
		}
	if (S_PA_K(a)  != VECTOR) return ERROR; /* AK 170692 */

	zw = callocobject();
	zaehler = callocobject();
	erg = weight(a,zw);

	erg += fakul(zw,zaehler);
	erg += freeself(zw);
	nenner = callocobject(); 
	erg += M_I_I(1L,nenner);
	for (i=0L;i<S_PA_LI(a);i++)
		for (j=0L;j<S_PA_II(a,S_PA_LI(a)-1L-i);j++)
		{
			erg += hook_length(a,i,j,zw);
			erg += mult_apply(zw,nenner);
		};
	erg += freeall(zw);
	erg += ganzdiv(zaehler,nenner,b); /* statt div AK 170889 */
	erg += freeall(zaehler);
	erg += freeall(nenner);
	if (erg != OK)
		error("dimension_partition: error during computation");
	return erg;
}
#endif /* PARTTRUE */

#ifdef PARTTRUE
INT dimension_augpart(a,b) OP a,b;
/* a ist an object of type AUGPART
   b becomes the dimension of the corresponding irred representation */
/* AK 060789 V1.0 */ /* AK 120390 V1.1 */ /* AK 250291 V1.2 */
/* AK 200891 V1.3 */
{
	OP zaehler;
	OP nenner;
	OP zw;
	
	INT i,j,erg = OK;


	if (not EMPTYP(b))
	if (S_O_K(b) != INTEGER) 
		erg += freeself(b); 
	else 
		C_O_K(b,(OBJECTKIND)0);

	if (S_PA_LI(a) == 1L)
		return M_I_I(1L,b);
	if (S_PA_II(a,S_PA_LI(a)-1L) == S_PA_LI(a)) /* 1^n */
		return M_I_I(1L,b);
	if (S_PA_II(a,S_PA_LI(a)-2L) == S_PA_LI(a)-2L) /* n */
		return M_I_I(1L,b);


	zaehler = callocobject();
	nenner = callocobject();
	zw = callocobject();


	erg += weight_augpart(a,zw);

	erg += fakul(zw,zaehler);

	if (S_O_K(zw) != INTEGER) 
		erg += freeself(zw); 
	else 
		C_O_K(zw,(OBJECTKIND)0);

	M_I_I(1L,nenner);
	for (i=0L;i<S_PA_LI(a);i++)
		for (j=0L;j<S_PA_II(a,i)-i;j++)
		{
			erg += hook_length_augpart(a,i,j,zw);
			if (S_I_I(zw) != 1L)
				erg += mult_apply_integer(zw,nenner);
		};

	erg += freeall(zw); 
	erg += ganzdiv(zaehler,nenner,b); /* statt div AK 170889 */
	erg += freeall(zaehler); 
	erg += freeall(nenner); 
	return erg;
}
#endif /* PARTTRUE */

#ifdef PARTTRUE
INT last_part_EXPONENT(n,part) OP n,part;
/* AK 150888 */ /* AK 060789 V1.0 */ /* AK 281189 V1.1 */
/* AK 200891 V1.3 */
{
	INT i;

	b_ks_pa(EXPONENT,callocobject(),part);
	m_il_v(S_I_I(n),S_PA_S(part));

	M_I_I(S_PA_LI(part), S_PA_I(part,0L));
	/* hier war ein fehler in V1.0 */
	for (i=1L; i<S_PA_LI(part);i++) M_I_I(0L,S_PA_I(part,i));
	return(OK);
}
#endif /* PARTTRUE */

#ifdef PARTTRUE
INT first_part_VECTOR(n,part) OP n,part; 
/* AK 200891 V1.3 */
	{return first_partition(n,part);}
#endif /* PARTTRUE */
#ifdef PARTTRUE
INT last_part_VECTOR(n,part) OP n,part; 
/* AK 200891 V1.3 */
	{return last_partition(n,part);}
#endif /* PARTTRUE */



INT first_part_EXPONENT(n,part) OP n,part;
/* AK 150888 */ /* AK 060789 V1.0 */ /* AK 121190 V1.1 */
/* AK 200891 V1.3 */
{
#ifdef PARTTRUE
	INT i;
	INT erg = OK; /* AK 020692 */

	erg += b_ks_pa(EXPONENT,callocobject(),part);
	erg += m_l_v(n,S_PA_S(part));

	for (i=0L; i<S_PA_LI(part)-1L;i++) 
		M_I_I(0L,S_PA_I(part,i));
	M_I_I(1L, S_PA_I(part,S_PA_LI(part)-1L));
	return erg;
#else /* PARTTRUE */
	return error("first_part_EXPONENT:PARTITION not available");
#endif /* PARTTRUE */
}



INT last_partition(n,part) OP n,part;
/* AK 190587 */
/* die prozedur erzeugt aus der Zahl n die Partition
[1^n], die letzte Partition bezueglich nextpartition
bzgl. Dominanzordnung und auch lexikographisch */
/* n wird nicht verwendet */
/* AK 060789 V1.0 */ /* AK 300590 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef PARTTRUE
	INT i;
	INT erg = OK; /* AK 020692 */
	if (not EMPTYP(part)) 
		erg += freeself(part);
	erg += b_ks_pa(VECTOR,callocobject(),part);
	erg += m_l_v(n,S_PA_S(part));
	for (i=0L;i<S_I_I(n);i++) 
		M_I_I(1L,S_PA_I(part,i));
	return erg;
#else /* PARTTRUE */
	return error("last_partition:PART not available");
#endif /* PARTTRUE */
}

INT first_partition(n,part) OP n,part;
/* AK 190587 */
/* die prozedur erzeugt aus der Zahl n die Partition
[n], die erste Partition bezueglich next_partition
bzgl. Dominanzordnung und auch lexikographisch */
/* ok 190587 */ /* AK 060789 V1.0 */ /* AK 261190 V1.1 */
/* AK 200891 V1.3 */
{
#ifdef PARTTRUE
#ifdef UNDEF
	INT erg = OK; /* AK 041291 */
#endif /* UNDEF */
	if (S_O_K(n) != INTEGER) /* AK 020692 */
		return error("first_partition:wrong type");
	if (S_I_I(n) <= 0L) /* AK 020692 */
		return error("first_partition:input < 1");

#ifdef UNDEF
	if (not EMPTYP(part)) 
		erg += freeself(part);
	erg += b_ks_pa(VECTOR,callocobject(),part);
	erg += m_il_v(1L,S_PA_S(part));
	erg += M_I_I(S_I_I(n),S_PA_I(part,0L));
	if (erg != OK)
		error("first_partition: error during computation");
	return erg;
#endif /* UNDEF */
	return m_i_pa(n,part); /* AK 020692 */
#else /* PARTTRUE */
	return error("first_partition:PART not available");
#endif /* PARTTRUE */
}

INT next_partition(part,next) OP part,next;
/* AK 060789 V1.0 */ /* AK 300590 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef PARTTRUE
	switch(S_PA_K(part))
	{
	case EXPONENT: return(next_part_EXPONENT(part,next));
	case VECTOR: return(next_part_VECTOR(part,next));
	default: 
		{
			debugprint(part);
			return 
			error("next_partition:wrong partition kind");
		}
	};
#else /* PARTTRUE */
	return error("next_partition:PART not available");
#endif /* PARTTRUE */
}

INT next_part_VECTOR(part,next) OP part, next;
/* AK 091086 */ /* Nijenhuis ch. 9 */ 
/* AK 060789 V1.0 */ /* AK 120390 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef PARTTRUE
	OP length;
	INT i,j,m,o;
	INT n,k;
	if (S_PA_II(part,0L) > 1)
	/* bsp: 2345 --> 11345 */
	{
		length = callocobject();
		M_I_I(S_PA_LI(part)+1L, length);
		B_KL_PA(VECTOR,length,next);
		M_I_I(1L,S_PA_I(next,0L));
		M_I_I(S_PA_II(part,0L)-1L,S_PA_I(next,1L));
		for (i=2L;i<S_I_I(length);i++)
			M_I_I(S_PA_II(part,(i-1L)),S_PA_I(next,i));
		return OK;
	};
	for (i=0L;i<S_PA_LI(part);i++)
		if (S_PA_II(part,i) > 1L) break;

	if (i == S_PA_LI(part)) return(LASTPARTITION);


	k = S_PA_LI(part) -i; /* restlaenge */
	m = S_PA_II(part,i);
	n = m - 1L ; /* neuer wert in next */
	j = (i + m)  / n;
	o =(i + m)  % n ;

	if (o == 0L) j--;
	length = callocobject();
	M_I_I(	j+k, length);

	B_KL_PA(VECTOR,length,next);
	if (o != 0L)
	{ 
		M_I_I(o ,S_PA_I(next,0L)); 
		o=1L; 
	};

	for (m=o;m<=j;m++) M_I_I(n, S_PA_I(next,m));

	for (;m<S_I_I(length);m++,i++)
		M_I_I(S_PA_II(part,i+1),S_PA_I(next,m));
	return(OK);
#endif /* PARTTRUE */
}

INT next_part_EXPONENT(part,next) OP part,next;
/* AK 150888 */ /* AK 060789 V1.0 */ /* AK 121190 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef PARTTRUE
	INT l = S_PA_LI(part);
	INT i,index=0L,k;
	INT summe;
	INT value;

	if (S_PA_II(part,0L) == l)
		return(LASTPARTITION);
	/* part = n 0 0 0 0 0 0 ... */

	b_ks_pa(EXPONENT,callocobject(),next);
	m_il_v(l--,S_PA_S(next));
	M_I_I(0L,S_PA_I(next,0L));
	for (i=1L;i<=l;i++)
	{
		k = S_PA_II(part,i);
		M_I_I(k,S_PA_I(next,i));
		if (k>0L) {
			index=i++;
			break;
		};
	}
	memcpy(	S_PA_I(next,i),
		S_PA_I(part,i),
		(l-i+1)*sizeof(struct object) );

	summe = S_PA_II(part,0L);

	/* an der stelle index wird der index um eins decrementiert */
	summe = summe + index + 1L;
	M_I_I(S_PA_II(part,index)-1L, S_PA_I(next,index));
	/* nun nach rechts wieder aufbauen */
	for (i=index-1L;i>=0L;i--)
	{
		value = summe / (i+1L);
		M_I_I(value,S_PA_I(next,i));
		summe = summe % (i+1L);

		if (summe == 0L) break;
		i = summe;
	}
	return(OK);
#endif /* PARTTRUE */
}

INT numberofpart_i(n) OP n;
/* A.K.  gibt die anzahl der partitionen von n ,
wobei n INTEGER Typ */
/* AK 060789 V1.0 */ /* AK 120390 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef PARTTRUE
	OP zw=callocobject();
	INT i;
	numberofpart(n,zw);
	i=S_I_I(zw);
	freeall(zw);	/* speicherplatz des objects zw wieder freigeben */
	return(i);
#else /* PARTTRUE */
	return error("numberofpart_i:PART not available");
#endif /* PARTTRUE */
}

#ifdef PARTTRUE
INT numberofpart(n,x) OP n,x;
/* gibt die anzahl der partitionen von n ,wobei n object */
/* AK 190587 */ /* AK 060789 V1.0 */ /* AK 120390 V1.1 */
/* neu mittels gupta_nm */ /* AK 200891 V1.3 */
{
	OP c,d;
	INT erg = OK; /* AK 041291 */
	if (S_O_K(n) != INTEGER) 
		return error("numberofpart:no INTEGER");

	c = callocobject();
	if (S_I_I(n) < 30L) {
		erg += last_partition(n,c);
		erg += M_I_I(indexofpart(c)+1L,x);
		erg += freeall(c);
		}
	else    {
		d = callocobject();
		erg += M_I_I(1L,d); M_I_I(S_I_I(n)+1L,c);
		erg += gupta_nm(c,d,x);
		free(c); free(d); /* beides INTEGER */
		}
	if (erg != OK) /* AK 041291 */
		error("numberofpart: error during computation");
	return erg;
}
#endif /* PARTTRUE */

#ifdef PARTTRUE
INT indexofpart(part) OP part;
/* gibt die nummer der partition */ /* solange next bis gefunden */
/* AK 190587 */ /* index beginnt mit 0 */
/* AK 060789 V1.0 */ /* AK 260690 V1.1 */ /* AK 200891 V1.3 */
{
	OP b,a;
	INT i,erg;
	if (S_O_K(part) != PARTITION) /* AK 290692 */
		return error("indexofpart:not PARTITION");

	a = callocobject();

	if (S_PA_K(part) != VECTOR)
		{
		if (S_PA_K(part) != EXPONENT) 
			return error("indexofpart:wrong kind of part");
		t_EXPONENT_VECTOR(part,a);
		i = indexofpart(a);
		freeall(a);
		return i;
		}

	weight_partition(part,a);
	b = callocobject();
	first_partition(a,b);
	i=0L;
	while (comp_partition(b,part) != 0L)
		{ 
		  i++; 
		  if (not next(b,b)) 
			{
			debugprint(b);
			error("indexofpart:ERROR");
			}
		};

	freeall(b);
	free(a); /* INTEGER */
	return(i);
}
#endif /* PARTTRUE */

INT ordcen(part,erg) OP part, erg;
/* AK 010888 ordnung der konjugiertenklasse ist der index des zentralisators */
/* AK 060789 V1.0 */ /* AK 071289 V1.1 */ /* AK 150591 V1.2 */ 
/* AK 200891 V1.3 */
{
#ifdef PARTTRUE
	OP zw = callocobject();
	OP h1 = callocobject();
	OP h2 = callocobject();
	ordcon(part,h2); 
	weight_partition(part,zw);
	fakul(zw,h1);
	ganzdiv(h1,h2,erg);  /* ist ganzzahlig */
	freeall(zw); freeall(h2); freeall(h1); 
	return(OK);
#else /* PARTTRUE */
	/* AK 010889 V1.0 */
	return error("ordcen: PARTITION not available");
#endif /* PARTTRUE */
}


#ifdef TABLEAUXTRUE
#ifdef PARTTRUE
INT m_tableaux_polynom(a,c) OP a, c;
/* AK 250789 */ /* AK 200891 V1.3 */
{
	/* a ist poly of tableaux c wird poly of monom */
	/* AK 060588 */
	OP zeiger;

	zeiger = a;
	while( zeiger != NULL)
	{
		OP b = callocobject();
		b_skn_po(callocobject(),callocobject(),NULL,b);
		m_i_i(1L,S_PO_K(b));
		inhalt_tableaux(S_PO_S(zeiger),S_PO_S(b));
		insert(b,c,NULL,NULL); 
		zeiger = S_PO_N(zeiger); 
	};
	return(OK);
}
#endif /* PARTTRUE */
#endif /* TABLEAUXTRUE */


#ifdef TABLEAUXTRUE
#ifdef PARTTRUE
INT m_part_tableaux(part,alph,erg) OP part,alph,erg;
/* AK 070588 */
/* erzeugt aus umriss eine liste der tableaus von diesen umriss 
mit eintraegen 1,2,..,alph */
/* ergebnis ist polynom */
/* AK 200891 V1.3 */
{
	return(m_umriss_tableaux(part,alph,erg));
}
#endif /* TABLEAUXTRUE */
#endif /* PARTTRUE */


#ifdef TABLEAUXTRUE
#ifdef PARTTRUE
INT m_umriss_tableaux(umriss,alph,erg) OP umriss,alph,erg;
/* AK 070588 */
/* erzeugt aus umriss eine liste der tableaus von diesen umriss 
	mit eintraegen 1,2,..,alph */
/* ergebnis ist polynom */
/* AK 200891 V1.3 */
{
	OP a,b,c;
	OP start;
	INT i,j;

	if (S_O_K(umriss) == PARTITION)
		if (S_I_I(alph) < S_PA_LI(umriss)) return(OK);

	a = callocobject();
	b = callocobject();
	copy(umriss,a); 
	m_u_t(a,b);
	/* damit haben wird das tablaux */

	j = zeilenanfang(b,s_t_hi(b)-1);
	start = s_t_ij(b,s_t_hi(b)-1L,j);
	/* start ist die linke untere ecke */


	for (i= 0L; i<= S_I_I(alph); i++)
	{
		M_I_I(i+1L,start); /* initialisieren */
		m060588(b,alph,erg);
	}
	freeall(a);
	freeall(b);
	return OK;
}
#endif /* PARTTRUE */
#endif /* TABLEAUXTRUE */

#ifdef TABLEAUXTRUE
#ifdef PARTTRUE
static INT m060588(tab,alph,erg) OP tab,alph,erg;
/* alph ist maximaler eintrag */
/* AK 200891 V1.3 */
{
	OP b,c;
	INT i,j;
	INT grenze;
	INT lasti,lastj,startj;
	for (i=0L;i< s_t_hi(tab);i++)
	{
		j=zeilenanfang(tab,i);  /* erster erlaubter index */
		if (not emptyp(s_t_ij(tab,i,j))) break;
	};

	lasti = i;
	/* lasti ist zeile in der letzter eintrag */

	grenze = zeilenende(tab,lasti);

	for (	j=zeilenanfang(tab,lasti);  /* erster erlaubter index */
	j<= grenze; 
	    j++)
		if (emptyp(s_t_ij(tab,lasti,j))) break;

	lastj = j;
	/* lastj ist letzter eintrag + 1 */


	if (lastj <=   grenze)  { /* d.h. in der zeile kann noch eingetragen
					werden */
		INT m;
		m = s_t_iji(tab,lasti,lastj-1);
		/* m = der letzte eintrag */

		if (lasti == s_t_hi(tab)-1 )  /* letzte zeile */
			M_I_I(m,s_t_ij(tab,lasti,lastj));
			/* rechts anfuegen der gleichen zahl */
		else if (emptyp(s_t_ij(tab,lasti+1L,lastj)))
			/* bei schief unterhalb leer */
			M_I_I(m,s_t_ij(tab,lasti,lastj));
			/* rechts anfuegen der gleichen zahl */

		else {
			/* schauen ob unterhalb groesserer eintrag */
			m = 
			    (s_t_iji(tab,lasti+1L,lastj) >= m ? 
			    s_t_iji(tab,lasti+1L,lastj)+1 : m);

			if (m > S_I_I(alph)) goto m060588nein;
			/* kann nicht einsetzen */

			M_I_I(m,s_t_ij(tab,lasti,lastj));
		};
		return(m060588(tab,alph,erg));
	};

	/* falls in der zeile nicht mehr eingetragen werden kann */

	i = i-1L; /* neue zeilenzahl */
	j = zeilenanfang(tab,i);
	/* neue spaltenzahl */

	if (i >= 0) {
		if (not emptyp(s_t_ij(tab,i+1L,j)))
		/* unterhalb der neuen
			position ist ein eintrag */
		{
			if (s_t_iji(tab,i+1L,j)+1 > S_I_I(alph))
				goto m060588nein;
			M_I_I(s_t_iji(tab,i+1L,j)+1L,s_t_ij(tab,i,j));
			return(m060588(tab,alph,erg));
		}
		else M_I_I(1L,s_t_ij(tab,i,j));
	};
	/* nun sind wir am ende */
	b = callocobject();
	c = callocobject();
	copy(tab,b);
	m_s_po(b,c);
	insert(c,erg,NULL,NULL);
	/* jetzt muss versucht werden das naechste tableaux 
	zu bekommen */
m060588nein:
	if (m060588b(tab,alph) == TRUE) m060588(tab,alph,erg);
	/* d.h noch nicht letztes tableaux */
	return(OK);
}
#endif /* PARTTRUE */
#endif /* TABLEAUXTRUE */


#ifdef TABLEAUXTRUE
#ifdef PARTTRUE
static INT m060588b(tab,alph) OP tab,alph;
/* es wird versucht das naechste tableaux zu bekommen */
/* AK 200891 V1.3 */
{
	INT i,j;
	INT lastj = zeilenanfang(tab,s_t_hi(tab)-1);
	for (i=0L; i<s_t_hi(tab); i++)
		for (j= s_t_li(tab)-1L;j >= 0L; j--)
			if (not emptyp(s_t_ij(tab,i,j)))
				/* es gibt einen eintrag */
				if (i == s_t_hi(tab)-1  && j == lastj)
					return(FALSE);
					/* wir sind am ende */
				else if (s_t_iji(tab,i,j) < S_I_I(alph))
				{
					inc(s_t_ij(tab,i,j));
					return(TRUE);
				}
				else 
				{
					freeself(s_t_ij(tab,i,j));
					return(m060588b(tab,alph));
				}
	return(FALSE);
}
#endif /* PARTTRUE */
#endif /* TABLEAUXTRUE */


INT t_augpart_part(a,b) OP a,b;
/* AK 150988 */ /* AK 060789 V1.0 */ /* AK 170190 V1.1 */
/* AK 200891 V1.3 */
{
#ifdef PARTTRUE
	INT i,l,s;
	copy(a,b);
	C_O_K(b,PARTITION);
	for (i=0L;i<S_PA_LI(b);i++)
	{ 
		M_I_I(S_PA_II(b,i)-i,s_pa_i(b,i));
		if (S_PA_II(b,i)==0L) s++; 
	}
	if (s != 0L) /* d.h. 0 am anfang */
	{
		OP nv = callocobject();
		m_il_v(S_PA_LI(b)-s,nv);
		for (i=0L; i<S_V_LI(nv); i++)
			M_I_I(S_PA_II(b,i+s),S_V_I(nv,i));
		freeall(S_PA_S(b)); 
		C_PA_S(b,nv);
	}
	return(OK);
#endif /* PARTTRUE */
}

INT comp_partition(a,b) OP a,b;
/* AK 110488*/ /* AK 060789 V1.0 */ /* AK 191289 V1.1 */
/* AK 070891 V1.3 */
{
#ifdef PARTTRUE
	INT i,j;
	INT erg;
	char *ac, *bc;
	if (S_O_K(a) != PARTITION)
		return error("comp_partition:a not PARTITION");
	if (S_O_K(b) != PARTITION)
		return error("comp_partition:b not PARTITION");
		
	if (S_PA_K(a) != S_PA_K(b)) 
		return error("comp_partition:different kind of partitions");

	if (S_PA_K(a) == VECTOR )
		{
/*
		for (	i=0L; i<S_PA_LI(a); i++)
			{
			if (i >=  S_PA_LI(b)) return(1L);
			if (S_PA_II(a,i) > S_PA_II(b,i)) return(1L);
			else if (S_PA_II(a,i) < S_PA_II(b,i)) return( -1L );
			};
		if ( i < S_PA_LI(b) ) return (-1L);

*/ 
		ac = (char *) S_V_S(S_PA_S(a));
		bc = (char *) S_V_S(S_PA_S(b));
		if (S_PA_LI(a) == S_PA_LI(b))
			{
/*
			printf("fall1: ");
			for (j=0;j<S_PA_LI(a)*(sizeof(struct object));j++) printf("%d%d",ac[j],bc[j]);
*/
			erg =  (INT)memcmp(ac,bc,
				( sizeof(struct object) * S_PA_LI(a) ));
			goto cpende;
			}
		if (S_PA_LI(a) < S_PA_LI(b))
			{
/*
			printf("fall2: ");
			for (j=0;j<S_PA_LI(a)*(sizeof(struct object));j++) printf("%d%d",ac[j],bc[j]);
*/
			erg = (INT) memcmp(ac,bc,
				(sizeof(struct object) * S_PA_LI(a) ));
			if (erg == 0L)  erg = -1L;
			goto cpende;
			}
		if (S_PA_LI(a) > S_PA_LI(b))
			{
/*
			printf("fall3: ");
			for (j=0;j<S_PA_LI(b)*(sizeof(struct object));j++) printf("%d%d",ac[j],bc[j]);
*/
			erg = (INT)memcmp(ac,bc,
				(sizeof(struct object) * S_PA_LI(b) ));
			if (erg == 0L)  erg = 1L;
			goto cpende;
			}

		}
	else if (S_PA_K(a) == EXPONENT)
		{
		for (	i=0L; i<S_PA_LI(a); i++)
			{
			if (i >=  S_PA_LI(b) ) 
				{
				if (S_PA_II(a,i) != 0L) 
					{
					erg = 1L;
					goto cpende;
					}
				}
			else if (S_PA_II(a,i) > S_PA_II(b,i)) 
				{
				erg = 1L;
				goto cpende;
				}
			else if (S_PA_II(a,i) < S_PA_II(b,i)) 
				{
				erg = -1L;
				goto cpende;
				}
			}
		
		for (	; i<S_PA_LI(b); i++)
			if (S_PA_II(b,i) != 0L) 
				{
				erg = -1L; 
				goto cpende;
				}
		}
	erg = 0L; goto cpende;
cpende:
/*
	print(a); println(b);
	printf("cpende: %ld\n",erg);
*/
	return erg;
#endif /* PARTTRUE */
}

#ifdef PARTTRUE
part_ende()
	{
	INT i;
	for (i=pa_index; i>=0L;i--)
		free(pa_sp[i]);
	if (pa_sp != NULL)
		free(pa_sp);
	}
#endif /* PARTTRUE */

#ifdef PARTTRUE
INT freeself_partition(a) OP a;
/* AK 110488 */ /* AK 060789 V1.0 */ /* AK 211189 V1.1 */
/* AK 120691 V1.2 */ /* AK 070891 V1.3 */
{
	OBJECTSELF d;

	if (pa_sp == NULL) /* AK 111091 */
		{
		pa_sp = (struct partition **)malloc(
				PASIZE * sizeof(struct partition *));
		if (pa_sp == NULL)
			error("freeself_partition:no mem");
		}

	if (not EMPTYP(S_PA_S(a))) {
		free( S_V_S(S_PA_S(a)));
		freeall( S_V_L(S_PA_S(a)));
		d = S_O_S(S_PA_S(a));
		free(d.ob_vector);
		}
	free(S_PA_S(a)); 
	d = S_O_S(a); 

	if (pa_index+1 < PASIZE) /* AK 111091 */
		pa_sp[++pa_index]=d.ob_partition;
	else
		free(d.ob_partition); 
	C_O_K(a,EMPTY);
	return OK;
}
#endif /* PARTTRUE */

INT copy_partition(a,b) OP a,b;
/* AK 060789 V1.0 */ /* AK 191289 V1.1 */ /* AK 070891 V1.3 */
{
#ifdef PARTTRUE
	INT erg = OK;
	erg += b_ks_pa(S_PA_K(a),callocobject(),b);
	erg += m_il_v(S_PA_LI(a),S_PA_S(b));
	memcpy(
		(char *) S_V_S(S_PA_S(b)),
		(char *) S_V_S(S_PA_S(a)),
		(int)(S_PA_LI(a)*sizeof(struct object)) );

	return erg;
#endif /* PARTTRUE */
}

INT tex_partition(part) OP part;
/* AK 101187 */ 
/* output of a PARTITIONobject in format for TeX */
/* AK 060789 V1.0 */ /* AK 170190 V1.1 */
/* AK 070291 V1.2 texout for output */ /* AK 070891 V1.3 */
{
#ifdef PARTTRUE
	fprintf(texout,"\\ $ "); /* uebergang in math-mode */
	fprint(texout,part);
	texposition = 0L;
	fprintf(texout," $\\ "); /* ende math-mode */
	return(OK);
#endif /* PARTTRUE */
}


static struct partition * callocpartition()
/* AK 060789 V1.0 */ /* AK 170889 malloc statt calloc */ /* AK 170190 V1.1 */
/* AK 070891 V1.3 */
{
#ifdef PARTTRUE
	struct  partition *erg;


	if (pa_index > -1L)
		erg = pa_sp[pa_index--];
	else 

		erg = (struct partition *) malloc(sizeof(struct partition));

	
	if (erg == NULL) 
		error("callocpartition: no memory");

	return(erg);
#endif /* PARTTRUE */
}

INT inversordcen(part,ergeb) OP part, ergeb;
/* AK inverse der ordnung des zentralisator der sn der durch part
bestimmt ist 210387 */
/* AK 060789 V1.0 */
/* AK 131189 langzahl arithmetik */
/* AK 170190 V1.1 */ /* AK 070891 V1.3 */
{
#ifdef PARTTRUE
	INT i;
	INT dt = 0L;
	INT erg = OK; /* AK 090692 */
	OP sp = callocobject();

	if (not EMPTYP(ergeb)) 
		erg += freeself(ergeb);
	M_I_I(1L,ergeb);
	M_I_I(1L,sp);
	for (i=0L; i<S_PA_LI(part);i++)
	{ 
		if (i>0L)
		{ 
			if (S_PA_II(part,i) == S_PA_II(part,(i-1L)))
			{ INC_INTEGER(sp); 
			  erg += mult_apply(sp,ergeb); 
			}
			else M_I_I(1L,sp); 
		};
		erg += mult_apply(S_PA_I(part,i),ergeb);
	};

	if (dt) { printf("inversordcen: ergeb vor invers  "); 
		println(ergeb); };

	erg += invers_apply(ergeb);
	if (dt) { 
		printf("inversordcen: ergeb nach invers "); 
		println(ergeb); 
	};
	erg += freeall(sp);
	return erg;
#endif /* PARTTRUE */
}


INT ordcon(part,ergeb) OP part, ergeb;
/* AK ordnug der konjugiertenklasse der sn die durch part
bestimmt ist 200387  nur bei INTEGER ergebnis */
/* AK 060789 mit beliebigen ergebnis */
/* AK 060789 V1.0 */ /* AK 081289 V1.1 */ /* AK 070891 V1.3 */
{
#ifdef PARTTRUE
	INT i;
	OP ergebnis,sp;
	OP  h1;
	if (S_O_K(part) != PARTITION)
		return error("ordcon:input not PARTITON");
	h1 = callocobject();

	sp=callocobject();
	M_I_I(1L,sp);
	ergebnis=callocobject();
	M_I_I(1L,ergebnis);
	if (not EMPTYP(ergeb)) if (S_O_K(ergeb) != INTEGER) freeself(ergeb);
	for (i=0L; i<S_PA_LI(part);i++)
	{
		if (i>0L)
		{ 
			if (S_PA_II(part,i) == S_PA_II(part,(i-1L)))
			{
				INC_INTEGER(sp);
				mult_apply_integer(sp,ergebnis);
			}
			else M_I_I(1L,sp);
		};
		mult_apply_integer(S_PA_I(part,i),ergebnis);
	};
	weight_partition(part,h1); 
	fakul(h1,sp);
	if (S_O_K(h1) != INTEGER) freeall(h1); else free(h1);
	ganzdiv(sp,ergebnis,ergeb); /* diese division ist ganzzahlig */

	if (S_O_K(sp) != INTEGER) freeall(sp); else free(sp);
	if (S_O_K(ergebnis) != INTEGER) freeall(ergebnis); else free(ergebnis);
	return(OK);
#endif /* PARTTRUE */
}


INT m_v_pa(vec,part) OP vec, part;
/* erzeugt aus einem vector eine partition
durch sortieren und vergessen der nullen. */
/* AK 060789 V1.0 */ /* AK 240490 V1.1 */ /* AK 150591 V1.2 */ 
/* AK 070891 V1.3 */
{
#ifdef PARTTRUE
	INT i=0L,j;
	OP self;

	if (vec == part) /* AK 080891 */
		{
		self = callocobject();
		*self = *vec;
		C_O_K(vec,EMPTY);
		m_v_pa(self,part);
		freeall(self);
		return OK;
		}

	if (not EMPTYP(part)) 
		freeself(part);
	/* vec muss sortiert werden */
	self = callocobject(); 
	copy(vec,self); 
	sort(self);

	if (S_V_II(self,0L) < 0L) { 
		freeall(self);
		return error("m_v_pa: negativ entries"); 
		}

	while (S_V_II(self,i) == 0L)  	/* eintraege = 0 werden ueberlesen */
		if (i++ == (S_V_LI(self) - 1L)) { return freeall(self); }

	M_I_I(S_V_LI(vec) - i,S_V_L(self));
/* die laenge der ergebnis-partition vectorlaenge - anzahl der nullen   */
	for (j=0;j<S_V_LI(self);j++)
		M_I_I(S_V_II(self,i+j),S_V_I(self,j));

	return b_ks_pa(VECTOR,self,part);	/* part ist das ergebnis */
#endif /* PARTTRUE */
}

INT m_i_pa(i,ergebnis) OP i,ergebnis;
/* AK 280890 V1.1 */ /* AK 150591 V1.2 */ /* AK 070891 V1.3 */
	{
#ifdef PARTTRUE
	INT erg = OK;
	OP c = callocobject();
	erg += copy(i,c); 
	erg += b_i_pa(c,ergebnis);
	return erg;
#endif /* PARTTRUE */
	}

INT b_i_pa(integer,ergebnis) OP integer,ergebnis;
/* AK 140687 */ /* Bsp: 5 --> [5] */
/* AK 060789 V1.0 */ /* AK 280890 V1.1 */ /* AK 070891 V1.3 */
{
#ifdef PARTTRUE
	INT erg = OK;
#ifdef UNDEF
	/* ist auch erlaubt z.B. Hall Littlewood */
	if (negp(integer)) 
		return error("b_i_pa: negativ entry");
	if (nullp(integer)) 
		return error("b_i_pa: null entry");
#endif /* UNDEF */
	erg += b_ks_pa(VECTOR,callocobject(),ergebnis);
	erg += b_o_v(integer,S_PA_S(ergebnis));
	return erg;
#endif /* PARTTRUE */
}


INT m_ks_pa(kind,self,ergebnis) OP self,ergebnis; OBJECTKIND kind;
/* make_kind.self_partition */
/* AK 300590 V1.1 */ /* AK 070891 V1.3 */
{
#ifdef PARTTRUE
	OP s = NULL;
	if (self != NULL) { 
		s = callocobject();
		copy(self,s); 
		}
	return b_ks_pa(kind,s,ergebnis);
#else /* PARTTRUE */
	/* AK 300590 V1.1 */
	return error("m_ks_pa: PARTITION not available");
#endif /* PARTTRUE */
}


#ifdef PARTTRUE
INT b_ks_pa(kind,self,c) OP self,c; OBJECTKIND kind;
/* build_kind_self_partition */ /* AK 060789 V1.0 */ /* AK 300590 V1.1 */
/* AK 200891 V1.3 */
{
	OBJECTSELF d;
	
	if (not EMPTYP(c))
		freeself(c);
	d.ob_partition = callocpartition();
	B_KS_O(PARTITION, d, c);
	C_PA_K(c,kind); 
	C_PA_S(c,self); 
	return(OK);
}
#endif /* PARTTRUE */


#ifdef PARTTRUE
INT m_kl_pa(a,b,c) OBJECTKIND a; OP b,c;
/* AK 060789 V1.0 */ /* AK 280890 V1.1 */ /* AK 200891 V1.3 */
{
	return(b_ks_pa(a,callocobject(),c) || m_l_v(b,S_PA_S(c)));
}
#endif /* PARTTRUE */

#ifdef PARTTRUE
INT dec_partition(a) OP a;
/* AK 060789 V1.0 */ /* AK 261190 V1.1 */ /* AK 200891 V1.3 */
{
	INT i;
	if (S_O_K(a) != PARTITION) return ERROR; /* AK 170692 */
	if (S_PA_K(a) == VECTOR) return(dec_vector(S_PA_S(a)));
	if (S_PA_K(a) == EXPONENT)
		for(i=S_PA_LI(a)-1L;i>=0L;i--)
			if (S_PA_II(a,i) > 0L) 
				return m_i_i(S_PA_II(a,i)-1L,S_PA_I(a,i));	
	return ERROR;
}
#endif /* PARTTRUE */

INT lastof_partition(a,b) OP a,b;
/* AK 060789 V1.0 */ /* AK 261190 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef PARTTRUE
	return(lastof_vector(S_PA_S(a),b));
#endif /* PARTTRUE */
}

#ifdef PARTTRUE
INT length_partition(a,b) OP a,b;
/* AK 060789 V1.0 */ /* AK 181289 V1.1 */ /* AK 200891 V1.3 */
{
	
	if (S_O_K(a) != PARTITION) return ERROR; /* AK 170692 */
	if (S_PA_K(a) == VECTOR) return length_vector(S_PA_S(a),b);
	if (S_PA_K(a) == EXPONENT) return sum(S_PA_S(a),b);
	return ERROR;
}
#endif /* PARTTRUE */

#ifdef PARTTRUE
INT weight_partition(a,b) OP a,b;
/* AK 060789 V1.0 */ /* AK 181289 V1.1 */ /* AK 200891 V1.3 */
{
	INT i ,erg=0L;
	if (S_O_K(a) != PARTITION) return ERROR; /* AK 170692 */
	if (S_PA_K(a) == VECTOR) {
		for (i=S_PA_LI(a)-1L;i>=0L;i--) erg += S_PA_II(a,i);
		return(M_I_I(erg,b)); 
		}
	else if (S_PA_K(a) == EXPONENT) {
		for (i=S_PA_LI(a)-1L;i>=0L;i--) erg += (i+1) * S_PA_II(a,i);
		return(M_I_I(erg,b)); 
		}
	else return error("weight_partition: wrong kind of part");
}
#endif /* PARTTRUE */

#ifdef PARTTRUE
INT scan_partition(c) OP c;
/* AK zum einlesen einer partition von der standardeingabe */
/* AK 060789 V1.0 */ /* AK 181289 V1.1 */ /* AK 250291 V1.2 */
/* AK 200891 V1.3 */
{
	INT erg=OK;
spa:
	erg += b_ks_pa(VECTOR,callocobject(),c);
	erg += printeingabe("input of partition as increasing vector");
	erg += scan(INTEGERVECTOR,S_PA_S(c));
	if (partitionp(c) != TRUE) /* AK 170692 */
		{
		erg += printeingabe("you did not enter a partition");
		erg += freeself(c);
		goto spa;
		}
	if (erg != OK)
		error("scan_partition: error in computation");
	return erg;
}
#endif /* PARTTRUE */

#ifdef PARTTRUE
OP s_pa_s(a) OP a;
/* AK 060789 V1.0 */ /* AK 181289 V1.1 */ /* AK 200891 V1.3 */
	{ 
	OBJECTSELF c; 
	c = s_o_s(a); 
	return(c.ob_partition->pa_self); 
	}

OBJECTKIND s_pa_k(a) OP a;
/* AK 060789 V1.0 */ /* AK 181289 V1.1 */ /* AK 200891 V1.3 */
	{ 
	OBJECTSELF c; 
	c = s_o_s(a); 
	return(c.ob_partition->pa_kind); 
	}

OP s_pa_i(a,i) OP a; INT i;
/* AK 060789 V1.0 */ /* AK 181289 V1.1 */ /* AK 200891 V1.3 */
	{ 
	return(s_v_i(s_pa_s(a),i)); 
	}

INT s_pa_ii(a,i) OP a; INT i;
/* AK 060789 V1.0 */ /* AK 181289 V1.1 */ /* AK 200891 V1.3 */
	{ 
	return(s_v_ii(s_pa_s(a),i)); 
	}

OP s_pa_l(a) OP a;
/* AK 060789 V1.0 */ /* AK 181289 V1.1 */ /* AK 200891 V1.3 */
	{ 
	return(s_v_l(s_pa_s(a))); 
	}

INT s_pa_li(a) OP a;
/* AK 060789 V1.0 */ /* AK 181289 V1.1 */ /* AK 200891 V1.3 */
	{ 
	return(s_v_li(s_pa_s(a))); 
	}

INT c_pa_k(a,b) OP a; OBJECTKIND b;
/* AK 060789 V1.0 */ /* AK 181289 V1.1 */ /* AK 200891 V1.3 */
	{ 
	OBJECTSELF c; 
	c = s_o_s(a); 
	c.ob_partition->pa_kind = b; 
	return(OK); 
	}

INT c_pa_s(a,b) OP a,b;
/* AK 060789 V1.0 */ /* AK 181289 V1.1 */ /* AK 200891 V1.3 */
	{ 
	OBJECTSELF c; 
	c = s_o_s(a); 
	c.ob_partition->pa_self = b; 
	return(OK); 
	}
#endif /* PARTTRUE */

#ifdef PARTTRUE
INT neqparts_partition(a) OP a;
/* test whether only different parts in the
partition a AK 071189 */
/* AK 181289 V1.1 */ /* AK 200891 V1.3 */
{
	INT i;
	for (i=S_PA_LI(a)-2L;i >= 0L; i--)
		if (S_PA_II(a,i) == S_PA_II(a,i+1) ) return(FALSE);
	return(TRUE);
}
#endif /* PARTTRUE */


INT objectread_partition(filename,part) OP part; FILE *filename;
/* AK 291086 zum einlesen einer partition von einem file */
/* AK 060789 V1.0 */ /* AK 181289 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef PARTTRUE
	INT kind;
	fscanf(filename,"%ld",&kind);
	b_ks_pa((OBJECTKIND)kind, callocobject(),part);
	objectread(filename,S_PA_S(part));
	return OK;
#endif /* PARTTRUE */
}

INT objectwrite_partition(filename,part) FILE *filename; OP part;
/* AK 291086 */ /* zum schreiben einer partition auf einen file */
/* AK 060789 V1.0 */ /* AK 200690 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef PARTTRUE
	fprintf(filename,"%ld\n",(INT)PARTITION);
	fprintf(filename,"%ld\n",(INT)S_PA_K(part));
	objectwrite(filename,S_PA_S(part));
	return OK;
#endif /* PARTTRUE */
}


#ifdef PARTTRUE
INT t_VECTOR_EXPONENT(von,nach) OP von,nach;
/* A.K. 190588 wandelt eine Partition in der Darstellung
1223 um in die Darstellung
1^1 2^2 3^1 4^0 .. 8^0
d.h in den Vektor 12100000 */
/* AK 060789 V1.0 */ /* AK 200690 V1.1 */ /* AK 200891 V1.3 */
{
	INT i;
	OP l;
	l=callocobject();
	if (von==nach) {
		*l = *von;
		C_O_K(von,EMPTY);
		i = t_VECTOR_EXPONENT(l,nach); /* fehler AK 170692 */
		freeall(l);
		return i;
	}
	if (not EMPTYP(nach)) 
		freeself(nach);
	weight(von,l);
	b_ks_pa(EXPONENT,callocobject(),nach);
	b_l_nv(l,S_PA_S(nach));

/*
	for (i=0L;i<S_I_I(l);i++)
		M_I_I(0L,S_V_I(S_PA_S(nach),i));
*/
	for (i=0L;i<S_PA_LI(von);i++)
		inc(S_V_I(S_PA_S(nach),S_PA_II(von,i) -1L));

	return(OK);
}
#endif /* PARTTRUE */

INT t_EXPONENT_VECTOR(a,b) OP a,b;
/* AK 160988 */ /* AK 060789 V1.0 */ /* AK 200690 V1.1 */ /* AK 200891 V1.3 */
{
#ifdef PARTTRUE
	INT i,j,z=0L;
	OP l;
	l = callocobject();
	if (a==b) {
		copy_partition(a,l);
		t_EXPONENT_VECTOR(l,b);
		freeall(l);
		return(OK);
	}
	/* sum_vector(S_PA_S(a),l); */
	j=0L; for (i=0L;i<S_PA_LI(a);i++) j += S_PA_II(a,i); M_I_I(j,l);
	if (not EMPTYP(b)) freeself(b);
	b_ks_pa(VECTOR,callocobject(),b);
	b_l_v(l,S_PA_S(b));
	for (i=0L;i<S_PA_LI(a);i++)
		for (j=0L;j<S_PA_II(a,i);j++)
		{
			M_I_I(i+1L,S_PA_I(b,z));
			z++;
		};
	return(OK);
#endif /* PARTTRUE */
}

#ifdef PARTTRUE
INT test_part()
/* AK 200690 V1.1 */ /* AK 130691 V1.2 */ /* AK 200891 V1.3 */
{
	OP a = callocobject();
	OP b = callocobject();
	OP c = callocobject();
	printf("test_part:scan(a) "); 
	scan(PARTITION,a);
	printf("test_part:println(a) "); println(a);
	printf("test_part:ordcon(a,b) "); ordcon(a,b); println(b);
	printf("test_part:conjugate(a,b) "); conjugate(a,b); println(b);
	printf("test_part:append(a,b,c) "); append(a,b,c); println(c);
	printf("test_part:add(a,b,c) "); add(a,b,c); println(c);
	printf("test_part:next(c,c) "); next(c,c); println(c);
	printf("test_part:ordcen(c,b) "); ordcen(c,b); println(b);
	printf("test_part:dimension_partition(c,b) "); 
	dimension_partition(c,b); println(b);
	printf("test_part:hook_length(c,0L,0L,b) "); 
	hook_length(c,0L,0L,b); println(b);
	printf("test_part:partitionp(c) "); 
	if (partitionp(c) == TRUE) printf("is partition\n");
	m_i_i(10L,c);
	printf("test_part:makevectorofpart(10L,b) "); 
	makevectorofpart(c,b); println(b);
	printf("test_part:random_partition(10L,b) "); 
	random_partition(c,b); println(b);
	printf("test_part:dec(b) "); dec(b); println(b);
	printf("test_part:length(b,c) "); length(b,c); println(c);
	printf("test_part:weight(b,c) "); weight(b,c); println(c);
	printf("test_part:t_VECTOR_EXPONENT(b,b) "); 
	t_VECTOR_EXPONENT(b,b); println(b);
	printf("test_part:dec(b) "); dec(b); println(b);
	printf("test_part:length(b,c) "); length(b,c); println(c);
	printf("test_part:weight(b,c) "); weight(b,c); println(c);
	printf("test_part:conjugate(b,c) "); conjugate(b,c); println(c);
	printf("test_part:dimension_partition(c,b) "); 
	dimension_partition(c,b); println(b);
	printf("test_part:hook_length(c,0L,0L,b) "); 
	hook_length(c,0L,0L,b); println(b);
	freeall(a); freeall(b); freeall(c); return OK;
}
#endif /* PARTTRUE */

#ifdef PARTTRUE
INT makevectorofpart(n,vec) OP n,vec;
/* AK 200587 */
/* erzeugt einen vector der in der i-ten position die i-te partition von n 
enthaelt ordnung bezueglich nextpartition */
/* AK 060789 V1.0 */ /* AK 081289 V1.1 */ /* AK 130691 V1.2 */
/* AK 200891 V1.3 */
{
	INT i,erg =OK;
	OP l;

	if (S_O_K(n) != INTEGER) /* AK 020692 */
		return error("makevectorofpart:wrong type");
	if (S_I_I(n) <= 0L) /* AK 020692 */
		return error("makevectorofpart:input < 1");

	l=callocobject();

	erg += numberofpart(n,l);
	erg += b_l_v(l,vec);
	erg += first_partition(n,S_V_I(vec,0L));
	for (i=1L;i<S_V_LI(vec);i++)
		erg += next_part_VECTOR(S_V_I(vec,(i-1L)),S_V_I(vec,i));
	if (erg != OK) /* AK 041291 */
		error("makevectorofpart:error during computation");
	return erg;
}
#endif /* PARTTRUE */


#ifdef PARTTRUE
INT weight_augpart(a,b) OP a,b;
/* AK 160988 */ /* AK 060789 V1.0 */ /* AK 120390 V1.1 */ /* AK 130691 V1.2 */
/* AK 200891 V1.3 */
{
	INT i,k=0L;
	if (S_O_K(a) != AUG_PART) return ERROR;
	for (i=S_PA_LI(a)-1L;i>=0L;i--) k = k + S_PA_II(a,i) - i;

	return M_I_I(k,b);
}
#endif /* PARTTRUE */

#ifdef PARTTRUE
INT dom_comp_part(a,b) OP a,b;
/* returns 0 on equal
           1 if a bigger according dominance
           -1     smaller
           else if not comparable */
/* AK 140591 V1.2 */ /* AK 200891 V1.3 */
	{
	INT i,j,s1,s2;
	INT l,erg = 0L;	
	l = (S_PA_LI(a) > S_PA_LI(b)) ?  S_PA_LI(a) : S_PA_LI(b) ;
	/* l is the length of the longer partition */
	for (i=0L; i<l ; i++)
		/* all partial sums */
		{
		s1 = s2 = 0L;
		for (j=0L;j<=i;j++)
			{
			if (j < S_PA_LI(a)) s1 += S_PA_II(a,S_PA_LI(a)-1L-j);
			if (j < S_PA_LI(b)) s2 += S_PA_II(b,S_PA_LI(b)-1L-j);
			}
	/* s1 is partialsum of a 
           s2 is partialsum of b */
		if (erg == 0L) 
			{
			if (s1 > s2) erg = 1L;
			if (s1 < s2) erg = -1L;
			}
		else if ( erg == 1L )
			{
			if (s1 < s2) return 10L; /* not comparable */
			}
		else if ( erg == -1L )
			{
			if (s1 > s2) return 10L; /* not comparable */
			}
		else
			error("dom_comp_part: wrong internal erg");
		}
	return erg;
	}
#endif /* PARTTRUE */

#ifdef PARTTRUE
INT random_partition(a,b) OP a,b;
/* AK 150692 */
{
	INT erg = OK;
	OP v;
	if (S_O_K(a) != INTEGER) 
		return ERROR;
	v = callocobject(); 
	erg += makevectorofpart(a,v);
	erg += copy(S_V_I(v,(INT) (
		((rand()%32767)/32767.0) * S_V_LI(v)
		)),b);
	erg += freeall(v);
	return erg;
}
#endif /* PARTTRUE */
