#include "def.h"
#include "macro.h"

static struct list * calloclist();


INT empty_listp(a) OP a; 
/* true falls es sich um eine leere liste handelt
d.h. self == NULL */
/* AK 130690 V1.1 */
/* AK 060891 V1.3 */
{ 
#ifdef LISTTRUE
	if (not listp(a)) 
		return FALSE;
	if (S_L_S(a) != NULL) 
		return FALSE;
	return TRUE;
#endif /* LISTTRUE */
}

INT fprint_list(f,list) FILE *f; OP list;
/* ausgabe eines list-objects
ausgabe bis einschliesslich next == NULL */
/* AK 210688 */ /* AK 030789 V1.0 */ /* AK 281289 V1.1 */
/* AK 060891 V1.3 */
{
#ifdef LISTTRUE
	OP zeiger = list;
	OBJECTSELF d; /* AK 141091 */
	
	if (list == NULL) /* AK 141091 */
		return error("fprint_list:obj == NULL");
	d = S_O_S(list); /* AK 141091 */
	if (d.ob_list == NULL) /* AK 141091 */
		return error("fprint_list:s_o_s == NULL");

	if 	((S_L_S(list) == NULL)&&(S_L_N(list)==NULL))
	/* AK 030389 */
	/* so wird ein list object initialisiert mit b_sn_l(NULL,NULL,obj) */
		fprintf(f,"empty list");
	else
		while (zeiger != NULL) /* abbruch bedingung */
		{
			fprint(f,S_L_S(zeiger));/*das element wird ausgegeben*/
			fprintf(f,"  ");
			if (f == stdout)  /* cursor position updaten */
			{
				zeilenposition += 2;
				if (zeilenposition >70)
				{ fprintf(stdout,"\n"); zeilenposition = 0L; }
			}
			zeiger=S_L_N(zeiger);/*zeiger auf das naechste element*/
		}
	return(OK);
#endif /* LISTTRUE */
}



INT insert_list(von,nach,eh,cf) OP von,nach; INT (*eh)(), (*cf)();
/* fuegt das object von in die liste nach ein AK 220688 */
/* von ist keine liste */
/* AK 030789 V1.0 */ /* AK 201289 V1.1 */
/* AK 060891 V1.3 */
{
	OP c;
	if (listp(von)) 
		return(insert_list_list_2(von,nach,eh,cf));
	c = callocobject();
	if (S_O_K(nach) == POLYNOM)
		{
		if (scalarp(von)) 
			{
			b_skn_po(callocobject(),von,NULL,c);
			m_il_v(1L,S_PO_S(c));
			m_i_i(0L,S_PO_SI(c,0L));
			}
		else
			{ 
			b_sn_l(von,NULL,c); 
			C_O_K(c,S_O_K(nach)); 
			}
		}
#ifdef SCHURTRUE
	else if (S_O_K(nach) == SCHUR)
		{
		if (scalarp(von)) 
			{ m_scalar_schur(von,c); freeall(von); }
		else
			{ b_sn_l(von,NULL,c); C_O_K(c,S_O_K(nach)); }
		}
#endif /* SCHURTRUE */
#ifdef SCHUBERTTRUE 
	else if (S_O_K(nach) == SCHUBERT)
		{
		if (scalarp(von)) 
			{
			b_skn_sch(callocobject(),von,NULL,c);
			m_ks_p(VECTOR,callocobject(),S_SCH_S(c));
			m_il_v(1L,S_SCH_S(c));
			m_i_i(1L,S_SCH_SI(c,0L));
			}
		else
			{ b_sn_l(von,NULL,c); C_O_K(c,S_O_K(nach)); }
		}
#endif /* SCHUBERTTRUE */
	else   {
		b_sn_l(von,NULL,c); C_O_K(c,S_O_K(nach));
		}
	return insert_list_list_2(c,nach,eh,cf);
}


INT copy_list(von,nach) OP von, nach;
/* AK 290689 V1.0 */ /* AK 281289 V1.1 */
/* AK 060891 V1.3 */
{
#ifdef LISTTRUE
	OBJECTSELF d; /* AK 141091 */
	d= S_O_S(von);
	if (d.ob_list == NULL)
		return error("copy_list:sos = NULL");
	return transformlist(von,nach,copy);
#endif /* LISTTRUE */
}

INT lastp_list(list) OP list;
/* AK 210688 */ /* AK 290689 V1.0 */ /* AK 281289 V1.1 */
/* AK 060891 V1.3 */
{
#ifdef LISTTRUE
	return(S_L_N(list) == NULL);
	/* das letzte element falls das naechste==NULL */
#endif /* LISTTRUE */
}

static struct list * calloclist()
/* AK 210688 */ /* AK 290689 V1.0 */ /* AK 281289 V1.1 */
/* AK 060891 V1.3 */
{
#ifdef LISTTRUE
	struct list *a = 
		(struct list *) malloc(sizeof(struct list));
	if (a == NULL)
		error("kein Speicher in calloclist");

	return(a);
#endif /* LISTTRUE */
}


INT m_sn_l(self,nx,a) OP self,nx,a;
/* AK 290590 V1.1 */ /* AK 050891 V1.3 */
{
#ifdef LISTTRUE
	OP s = NULL,n = NULL;
	if (self != NULL) { s = callocobject(); copy(self,s); }
	if (nx != NULL) { n = callocobject(); copy(nx,n); }
	return  b_sn_l(s,n,a);
#endif /* LISTTRUE */
}


INT b_sn_l(self,nx,a) OP self,nx,a;
/* build_self next_list AK 210688 */
/* AK 290689 V1.0 */ /* AK 281289 V1.1 */  /* AK 050891 V1.3 */
{
#ifdef LISTTRUE
	INT erg =OK;
	OBJECTSELF d;

	d.ob_list = calloclist();
	erg += b_ks_o(LIST,d,a); 
	C_L_S(a,self); 
	C_L_N(a,nx);
	return erg;
#endif /* LISTTRUE */
}


INT length_list(list,erg) OP list,erg;
/* AK 220688 */ /* AK 290689 V1.0 */ /* AK 281289 V1.1 */
/* AK 060891 V1.3 */
{
#ifdef LISTTRUE
	OP zeiger = list;
	M_I_I(0L,erg);
	if (empty_listp(list)) 
		return OK;
	while (zeiger != NULL) /* abbruch bedingung */
	{
		INC_INTEGER(erg); zeiger = S_L_N(zeiger);
	}
	return OK;
#endif /* LISTTRUE */
}



INT transform_apply_list(von,tf) OP von; INT (*tf)();
/* AK 201289 V1.1 */
/* AK 060891 V1.3 */
{
	OP zeiger = von;
	while (zeiger != NULL)
		{ (*tf)(S_L_S(zeiger)); zeiger = S_L_N(zeiger); }
	return(OK);
}

INT transformlist(von,nach,tf) OP von, nach;INT (*tf)();
/* AK 270688 */ /* AK 030789 V1.0 */ /* AK 010890 V1.1 */
/* AK 060891 V1.3 */
{
	OP zeiger = von;
	OP nachzeiger = nach;
	OBJECTSELF d;
	while (zeiger != NULL)
	{
		d= S_O_S(zeiger);
		if (d.ob_list == NULL)
			return error("transformlist:sos = NULL");
		if (S_L_S(zeiger) != NULL)
			{
			b_sn_l(callocobject(),NULL,nachzeiger);
			/* AK 100789 b_sn_l() statt init() */
			C_O_K(nachzeiger,S_O_K(zeiger));
			/* AK 107089 fuer faelle wie polynom etc */
			(*tf)(S_L_S(zeiger),S_L_S(nachzeiger));
			}
		else 
			{
			b_sn_l(NULL,NULL,nachzeiger);
			C_O_K(nachzeiger,S_O_K(zeiger));
			}
		if (not lastp(zeiger)) C_L_N(nachzeiger,callocobject());
	
		zeiger = S_L_N(zeiger);
		nachzeiger = S_L_N(nachzeiger);
	}
	return(OK);
}

INT trans2formlist(ve,vz,nach,tf) OP ve,vz,nach; INT (*tf)();
/* AK 270688 *//* ve ist konstante , vz ist liste */
/* AK 030789 V1.0 */ /* AK 211289 V1.1 */ /* AK 060891 V1.3 */
{
	OP zeiger = vz;
	OP nachzeiger = nach;
	INT erg;
	if (not EMPTYP(nach)) freeself(nach);
	while (zeiger != NULL)
	{
		b_sn_l(callocobject(),NULL,nachzeiger);
		C_O_K(nachzeiger,S_O_K(vz));
		erg = (*tf)(ve,S_L_S(zeiger),S_L_S(nachzeiger));
		if (erg == ERROR) {
			debugprint(ve);
			debugprint(S_L_S(zeiger));
			debugprint(S_L_S(nachzeiger));
			error("trans2formlist: function returns error");
			return ERROR; }
		if (not lastp(zeiger))
		{ 
			C_L_N(nachzeiger,callocobject());
			nachzeiger = S_L_N(nachzeiger); 
		}
		zeiger = S_L_N(zeiger);
	}
	return(OK);
}

INT comp_list(a,b) OP a,b;
/* vergleich zweier listen, z.b. 1,1,3  < 1,2,2 z.b. 2,2,3  > 2/3   AK 140788 */
/* AK 030789 V1.0 */ /* AK 010890 V1.1 */
/* AK 060891 V1.3 */
{
	INT erg=comp(S_L_S(a),S_L_S(b));
	if (erg == 0L) /* gleicher listenanfang */
	{
		if ((S_L_N(a) == NULL)&&(S_L_N(b) == NULL)) return(0L);
		/* gleich */
		else if (S_L_N(a) == NULL) return(-1L);
		/* a < b */
		else if (S_L_N(b) == NULL) return(1L);
		/* a > b */
		else return comp_list(S_L_N(a),S_L_N(b));
		/* rest ist wieder liste */
	}
	else return(erg);
}

#ifdef LISTTRUE
OP s_l_s(a) OP a;
/* AK 010890 V1.1 */ /* AK 060891 V1.3 */
{ 
	OBJECTSELF c; 
	if (a == NULL) 
		return error("s_l_s: a == NULL"),(OP)NULL;
	if (not listp(a)) 
		return error("s_l_s: a not list"),(OP)NULL;
	c = s_o_s(a); 
	return(c.ob_list->l_self); 
}

OP s_l_n(a) OP a;
/* AK 010890 V1.1 */ /* AK 060891 V1.3 */
{ 
	OBJECTSELF c; 
	if (a == NULL) 
		return error("s_l_n: a == NULL"),(OP)NULL;
	if (not listp(a)) 
		return error("s_l_n: a not list"),(OP)NULL;
	c = s_o_s(a); 
	return(c.ob_list->l_next); 
}

INT c_l_n(a,b) OP a,b;
/* AK 010890 V1.1 */
/* AK 060891 V1.3 */
{ OBJECTSELF c; c = s_o_s(a); c.ob_list->l_next = b; return(OK); }

INT c_l_s(a,b) OP a,b;
/* AK 010890 V1.1 */ /* AK 060891 V1.3 */
{ 
	OBJECTSELF c; 
	c = s_o_s(a); 
	c.ob_list->l_self = b; 
	return(OK); 
}

#endif /* LISTTRUE */
INT freeself_list(obj) OP obj;
/* AK 290689 V1.0 */ /* AK 211189 V1.1 */ /* AK 170591 V1.2 */
/* AK 060891 V1.3 */
{
#ifdef LISTTRUE
	OBJECTSELF d; 
	INT erg = OK;
	OP z = obj,za=NULL;


	while (z != NULL)
		{
		d = S_O_S(z);
		if (S_L_S(z) != NULL) 
			erg += freeall(S_L_S(z));
		za = z;
		z = S_L_N(z);
		free(d.ob_list);
		if (za != obj) 
			free(za);
		}
	C_O_K(obj,EMPTY);
/*
	if (S_L_S(obj) != NULL) freeall(S_L_S(obj));
	if (S_L_N(obj) != NULL) freeall(S_L_N(obj));
	d = S_O_S(obj);
	free(d.ob_list);
	C_O_K(obj,EMPTY);
*/
	return erg;
#endif /* LISTTRUE */
}


INT scan_list(a,givenkind) OP a; OBJECTKIND givenkind;
/* genaue art der liste */
/* AK 210688 */ /* AK 030789 V1.0 */ /* AK 010890 V1.1 */
/* AK 060891 V1.3 */
{
	char antwort[2];
	INT erg;


	/* a ist ein leeres object */
	b_sn_l(callocobject(),NULL,a);
	/* self ist nun initialisiert */
	if (givenkind == (OBJECTKIND)0) {
		/*
			a ----> kind: LIST
				       self: --|
					       |
					       V
				       |-------------|
				       | self : OP   |
				       | next : NULL |
				       |-------------|
			*/
		printeingabe("welche art hat das listen-element");
		givenkind = scanobjectkind(); /* nun weiss man das */
	}


	erg=scan(givenkind,S_L_S(a));
	if (erg == ERROR) {
		error("scan_list:error in scaning listelement");
		return(ERROR); 
	}

	printeingabe("one more listelement y/n");
	scanf("%s",antwort);
	if (antwort[0]  == 'y')
	{
		C_L_N(a,callocobject());
		scan_list(S_L_N(a),givenkind);
	};
	return(OK);
}



#ifdef VECTORTRUE
INT t_LIST_VECTOR(a,b) OP a,b;
/* AK 090889 wandelt eine Liste in einen Vektor um */
/* die daten werden dabei kopiert */
/* AK 090889 V1.1 */ /* AK 060891 V1.3 */
{
#ifdef LISTTRUE
	INT i;
	OP l = callocobject();

	if (not listp(a)) 
		return	error("t_LIST_VECTOR: not a LIST object"); 
	

	length(a,l); b_l_v(l,b); 
	/* use build so do not free l at the end */

	for(i=0L;i<S_I_I(l);i++,a=S_L_N(a))
		copy(S_L_S(a),S_V_I(b,i));

	return OK;
#else /* LISTTRUE */
	error("t_LIST_VECTOR: LIST not available");
	return(ERROR);
#endif /* LISTTRUE */
}
#endif /* VECTORTRUE */

#ifdef VECTORTRUE
INT t_VECTOR_LIST(a,b) OP a,b;
/* AK 090889 wandelt einen vector in eine Liste um */
/* die daten werden dabei kopiert */
/* der vector muss sortiert sein */
/* AK 090889 V1.1 */ /* AK 130591 V1.2 */
/* AK 060891 V1.3 */
{
#ifdef LISTTRUE
	INT i;

	if ( S_O_K(a) != VECTOR ) {
		error("VECTOR_LIST: not a VECTOR object");
		return(ERROR);
	}

	for(i=0L;b != NULL;)
	{
		b_sn_l(callocobject(),NULL,b);
		copy(S_V_I(a,i),S_L_S(b));
		if (++i < S_V_LI(a)) C_L_N(b,callocobject());
		b = S_L_N(b);
	}

	return OK;
#else /* LISTTRUE */
	error("t_VECTOR_LIST: LIST not available");
	return(ERROR);
#endif /* LISTTRUE */
}
#endif /* VECTORTRUE */


INT test_list() 
/* AK 010890 V1.1 */ /* AK 060891 V1.3 */
{
	OP a= callocobject();
	OP b= callocobject();
	b_sn_l(NULL,NULL,a);
	println(a);
	freeself(a);
	scan(LIST,a);
	println(a);
	scan(LIST,b);
	println(b);
	insert(a,b,NULL,NULL);
	println(b);
	freeself(b);
	return(OK);
}


INT tex_list(list) OP list;
/* zur ausgabe einer liste */
/* AK 210688 */ /* AK 290689 V1.0 */ /* AK 191289 V1.1 */
/* AK 070291 V1.2 texout instead of stdout for output */
/* AK 060891 V1.3 */
{
#ifdef LISTTRUE
	OP zeiger = list;
	while (zeiger != NULL) /* abbruch bedingung */
	{
		tex(S_L_S(zeiger));
		fprintf(texout,"\\ "); 
		texposition += 3L;
		zeiger = S_L_N(zeiger);
	}
	return(OK);
#endif /* LISTTRUE */
}


INT insert_list_list_2(von,nach,eh,cf) OP von,nach; INT (*eh)(), (*cf)();
/* ersatz fuer insert_list_list programmiert nach
christopher J. van Wyk : Data  structures and c programs */
/* AK 201289 V1.1 */ /* AK 130591 V1.2 */
/* AK 060891 V1.3 */
{
	struct object dummy;
	struct list dummy_list;
	OP p;
	INT erg;
	OBJECTSELF d;
	OBJECTKIND kind=S_O_K(von);
	OP nn,altnext;
	
	if (nach == NULL) {
		return error("insert_list_list:nach == NULL");
		/* darf nicht vorkommen, nach muss initialisiert sein */
	}

	if (EMPTYP(nach)) 
		init(kind,nach);


	if (S_L_S(nach) == NULL)
	{
		C_L_S(nach,S_L_S(von)); 
		C_L_N(nach,S_L_N(von));
		d = S_O_S(von); 
		free(d.ob_list); 
		free(von);
		if (EMPTYP(S_L_S(nach))) 
			freeself(nach);
		return(OK);
	}
	if (S_L_S(von) == NULL)
	{
		freeall(von);
		return(OK);
	}


	if (EMPTYP(S_L_S(nach)))	/* nach ist leer */
	return error("insert_list_list: result is a LIST with empty self");

	nn = callocobject();
	*nn = *nach;
	p = &dummy;

	d.ob_list = &dummy_list;
	C_O_S(p,d);
	C_O_K(p,LIST);

	if (cf == NULL) cf = comp;
	while((von != NULL) && (nn != NULL))
	{
		erg = (* cf)(S_L_S(von),S_L_S(nn));
		if (erg < 0L) { 
			C_L_N(p,von);
			von = S_L_N(von);
			p = S_L_N(p);
		}
		else if (erg >0L){
			C_L_N(p,nn);
			nn = S_L_N(nn);
			p = S_L_N(p);
		}
		else {
			if (eh == NULL);
			else (*eh)(S_L_S(von),S_L_S(nn));
			if (not EMPTYP(S_L_S(nn))) {
				/* eh hat nicht geloescht */
				C_L_N(p,nn);
				p = S_L_N(p);
				nn = S_L_N(nn);
			}
			else {
				freeall(S_L_S(nn));
				altnext=S_L_N(nn);
				d = S_O_S(nn); 
				free(d.ob_list);
				free(nn);
				nn = altnext;
			}

			freeall(S_L_S(von));
			altnext=S_L_N(von);
			d = S_O_S(von); 
			free(d.ob_list);
			free(von);
			von = altnext;
		}
	}

	C_L_N(p,NULL);
	if (von == NULL) 
		von = nn;
	if (von != NULL) 
		C_L_N(p,von);
	if (S_L_N(&dummy) == NULL) 
		{
		C_O_K(nach,EMPTY); 
		init (kind,nach);
		}
	else 	{ 
		*nach = *(S_L_N(&dummy));
		free(S_L_N(&dummy));
		}
	return(OK);
}

INT objectwrite_list(f,a) FILE *f; OP a;
/* AK 210690 V1.1 */ /* AK 100591 V1.2 */
/* AK 060891 V1.3 */
{
#ifdef LISTTRUE 
	fprintf(f,"%ld ", (INT)S_O_K(a));
	if (S_L_S(a) == NULL) /* 100591 */
		fprintf(f,"%ld\n",0L);
	else    {
		fprintf(f,"%ld\n",1L);
		objectwrite(f,S_L_S(a));
		}
	if (S_L_N(a) == NULL) 
		{
		fprintf(f,"%ld\n",0L);
		return OK;
		}
	else    { 
		fprintf(f,"%ld\n",1L); 
		return objectwrite(f,S_L_N(a)); 
		}
#endif /* LISTTRUE */
}

INT objectread_list(f,a) FILE *f; OP a;
/* AK 210690 V1.1 */ /* AK 100591 V1.2 */
/* AK 060891 V1.3 */
{
#ifdef LISTTRUE 
	INT i;
	fscanf(f,"%ld",&i);
	if (i == 0L) 
		b_sn_l(NULL,NULL,a);
	else if (i == 1L)
		{
		b_sn_l(callocobject(),NULL,a);
		objectread(f,S_L_S(a));
		}
	else
		return error("objectread_list: wrong format (1) ");
	fscanf(f,"%ld",&i);
	if (i == 0L) 
		return OK;
	else if (i == 1L) 
		{
		C_L_N(a,callocobject());
		return objectread(f,S_L_N(a)); 
		}
	else
		return error("objectread_list: wrong format (2) ");
#endif /* LISTTRUE */
}
