#include "def.h"
#include "macro.h"


/* es folgen zwei globale variablen */
	INT zeilenposition;
	INT texposition;

INT printobjectkind(a) OP a;
/* AK 270689 V1.0 */ /* AK 020290 V1.1 */
/* AK 130891 V1.3 */
	{
	fprintf(stderr,"kind of object is ");
	if (a == NULL) fprintf(stderr,"NULL\n");
	switch(S_O_K(a))
		{
	case AUG_PART : return(fprintf(stderr,"augpart\n"));
	case BINTREE : return(fprintf(stderr,"bintree\n"));
	case BRUCH : return(fprintf(stderr,"bruch\n"));
	case COMP : return(fprintf(stderr,"composition\n"));
	case CYCLOTOMIC : return(fprintf(stderr,"cyclotomic\n"));
	case GEN_CHAR : return(fprintf(stderr,"general character\n"));
	case GRAL : return(fprintf(stderr,"groupalgebra\n"));
	case HOM_SYM : return(fprintf(stderr,"complete symmetric function\n"));
	case INTEGER : return(fprintf(stderr,"integer\n"));
	case KOSTKA : return(fprintf(stderr,"kostka\n"));
	case KRANZ : return(fprintf(stderr,"kranz\n"));
	case KRANZTYPUS : return(fprintf(stderr,"kranztypus\n"));
	case LIST : return(fprintf(stderr,"list\n"));
	case LONGINT : return(fprintf(stderr,"longint\n"));
	case MATRIX : return(fprintf(stderr,"matrix\n"));
	case MONOM : return(fprintf(stderr,"monom\n"));
	case MONOPOLY : return(fprintf(stderr,"monopoly\n"));
	case PARTITION : return(fprintf(stderr,"partition\n"));
	case PERMUTATION : return(fprintf(stderr,"permutation\n"));
	case POLYNOM : return(fprintf(stderr,"polynom\n"));
	case SCHUR : return(fprintf(stderr,"schur-polynom\n"));
	case SCHUBERT : return(fprintf(stderr,"schubert-polynom\n"));
	case SKEWPARTITION : return(fprintf(stderr,"skewpartition\n"));
	case SQ_RADICAL : return(fprintf(stderr,"square-radical\n"));
	case SYMCHAR : return(fprintf(stderr,"symchar\n"));
	case TABLEAUX : return(fprintf(stderr,"tableaux\n"));
	case VECTOR : return(fprintf(stderr,"vector\n"));
	case 0 : return(fprintf(stderr,"empty-object\n"));
	default : fprintf(stderr," %d ",S_O_K(a));
		return(fprintf(stderr,"unknown\n"));
		};
	}

INT ferrers(obj) OP obj;
/* AK 290986 */ /* AK 010889 V1.0 */ /* AK 020290 V1.1 */
/* AK 130891 V1.3 */
	{
	switch(S_O_K(obj)) {
#ifdef PARTTRUE
		case PARTITION: return ferrers_partition(obj);
#endif /* PARTTRUE */
		default : { 
			printobjectkind(obj);
			return error("ferrer:wrong type"); };
		}
	}


INT printeingabe(text) char *text;
/* AK 270689 V1.0 */ /* AK 020290 V1.1 */
/* AK 070291 V1.2 prints to stderr instead to stdout , returns OK */
/* AK 130891 V1.3 */
	{ 
	fprintf(stderr,"%s\n",text); 
	return OK;
	}

INT fprint(of,obj) FILE	*of; OP obj;
/* AK 211186 */ /* AK 270689 V1.0 */ /* AK 020290 V1.1 */
/* AK 050891 V1.3 */
	{
	INT erg =OK;
	if (obj == NULL) error("fprint:obj == NULL");
	switch(S_O_K(obj))
		{
#ifdef PARTTRUE
		case AUG_PART : 
		case PARTITION :  erg += fprint_partition(of,obj);break;
#endif /* PARTTRUE */
#ifdef BINTREETRUE
		case BINTREE :  erg += fprint_bintree(of,obj);break;
#endif /* BINTREETRUE */
#ifdef BRUCHTRUE
		case BRUCH :  erg += fprint_bruch(of,obj);break;
#endif /* BRUCHTRUE */
#ifdef GENCHARTRUE
		case GEN_CHAR :  erg += fprint_gen_char(of,obj);break;
#endif
#ifdef GRAPHTRUE
		case GRAPH :  erg += fprint_graph(of,obj);break;
#endif
#ifdef INTEGERTRUE
		case INTEGER :  erg += fprint_integer(of,obj);break;
#endif /* INTEGERTRUE */
#ifdef LISTTRUE
		case HOM_SYM :
		case GRAL :
		case MONOPOLY :
		case POLYNOM :
		case SCHUBERT :
#ifdef SCHURTRUE
		case SCHUR :
#endif /* SCHURTRUE */
		case LIST :  erg += fprint_list(of,obj);break;
#endif /* LISTTRUE */
#ifdef LONGINTTRUE
		case LONGINT :  erg += fprint_longint(of,obj);break;
#endif /* LONGINTTRUE */
#ifdef MATRIXTRUE
		case KOSTKA :
		case KRANZTYPUS :
		case MATRIX :  erg += fprint_matrix(of,obj);break;
#endif /* MATRIXTRUE */
#ifdef MONOMTRUE
		case MONOM :  erg += fprint_monom(of,obj);break;
#endif /* MONOMTRUE */
#ifdef PERMTRUE
		case PERMUTATION :  erg += fprint_permutation(of,obj);
				break;
#endif /* PERMTRUE */
#ifdef SKEWPARTTRUE
		case SKEWPARTITION : /*020488 */
			 erg += fprint_skewpartition(of,obj);break;
#endif /* SKEWPARTTRUE */
#ifdef CHARTRUE
		case SYMCHAR : /*110488 */
			 erg += fprint_symchar(of,obj);break;
#endif /* CHARTRUE */
#ifdef TABLEAUXTRUE
		case TABLEAUX : /*020488 */
			 erg += fprint_tableaux(of,obj);break;
#endif /* TABLEAUXTRUE */
#ifdef VECTORTRUE
		case COMP:
		case WORD:
		case KRANZ:
		case VECTOR :    erg += fprint_vector(of,obj);break;
#endif /* VECTORTRUE */
#ifdef	NUMBERTRUE
		case SQ_RADICAL :
		case CYCLOTOMIC :  erg += fprint_number(of,obj);break;
#endif /* NUMBERTRUE */
		case 0 : 	
			fprintf(of,"#");
			/* AK 310889 */
			if (of == stdout) zeilenposition++;
		 	break;
		default:
			{
			printobjectkind(obj);
			error("fprint:wrong object");
			return(ERROR);
			}
		};
	if (erg != OK)
		error("fprint: error during output");
	return erg;
	}

INT display(obj) OP obj;
/* AK 271087 */ /* AK 270689 V1.0 */ /* AK 020290 V1.1 */
/* AK 130891 V1.3 */
	{
	if (obj == NULL) 
		return error("display:obj == NULL");
	switch(S_O_K(obj))
		{
#ifdef SCHUBERTTRUE
		case SCHUBERT : return display_schubert(obj);
#endif
		case 0 : return(printf("#\n"));
		default: printobjectkind(obj);
			return error("display:wrong object");
		};
	}
 
INT fprintln(f,obj) FILE *f; OP obj;
/* AK 270689 V1.0 */ /* AK 020290 V1.1 */
/* AK 130891 V1.3 */
	{
	fprint(f,obj); fprintf(f,"\n"); return(OK);
	}



INT print(obj) OP obj;
/* AK 270689 V1.0 */ /* AK 020290 V1.1 */
/* AK 130891 V1.3 */
	{
	if (zeilenposition > 60L)
		{ printf("\n"); zeilenposition = 0L; };
	fprint(stdout,obj);return(OK);
	}



INT println(obj) OP obj;
/* AK 270689 V1.0 */ /* AK 020290 V1.1 */
/* AK 130891 V1.3 */
	{
	print(obj); printf("\n");
	zeilenposition = 0L;return(OK);
	}




INT scan(kind,obj) OBJECTKIND kind; OP obj;
/* AK 270787 */ /* AK 280689 V1.0 */ /* AK 020290 V1.1 */
/* AK 050891 V1.3 */
	{
	INT erg = OK;
	if (obj == NULL) 
		{ 
		return error("scan:obj == NULL"); 
		}
	if (not EMPTYP(obj)) 
		erg += freeself(obj);
	switch(kind)
		{
#ifdef BRUCHTRUE
		case BRUCH : erg += scan_bruch(obj); break;
#endif /* BRUCHTRUE */
#ifdef CYCLOTRUE
		case CYCLOTOMIC : erg += scan_cyclo(obj); break;
#endif /* CYCLOTRUE */
#ifdef GENCHARTRUE
		case GEN_CHAR : erg += scan_gen_char(obj); break;
#endif /* GENCHARTRUE */
		case GRAL: erg += scan_gral(obj); break;
#ifdef HOMSYMTRUE
		case HOM_SYM : erg += scan_homsym(obj); break;
#endif /* HOMSYMTRUE */
#ifdef INTEGERTRUE
		case INTEGER : erg += scan_integer(obj); break;
#endif /* INTEGERTRUE */
#ifdef VECTORTRUE
		case INTEGERVECTOR : erg += scan_integervector(obj); break;
#endif /* VECTORTRUE */
#ifdef KOSTKATRUE
		case KOSTKA : erg += scan_kostka(obj); break;
#endif /* KOSTKATRUE */
#ifdef KRANZTRUE
		case KRANZ : erg += scan_kranz(obj); break;
#endif /* KRANZTRUE */
#ifdef LISTTRUE
		case LIST : erg += scan_list(obj,(OBJECTKIND)0); break;
#endif /* LISTTRUE */
#ifdef LONGINTTRUE
		case LONGINT : erg += scan_longint(obj); break;
#endif /* LONGINTTRUE */
#ifdef MATRIXTRUE
		case KRANZTYPUS :
			 erg += scan_matrix(obj);
			C_O_K(obj,KRANZTYPUS);
			break;
		case MATRIX : erg += scan_matrix(obj); break;
#endif /* MATRIXTRUE */
#ifdef MONOMTRUE
		case MONOM : erg += scan_monom(obj); break;
#endif /* MONOMTRUE */
#ifdef MONOPOLYTRUE
		case MONOPOLY : erg += scan_monopoly(obj); break;
#endif /* MONOPOLYTRUE */
#ifdef PARTTRUE
		case PARTITION : erg += scan_partition(obj); break;
#endif /* PARTTRUE */
#ifdef PERMTRUE
		case PERMUTATION : erg += scan_permutation(obj); break;
#endif /* PERMTRUE */
#ifdef POLYTRUE
		case POLYNOM : erg += scan_polynom(obj); break;
#endif /* POLYTRUE */
#ifdef SCHUBERTTRUE
		case SCHUBERT : erg += scan_schubert(obj); break;
#endif /* SCHUBERTTRUE */
#ifdef SCHURTRUE
		case SCHUR : erg += scan_schur(obj); break;
#endif /* SCHURTRUE */
#ifdef SKEWPARTTRUE
		case SKEWPARTITION : erg += scan_skewpartition(obj); break;
#endif /* SKEWPARTTRUE */
#ifdef SQRADTRUE
		case SQ_RADICAL : erg += scan_sqrad(obj); break;
#endif /* SQRADTRUE */
#ifdef CHARTRUE
		case SYMCHAR : erg += scan_symchar(obj); break;
#endif /* CHARTRUE */
#ifdef TABLEAUXTRUE
		case TABLEAUX : erg += scan_tableaux(obj); break;
#endif /* TABLEAUXTRUE */
#ifdef VECTORTRUE
		case VECTOR : erg += scan_vector(obj); break;
#endif /* VECTORTRUE */
#ifdef WORDTRUE
		case WORD : erg += scan_word(obj); break;
#endif /* WORDTRUE */
		default:
			{
			fprintf(stderr,"kind = %d\n",kind);
			error("scan:wrong type");
			return(ERROR);
			}
		};
	if (erg != OK)
		error("scan:error during computation");
	return erg;	
	}

OBJECTKIND scanobjectkind()
/* routine zum einlesen des objecttyps 160787 */
/* AK 280689 V1.0 */ /* AK 020290 V1.1 */
/* AK 070291 V1.2 works with stderr instead of stdin */
/* AK 130891 V1.3 */
	{
	INT erg;
	INT i = 0L;
	
	printeingabe("enter kind of object");
	/* hier sind neue objecttypen einzufuegen */
	
#ifdef INTEGERTRUE
	fprintf(stderr,"integer     [1] "); 
	if (i++ == 4L)fprintf(stderr,"\n"),i=0L;
#endif /* INTEGERTRUE */
#ifdef VECTORTRUE
	fprintf(stderr,"vector      [2] "); 
	if (i++ == 4L)fprintf(stderr,"\n"),i=0L;
#endif /* VECTORTRUE */
#ifdef PARTTRUE
	fprintf(stderr,"partition   [3] "); 
	if (i++ == 4L)fprintf(stderr,"\n"),i=0L;
#endif /* PARTTRUE */
#ifdef BRUCHTRUE
	fprintf(stderr,"bruch       [4] "); 
	if (i++ == 4L)fprintf(stderr,"\n"),i=0L;
#endif /* BRUCHTRUE */
#ifdef PERMTRUE
	fprintf(stderr,"permutation [6] "); 
	if (i++ == 4L)fprintf(stderr,"\n"),i=0L;
#endif /* PERMTRUE */
#ifdef SKEWPARTTRUE
	fprintf(stderr,"skewpart    [7] "); 
	if (i++ == 4L)fprintf(stderr,"\n"),i=0L;
#endif /* SKEWPARTTRUE */
#ifdef TABLEAUXTRUE
	fprintf(stderr,"tableaux    [8] "); 
	if (i++ == 4L)fprintf(stderr,"\n"),i=0L;
#endif /* TABLEAUXTRUE */
#ifdef POLYTRUE
	fprintf(stderr,"polynom     [9] "); 
	if (i++ == 4L)fprintf(stderr,"\n"),i=0L;
#endif /* POLYTRUE */
#ifdef SCHURTRUE
	fprintf(stderr,"schurfunk  [10] "); 
	if (i++ == 4L)fprintf(stderr,"\n"),i=0L;
#endif /* SCHURTRUE */
#ifdef MATRIXTRUE
	fprintf(stderr,"matrix     [11] "); 
	if (i++ == 4L)fprintf(stderr,"\n"),i=0L;
#endif /* MATRIXTRUE */
#ifdef SCHUBERTTRUE
	fprintf(stderr,"schubert   [14] "); 
	if (i++ == 4L)fprintf(stderr,"\n"),i=0L;
#endif /* SCHUBERTTRUE */
#ifdef KOSTKATRUE
	fprintf(stderr,"kostka     [16] "); 
	if (i++ == 4L)fprintf(stderr,"\n"),i=0L;
#endif /* KOSTKATRUE */
#ifdef CHARTRUE
	fprintf(stderr,"symchar    [18] "); 
	if (i++ == 4L)fprintf(stderr,"\n"),i=0L;
#endif /* CHARTRUE */
#ifdef WORDTRUE
	fprintf(stderr,"word       [19] "); 
	if (i++ == 4L)fprintf(stderr,"\n"),i=0L;
#endif /* WORDTRUE */
#ifdef LISTTRUE
	fprintf(stderr,"list       [20] "); 
	if (i++ == 4L)fprintf(stderr,"\n"),i=0L;
#endif /* LISTTRUE */
#ifdef LONGINTTRUE
	fprintf(stderr,"longint    [22] "); 
	if (i++ == 4L)fprintf(stderr,"\n"),i=0L;
#endif /* LONGINTTRUE */
#ifdef CYCLOTRUE
	fprintf(stderr,"cyclotomic[124] "); 
	if (i++ == 4L)fprintf(stderr,"\n"),i=0L;
#endif /* CYCLOTRUE */
#ifdef SQRADTRUE
	fprintf(stderr,"radical   [125] "); 
	if (i++ == 4L)fprintf(stderr,"\n"),i=0L;
#endif /* SQRADTRUE */
#ifdef MONOPOLYTRUE
	fprintf(stderr,"monopoly  [126] "); 
	if (i++ == 4L)fprintf(stderr,"\n"),i=0L;
#endif /* MONOPOLYTRUE */

	fprintf(stderr,"\nwhat kind:? ");
	scanf("%ld",&erg);
	return (OBJECTKIND)erg;
	}

INT objectread(f,obj) FILE *f; OP obj;
/* AK 131086 */ /* AK 280689 V1.0 */ /* AK 160190 V1.1 */ /* AK 020591 V1.2 */
/* AK 090891 V1.3 */
	{
	OBJECTKIND kind;
	INT c,erg=OK;
	if (not EMPTYP(obj)) 
		erg += freeself(obj);
	fscanf(f,"%ld",&c);
	kind = (OBJECTKIND)c;
	switch(kind)
		{
		case 0:	break;
#ifdef BRUCHTRUE
		case BRUCH : erg += objectread_bruch(f,obj);break;
#endif /* BRUCHTRUE */
#ifdef INTEGERTRUE
		case INTEGER : erg += objectread_integer(f,obj);break;
#endif /* INTEGERTRUE */
#ifdef LISTTRUE
		case GRAL:
		case HOM_SYM:
#ifdef SCHURTRUE
		case SCHUR:
#endif /* SCHURTRUE */
		case MONOPOLY:
		case POLYNOM:
		case SCHUBERT:
		case LIST : erg += objectread_list(f,obj);
			    C_O_K(obj,kind);
			    break;
#endif /* LISTTRUE */
#ifdef LONGINTTRUE
		case LONGINT : erg += objectread_longint(f,obj);break;
#endif /* LONGINTTRUE */
#ifdef MATRIXTRUE
		case MATRIX : erg += objectread_matrix(f,obj);break;
#endif /* MATRIXTRUE */
#ifdef MONOMTRUE
		case MONOM : erg += objectread_monom(f,obj);break;
#endif /* MONOMTRUE */
#ifdef	NUMBERTRUE
		case SQ_RADICAL : erg += OBJECTREAD_SQRAD(f,obj);break;
		case CYCLOTOMIC : erg += OBJECTREAD_CYCLO(f,obj);break;
#endif /* NUMBERTRUE */
#ifdef PARTTRUE
		case PARTITION : erg += objectread_partition(f,obj);break;
#endif /* PARTTRUE */
#ifdef PERMTRUE
		case PERMUTATION : erg += objectread_permutation(f,obj);break;
#endif /* PERMTRUE */
#ifdef CHARTRUE
		case SYMCHAR : erg += objectread_symchar(f,obj);break;
#endif /* CHARTRUE */
#ifdef SKEWPARTTRUE
		case SKEWPARTITION : erg += objectread_skewpartition(f,obj);
					break;
#endif /* SKEWPARTTRUE */
#ifdef TABLEAUXTRUE
		case TABLEAUX: erg += objectread_tableaux(f,obj); break;
#endif /* TABLEAUXTRUE */
#ifdef VECTORTRUE
		case VECTOR : erg += objectread_vector(f,obj); break;
#endif /* VECTORTRUE */
		default: { 
			printobjectkind(obj);
			return error("objectread:wrong type"); 
			}
		};
	if (erg != OK)
		{
		error("objectread: error during computation");
		return erg;
		}
	return OK;
	}

INT objectwrite(f,obj) FILE *f; OP obj;
/* AK 131086 */ /* AK 280689 V1.0 */ /* AK 160190 V1.1 */
/* AK 090891 V1.3 */
	{
	INT erg = OK;
	switch(S_O_K(obj))
		{
		case 0: fprintf(f," %ld ",0L); return(OK);
#ifdef BRUCHTRUE
		case BRUCH : erg += objectwrite_bruch(f,obj);break;
#endif /* BRUCHTRUE */
#ifdef INTEGERTRUE
		case INTEGER : erg += objectwrite_integer(f,obj);break;
#endif /* INTEGERTRUE */
#ifdef LISTTRUE
		case GRAL:
		case HOM_SYM:
#ifdef SCHURTRUE 
		case SCHUR:
#endif /* SCHURTRUE */
		case MONOPOLY:
		case POLYNOM:
		case SCHUBERT:
		case LIST : erg += objectwrite_list(f,obj);break;
#endif /* LISTTRUE */
#ifdef LONGINTTRUE
		case LONGINT : erg += objectwrite_longint(f,obj);break;
#endif /* LONGINTTRUE */
#ifdef MATRIXTRUE
		case KRANZTYPUS: /* AK 220492 */
		case MATRIX :  erg += objectwrite_matrix(f,obj);break;
#endif /* MATRIXTRUE */
#ifdef MONOMTRUE
		case MONOM : erg += objectwrite_monom(f,obj);break;
#endif /* MONOMTRUE */
#ifdef	NUMBERTRUE
		case SQ_RADICAL :
		case CYCLOTOMIC : erg += objectwrite_number(f,obj);break;
#endif /* NUMBERTRUE */
#ifdef PARTTRUE
		case PARTITION : erg += objectwrite_partition(f,obj);break;
#endif /* PARTTRUE */
#ifdef PERMTRUE
		case PERMUTATION:erg += objectwrite_permutation(f,obj);break;
#endif /* PERMTRUE */
#ifdef CHARTRUE
		case SYMCHAR:erg += objectwrite_symchar(f,obj);break;
#endif /* CHARTRUE */
#ifdef SKEWPARTTRUE
		case SKEWPARTITION : erg += objectwrite_skewpartition(f,obj);
				break;
#endif /* SKEWPARTTRUE */
#ifdef TABLEAUXTRUE
		case TABLEAUX: erg += objectwrite_tableaux(f,obj);break;
#endif /* TABLEAUXTRUE */
#ifdef VECTORTRUE
		case VECTOR : erg += objectwrite_vector(f,obj);break;
#endif
		default:
			{
			printobjectkind(obj);
			return error("objectwrite:wrong type");
			}
		};
	if (erg != OK)
		{
		error("objectwrite: error during computation");
		return erg;
		}
	return OK;
	}


INT tex(obj) OP obj;
/* tex-output of the object obj */
/* AK 101187 */ /* AK 060789 V1.0 */ /* AK 020290 V1.1 */
/* AK 300791 V1.3 */	
	{
	INT erg = OK;
	/* es folgen zwei sonderfaelle */
	if (obj == NULL) 
		return error("tex:obj == NULL");

	if (EMPTYP(obj)) return(OK);
		/* d.h. ein leeres object erzeugt keine ausgabe A.K. 101187 */

	switch(S_O_K(obj))
		{
#ifdef BRUCHTRUE
		case BRUCH: erg +=  tex_bruch(obj);break;
#endif /* BRUCHTRUE */
#ifdef CYCLOTRUE
		case CYCLOTOMIC : erg += tex_cyclo(obj); break;
#endif /* CYCLOTRUE */
#ifdef INTEGERTRUE
		case INTEGER: erg +=  tex_integer(obj);break;
#endif /* INTEGERTRUE */
#ifdef LONGINTTRUE
		case LONGINT: erg +=  tex_longint(obj); break;
#endif /* LONGINTTRUE */
#ifdef MONOPOLYTRUE
		case MONOPOLY: erg +=  tex_monopoly(obj); break;
#endif /* MONOPOLYTRUE */
#ifdef SCHUBERTTRUE
		case SCHUBERT: erg +=  tex_schubert(obj); break;
#endif /* SCHUBERTTRUE */
#ifdef SCHURTRUE
		case SCHUR:erg +=  tex_schur(obj); break;
#endif /* SCHURTRUE */
#ifdef CHARTRUE
		case SYMCHAR: erg += tex_symchar(obj); break;
#endif /* CHARTRUE */
#ifdef LISTTRUE
		case LIST: erg += tex_list(obj);break;
#endif /* LISTTRUE */
#ifdef MATRIXTRUE
		case KOSTKA :
		case MATRIX : erg += tex_matrix(obj);break;
			
#endif /* MATRIXTRUE */
#ifdef MONOMTRUE
		case MONOM: erg += tex_monom(obj);break;
#endif /* MONOMTRUE */
#ifdef PARTTRUE
		case PARTITION : erg+= tex_partition(obj);break;
#endif /* PARTTRUE */
#ifdef PERMTRUE
		case PERMUTATION : erg+= tex_permutation(obj);break;
#endif /* PERMTRUE */
#ifdef POLYTRUE
		case POLYNOM: erg+= tex_polynom(obj);break;
#endif /* POLYTRUE */
#ifdef TABLEAUXTRUE
		case TABLEAUX : erg+= tex_tableaux(obj);break;
#endif /* TABLEAUXTRUE */
#ifdef SQRADTRUE
		case SQ_RADICAL : erg += tex_sqrad(obj);break;
#endif /* SQRADTRUE */
#ifdef VECTORTRUE
		case VECTOR : erg += tex_vector(obj);break;
#endif /* VECTORTRUE */
		default:
			{
			/* der fehlerfall */
			printobjectkind(obj); 
			return error("tex:wrong type");
			}
		};
	if (erg != OK)
		{
		error("tex: error during computation");
		}
	return erg;
	}


#ifdef MATRIXTRUE 
#ifdef POLYTRUE
latex_glm_dar(M) OP	M;
/* AK 280192 output to texout */
{
	INT	i;
	INT	j;
	INT	k;
	INT	var = 1L;

	OP 	moddy	=	callocobject();	
	OP 	rest	=	callocobject();	
	OP	vier	=	callocobject();

	if(S_M_LI(M) >= 10) var = 1L;
	M_I_I(var,vier);
	ganzdiv(S_M_L(M),vier,moddy);
	mult(moddy,vier,vier);
	sub(S_M_L(M),vier,rest);

	if(S_I_I(moddy) != 0L)
	{
	fprintf(texout,"$$\n");
	fprintf(texout,"\\left[\n");
	for(i=0L;i<S_I_I(moddy);++i)
	{
			if(i != 0L)	
			{
				fprintf(texout,"$$\n");
				fprintf(texout,"\\left\.\n");
			}
			fprintf(texout,"\\begin{array}{l");
			for(j=1L;j<var;++j) fprintf(texout,"|l");
			fprintf(texout,"}\n");
			for(j=0L;j<S_M_HI(M);++j)
			{
				for(k=0L;k<var;++k)
				{
					write_polynom(S_M_IJ(M,j,var*i+k));
					if(k != var-1L) fprintf(texout," \& ");
				    else 
							if(j != S_M_HI(M)-1L) 
								fprintf(texout,"\\\\\\hline\n");
							else	
								fprintf(texout,"\\\\\n");
				}
			}
			fprintf(texout,"\\end{array}\n");
			if(i < S_I_I(moddy)-1L)
			{
			fprintf(texout,"\\right\.\n");
			fprintf(texout,"$$\n");
			}
			else
			if(i < S_I_I(moddy))
			{
				if(S_I_I(rest) != 0L)
				{
					fprintf(texout,"\\right\.\n");
					fprintf(texout,"$$\n");
				}
				else
				{
					fprintf(texout,"\\right]\n");
					fprintf(texout,"$$\n");
				}
			}
	}
	}
	if(S_I_I(rest) != 0L)
	{
	fprintf(texout,"\n\\bigskip\n");
	fprintf(texout,"$$\n");
	if(S_I_I(moddy) != 0)
		fprintf(texout,"\\left\.\n");
	else
		fprintf(texout,"\\left[\n");
	fprintf(texout,"\\begin{array}{l");
	for(j=1L;j<S_I_I(rest)-1L;++j)
		fprintf(texout,"|l");
	fprintf(texout,"|l}\n");
	for(j=0L;j<S_M_HI(M);++j)
	{
		for(k=0L;k<S_I_I(rest);++k)
		{
			write_polynom(S_M_IJ(M,j,var*S_I_I(moddy)+k));
			if(k != S_I_I(rest)-1L) fprintf(texout," \& ");
			else 
				if(j != S_M_HI(M)-1L) fprintf(texout,"\\\\\\hline\n");
				else	fprintf(texout,"\\\\\n");
		}
	}
	fprintf(texout,"\\end{array}\n");
	fprintf(texout,"\\right]\n");
	fprintf(texout,"$$\n");
	}

	freeall(moddy);
	freeall(rest);
	freeall(vier);
}
#endif /* POLYTRUE */
#endif /* MATRIXTRUE */

#ifdef POLYTRUE
write_polynom(poly) OP	poly;
/* AK 280192 output to texout */
{
	INT	i;
	INT	j;
	INT	k;
	INT	l;

	OP	z = poly;
	while(z != NULL)
	{
		if(!nullp(s_po_k(z)) && !emptyp(s_po_k(z)))	
		{
			ausgabe_koeff(s_po_k(z));
			for(k=0L;k<S_M_HI(s_po_s(z));++k)
			{
				for(l=0L;l<S_M_LI(s_po_s(z));++l)
					if(S_M_IJI(s_po_s(z),k,l) > 0L)

						if(S_M_IJI(s_po_s(z),k,l) == 1L)
							fprintf(texout,"x_{%d %d} ",k+1L,l+1L);
						else
							fprintf(texout,"x_{%d %d}^{%d} ",k+1L,l+1L,S_M_IJI(s_po_s(z),k,l));
			}
			if(S_PO_N(z) != NULL)	
			{
				fprintf(texout,"+");
			}
		}
		z = S_PO_N(z);
	}
	
}
#endif /* POLYTRUE */

ausgabe_koeff(k) OP	k;
/* AK 280192 output to texout */
{
			switch(S_O_K(k))
			{ 
				case INTEGER: 
				{
					if(S_I_I(k) == 1L)
						break;

					if(S_I_I(k) == -1L)
					{
						fprintf(texout,"-");
						break;
					}
					print(k);
					break;
				}
#ifdef BRUCHTRUE
				case BRUCH: 
				{
					kuerzen(k);
					fprintf(texout,"\\frac{");
					ausgabe_koeff(S_B_O(k));
					fprintf(texout,"}{");
					ausgabe_koeff(S_B_U(k));
					fprintf(texout,"}");
					break;
				}
#endif /* BRUCHTRUE */
#ifdef NUMBERTRUE
				case SQ_RADICAL: 
				{
					OP	ptr = S_N_S(k);
					while(ptr != NULL)
					{
					fprintf(texout,"\\sqrt{");
					ausgabe_koeff(S_PO_S(ptr));
					fprintf(texout,"}");
					ptr = S_L_N(ptr);
					}
					break;
				}
#endif /* NUMBERTRUE */
				default :
				{
				printobjectkind(k);
				error("unknown type of coefficient !!!\n");
				break;
				}
			}
}
