module mrank;  % Procedure for determining the rank of a matrix.

% Author: J.M. de Olazabal (University of Cantabria, SPAIN ---
%                           olazabal@ccucvx.unican.es).

% Usage: mrank <matrix>.

symbolic operator mrank;

symbolic procedure mrank(l);
   <<l := cdr l;
     l := for each x in l collect for each y in x collect simp!* y;
     ranko l>>;

symbolic procedure ranko(l);
   if null car l then 0
    else begin scalar pivot,lista;
            while l and caar l = simp!* 0 do
               <<lista:=cons(cdar l,lista);l:=cdr l>>;
            if null l then return ranko lista;
            pivot:=caar l;
            for each x in cdr l do
               lista:=
                  if car x = simp!* 0 then cdr x . lista
                   else suma(multi(cdr x,pivot),
                             multi(cdar l,negsq car x))
                         . lista;
            return 1+(ranko lista)
         end;

% Auxiliary functions.

symbolic procedure multi(l,a); for each x in l collect multsq(a,x);

symbolic procedure suma(l1,l2);
   if null l1 then nil else addsq(car l1,car l2) . suma(cdr l1,cdr l2);

endmodule;

end;
