;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;        Copyright (C) 1986 by Douglas A. Young,
;;;        Kent State University, Kent Ohio
;;;        Unrestricted permission is granted to copy, modify
;;;        or redistribute this file.
;;;        Douglas A. Young phone: (415) 857-6478
;;;                         net  : dayoung@hplabs.hp.com
;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; The template for a help facility
;;;
(eval-when (compile) 
      (require '//user//vaxima//young//devdep//gelib))
(defun print_help_menu nil
   (prog (choice)
      loop
      (setq choice (menu-choose **help-menu** ))
      (cond((equal choice 'exit)(return))
		   ((null choice)(return))
		   (t(eval choice)))
      (go loop)
      )
   )
      

(defun  describe-edit-functions nil
   (setf rect (make-rect x 100. y 100. w 500. h 300.))
   (make-window :name 'Editing-Functions
		:rectangle rect)
   (paint-string 102. 120. " The following edit functions are available:")
   (paint-string 102. 135. " Delete-current-character  CNTRL-D ")
   (paint-string 102. 150. " Delete-previous-character CNTRL-H ")
   (paint-string 102. 165. " Beginning of line         CNTRL-A ")
   (paint-string 102. 180. " End-of-Line               CNTRL-E ")
   (paint-string 102. 195. " Insert-mode (default)     CNTRL-I ")
   (paint-string 102. 210. " Replacement-mode          CNTRL-R ")
   (paint-string 102. 225. " Previous Command          F1 ")
   (paint-string 102. 240. " Next Command              F2 ")         
   (paint-string 102. 260. " Click Mouse to Continue ")
   (wait-mouse-click m_any)
   (delete-window 'Editing-Functions :verify nil))

   (defun  describe-window-functions nil
	   (make-window :name 'Window-functions
			:rectangle (make-rect x 100. y 100. w 500. h 300.))
   (paint-string 102. 120. " The window may be deleted and removed. ")
   (paint-string 102. 140. " A window may be brought to the top")
   (paint-string 102. 155. " by clicking on it with the mouse. ")
   (paint-string 102. 175. " A window may be moved, while retaining ")
   (paint-string 102. 190. " the same size.")
   (paint-string 102. 210. " A window may have its size changed. ")
   (paint-string 102. 230. " A window may be shrunk to an icon")
   (paint-string 102. 250. " A shrunken window may be restored to full")
   (paint-string 102. 265. " by clicking onit with the mouse ")         	   
	   (paint-string 102. 285. " Click Mouse to Continue ")
	   (wait-mouse-click m_any)
	   (delete-window 'Window-functions :verify nil ))

   (defun  describe-selection-functions nil
	   (make-window :name 'Selection-functions
			:rectangle (make-rect x 100. y 100. w 500. h 300.))
	   (paint-string 102. 200. " Click Mouse to Continue ")
	   (wait-mouse-click m_any)
	   (delete-window 'Selection-functions :verify nil ))

   (defun  describe-plot-functions nil
	   (make-window :name 'Plot-functions
			:rectangle (make-rect x 100. y 100. w 500. h 300.))
	   (paint-string 102. 200. " Click Mouse to Continue ")
	   (wait-mouse-click m_any)
	   (delete-window 'Plot-functions :verify nil ))
