C      ________________________________________________________
C     |                                                        |
C     |       MULTIPLY A TRIDIAGONAL MATRIX BY A VECTOR        |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         X     --VECTOR                                 |
C     |                                                        |
C     |         L     --SUBDIAGONAL (CAN BE IDENTIFIED WITH U  |
C     |                 IF THE COEFFICIENT MATRIX IS SYMMETRIC)|
C     |                                                        |
C     |         D     --DIAGONAL                               |
C     |                                                        |
C     |         U     --SUPERDIAGONAL                          |
C     |                                                        |
C     |         N     --MATRIX DIMENSION                       |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         Y     --PRODUCT BETWEEN A AND X                |
C     |________________________________________________________|
C
      SUBROUTINE TMULT(Y,X,L,D,U,N)
      REAL D(1),L(1),U(1),X(1),Y(1)
      INTEGER I,J,M,N
      IF ( N .GT. 1 ) GOTO 10
      Y(1) = D(1)*X(1)
      RETURN
10    Y(1) = D(1)*X(1) + U(1)*X(2)
      M = N - 1
      J = 1
      IF ( M .EQ. 1 ) GOTO 30
      DO 20 I = 2,M
           Y(I) = L(J)*X(J) + D(I)*X(I) + U(I)*X(I+1)
20         J = I
30    Y(N) = L(J)*X(J) + D(N)*X(N)
      RETURN
      END
