C
C      ________________________________________________________
C     |                                                        |
C     |COMPUTE THE SIMILARITY TRANSFORMATION USED IN REDUCTION |
C     |                   TO TRIDIAGONAL FORM                  |
C     |ORIGINAL A = P TIMES TRIDIAGONAL MATRIX TIMES P INVERSE |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         A     --OUTPUT FROM SHESS                      |
C     |                                                        |
C     |         LP    --LEADING (ROW) DIMENSION OF ARRAY P     |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         P     --SIMILARITY TRANSFORMATION              |
C     |                                                        |
C     |    PACKAGE SUBROUTINES: HSR2                           |
C     |________________________________________________________|
C
      SUBROUTINE SSIM(P,LP,A)
      INTEGER I,J,K,L,LP,M,N,O
      REAL A(1),P(LP,1),T
      T = A(1)
      IF ( T .EQ. 2234 ) GOTO 10
      WRITE(6,*) 'ERROR: MUST REDUCE MATRIX TO TRIDIAGONAL FORM USING'
      WRITE(6,*) 'SUBROUTINE SHESS BEFORE USING SUBROUTINE SSIM TO'
      WRITE(6,*) 'COMPUTE THE SIMILARITY TRANSFORMATION'
      STOP
10    N = A(2)
      IF ( N .LT. 2 ) GOTO 60
      IF ( N .EQ. 2 ) GOTO 40
      K = 1
      L = N - 2
      O = (L*N-L)/2
      DO 30 M = 1,L
           J = N - M
           DO 20 I = J,N
20              P(I,J) = A(I+O)
           K = K + 1
30         O = O - K
40    DO 50 I = 1,N
50         P(I,1) = 0.
60    CALL HSR2(P,LP,N)
      RETURN
      END
