C
C      ________________________________________________________
C     |                                                        |
C     | SOLVE A GENERAL OVERDETERMINED LINEAR SYSTEM OF M EQS. |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         A     --QR'S OUTPUT                            |
C     |                                                        |
C     |         B     --RIGHT SIDE                             |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         X     --SOLUTION (AT LEAST M ELEMENTS, CAN BE  |
C     |                 IDENTIFIED WITH B BUT RIGHT SIDE       |
C     |                 DESTROYED)                             |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS                              |
C     |________________________________________________________|
C
      SUBROUTINE OVER(X,A,B)
      REAL  A(1),B(1),X(1),T
      INTEGER H,I,J,K,L,M,N,O
      T = A(1)
      IF ( ABS(T) .EQ. 3230 ) GOTO 10
      WRITE(6,*) 'ERROR: MUST QR FACTOR COEFFICIENT MATRIX'
      WRITE(6,*) 'BEFORE SOLVING SYSTEM'
      STOP
10    IF ( T .GT. 0. ) GOTO 20
      WRITE(6,*) 'SINGULAR SYSTEM - COMPUTE REGULARIZED SOLUTION'
      WRITE(6,*) '(SEE SECTION 6-11)'
      STOP
20    M = A(2)
      N = A(3)
      IF ( M .GE. N ) GOTO 30
      WRITE(6,*) 'ERROR: THE NUMBER OF EQUATIONS IS LESS THAN'
      WRITE(6,*) 'THE NUMBER OF UNKNOWNS. FOR AN OVERDETERMINED'
      WRITE(6,*) 'SYSTEM, THERE MUST BE MORE EQUATIONS THAN UNKNOWNS'
      STOP
30    IF ( M .GT. 1 ) GOTO 40
      X(1) = B(1)/A(4)
      RETURN
40    DO 50 I = 1,M
50         X(I) = B(I)
      O = M + 1
      L = N
      IF ( M .EQ. N ) L = N - 1
      K = 4
C     -----------------------------------------
C     |*** APPLY ORTHOGONAL TRANSFORMATION ***|
C     -----------------------------------------
      DO 80 J = 1,L
           T = 0.
           DO 60 I = J,M
60              T = T + X(I)*A(I+K)
           DO 70 I = J,M
70              X(I) = X(I) - T*A(I+K)
80         K = K + O
      J = N
      K = 3 + O*N
      H = K
C      ---------------------------------
C      |*** SOLVE TRIANGULAR SYSTEM ***|
C      ---------------------------------
90    K = K - O
      T = X(J)/A(J+K)
      X(J) = T
      IF ( J .EQ. 1 ) GOTO 110
      J = J - 1
      DO 100 I = 1,J
100        X(I) = X(I) - T*A(I+K)
      GOTO 90
110   IF ( N .EQ. 1 ) RETURN
C      ----------------------------------
C      |*** PERFORM PIVOT OPERATIONS ***|
C      ----------------------------------
120   J = A(L+H)
      T = X(J)
      X(J) = X(L)
      X(L) = T
      L = L - 1
      IF ( L .GT. 0 ) GOTO 120
      RETURN
      END
