C
C      ________________________________________________________
C     |                                                        |
C     |   PERFORM AN ITERATION OF LANCZOS METHOD TO REDUCE A   |
C     |               MATRIX TO TRIDIAGONAL FORM               |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         Q     --CONTAINS THE INITIAL VECTOR FOR THE    |
C     |                 LANCZOS PROCESS AT START OF ITERATION 1|
C     |                                                        |
C     |         N     --MATRIX DIMENSION                       |
C     |                                                        |
C     |         MULT  --NAME OF SUBROUTINE TO MULTIPLY MATRIX A|
C     |                 BY VECTOR (NAME EXTERNAL IN MAIN PROG.)|
C     |                 MULT(P,X) STORES IN P THE PRODUCT AX   |
C     |                                                        |
C     |         W     --WORK ARRAY WITH AT LEAST 2N ELEMENTS   |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         Q     --COLUMN J OF THE ORTHOGONAL FACTOR      |
C     |                 ONAL FACTOR                            |
C     |                                                        |
C     |         D     --DIAGONAL OF TRIDIAGONAL MATRIX         |
C     |                                                        |
C     |         U     --SUPERDIAGONAL OF TRIDIAGONAL MATRIX    |
C     |                                                        |
C     |         P     --SUPERDIAGONAL SQUARED (CAN BE IDENTI-  |
C     |                 FIED WITH U IF THE SQUARES NOT DESIRED)|
C     |                                                        |
C     |    BUILTIN FUNCTIONS: SQRT                             |
C     |________________________________________________________|
C
      SUBROUTINE LANCZ(Q,D,U,P,J,N,MULT,W)
      INTEGER I,J,N
      REAL D(1),U(1),P(1),Q(1),W(N,1),S,T
      IF ( J .GT. N ) RETURN
      IF ( J .GT. 1 ) GOTO 50
      T = 0.
      DO 10 I = 1,N
10         T = T + Q(I)**2
      IF ( T .EQ. 0. ) RETURN
      T = 1./SQRT(T)
      DO 20 I = 1,N
           Q(I) = T*Q(I)
20         W(I,1) = Q(I)
      CALL MULT(W,Q)
      T = 0.
      DO 30 I = 1,N
30         T = T + Q(I)*W(I,1)
      D(1) = T
      DO 40 I = 1,N
           W(I,2) = W(I,1) - T*Q(I)
40         W(I,1) = Q(I)
      RETURN
50    T = 0.
      DO 60 I = 1,N
60         T = T + W(I,2)**2
      IF ( T .EQ. 0. ) RETURN
      P(J-1) = T
      T = SQRT(T)
      U(J-1) = T
      S = 1./T
      DO 70 I = 1,N
           W(I,2) = S*W(I,2)
70         Q(I) = W(I,2)
      CALL MULT(W(1,2),Q)
      S = 0.
      DO 80 I = 1,N
           W(I,1) = W(I,2) - T*W(I,1)
80         S = S + Q(I)*W(I,1)
      D(J) = S
      DO 90 I = 1,N
           W(I,2) = W(I,1) - S*Q(I)
90         W(I,1) = Q(I)
      RETURN
      END
