C
C      ________________________________________________________
C     |                                                        |
C     | COMPUTE DIAGONALIZATION OF A REAL SYMMETRIC BAND MATRIX|
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         LV    --LEADING (ROW) DIMENSION OF ARRAY V     |
C     |                                                        |
C     |         A     --ARRAY CONTAINING DIAGONAL AND SUBDIAG- |
C     |                 ONAL BANDS FROM COEFFICIENT MATRIX     |
C     |                                                        |
C     |         LA    --LEADING (ROW) DIMENSION OF ARRAY A     |
C     |                                                        |
C     |         N     --MATRIX DIMENSION                       |
C     |                                                        |
C     |         H     --HALF BANDWIDTH                         |
C     |                                                        |
C     |         W     --WORK ARRAY WHICH CAN BE IDENTIFIED WITH|
C     |                 ARRAY A ALTHOUGH THE ORIGINAL COEFFI-  |
C     |                 CIENTS WILL BE DESTROYED               |
C     |                 (LENGTH AT LEAST (H+1)(N-.5H+6) - 12)  |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         E     --ARRAY OF EIGENVALUES                   |
C     |                                                        |
C     |         V     --ARRAY OF EIGENVECTORS                  |
C     |                                                        |
C     |         A     --THE ORIGINAL A ARRAY IS UNTOUCHED      |
C     |                 UNLESS W IS IDENTIFIED WITH A          |
C     |                                                        |
C     |    PACKAGE SUBROUTINES: HSIM,TDG                       |
C     |________________________________________________________|
C
      SUBROUTINE HDIAG(E,V,LV,A,LA,N,H,W)
      REAL E(1),V(LV,1),A(LA,1),W(1)
      INTEGER H
      IF ( H .GT. 0 ) GOTO 30
      DO 20 J = 1,N
           DO 10 I = 1,N
10              V(I,J) = 0.
           V(J,J) = 1.
20         E(J) = A(1,J)
      RETURN
30    CALL HSIM(V,LV,E,V,A,LA,N,H,W)
      M = N - 1
      DO 40 I = 1,M
           W(I) = E(I)
           W(I+N) = V(I,1)
40         V(I,1) = 0.
      V(N,1) = 0.
      V(1,1) = 1.
      W(N) = E(N)
      M = N + 1
      CALL TDG(E,V,LV,W,W(M),N)
      RETURN
      END
