C
C      ________________________________________________________
C     |                                                        |
C     |   COMPUTE ALL EIGENVALUES OF A REAL HESSENBERG MATRIX  |
C     |                                                        |
C     |    INPUT:                                              |
C     |                                                        |
C     |         A     --COEFFICIENTS OF HESSENBERG MATRIX      |
C     |                 PACKED AT START OF REAL ARRAY          |
C     |                 (LENGTH AT LEAST (N+1)(N+2) - 4)       |
C     |                                                        |
C     |         N     --DIMENSION OF MATRIX STORED IN A        |
C     |                                                        |
C     |         W     --REAL WORK ARRAY WITH AT LEAST          |
C     |                 4N ELEMENTS                            |
C     |                                                        |
C     |    OUTPUT:                                             |
C     |                                                        |
C     |         E     --COMPLEX ARRAY OF EIGENVALUES           |
C     |                                                        |
C     |    BUILTIN FUNCTIONS: ABS,AIMAG,CONJG,REAL             |
C     |    PACKAGE FUNCTIONS: MAG                              |
C     |    PACKAGE SUBROUTINES: VLS                            |
C     |________________________________________________________|
C
      SUBROUTINE EVALS(E,A,N,W)
      COMPLEX E(1),Z
      REAL A(1),W(1),MAG,R,S,T
      INTEGER I,J,K,L,M,N
      J = (N+1)*(N+2) - 4
      I = J/2
10    A(J-1) = A(I)
      A(J) = 0.
      I = I - 1
      J = J - 2
      IF ( I .GT. 0 ) GOTO 10
      M = N + 1
      L = M + N
      CALL VLS(E,A,N,W,W(M),W(L))
      I = M
20    I = I - 1
      IF ( I .LE. 1 ) GOTO 50
      Z = CONJG(E(I))
      R = ABS(AIMAG(Z))
      S = R
      L = I - 1
      DO 30 J = 1,L
           T = MAG(E(J)-Z)
           IF ( T .GE. S ) GOTO 30
           K = J
           S = T
30    CONTINUE
      IF ( R .GT. S ) GOTO 40
      E(I) = REAL(Z)
      GOTO 20
40    E(K) = E(L)
      E(L) = Z
      I = L
      GOTO 20
50    IF ( I .EQ. 1 ) E(I) = REAL(E(I))
      RETURN
      END
