
#if defined(HAVE_MAC_DIRS) || defined(__MWERKS__)
#include <LiDIA:base_vector.h>
#include <LiDIA:base_vector.c>
#include <LiDIA:sort_vector.h>
#include <LiDIA:sort_vector.c>

#if defined (BASE_FACTOR)
#include <LiDIA:base_factor.h>
#include <LiDIA:base_factor.c>
#endif

#if defined (SINGLE_FACTOR)
#include <LiDIA:single_factor.h>
#include <LiDIA:single_factor.c>
#endif

#if defined (FACTORIZATION)
#include <LiDIA:ppair.h>
#include <LiDIA:factorization.h>
#include <LiDIA:factorization.c>
#endif

#else /* defined(HAVE_MAC_DIRS) || defined(__MWERKS__) */

#include <LiDIA/base_vector.h>
#include <LiDIA/base_vector.c>
#include <LiDIA/sort_vector.h>
#include <LiDIA/sort_vector.c>

#if defined (BASE_FACTOR)
#include <LiDIA/base_factor.h>
#include <LiDIA/base_factor.c>
#endif

#if defined (SINGLE_FACTOR)
#include <LiDIA/single_factor.h>
#include <LiDIA/single_factor.c>
#endif

#if defined (FACTORIZATION)
#include <LiDIA/ppair.h>
#include <LiDIA/factorization.h>
#include <LiDIA/factorization.c>
#endif

#endif /* defined(HAVE_MAC_DIRS) || defined(__MWERKS__) */


#if defined (BASE_FACTOR)
template class base_factor< TYPE >;
#endif

#if defined (SINGLE_FACTOR)
#if !defined (BASE_FACTOR)
template class   base_factor< TYPE >;
#endif
template class single_factor< TYPE >;
#endif

#if defined (FACTORIZATION)
template class ppair< single_factor< TYPE >, lidia_size_t >;
template void swap(ppair< single_factor< TYPE >, lidia_size_t > &,
		   ppair< single_factor< TYPE >, lidia_size_t > &);
template int compare(ppair< single_factor< TYPE >, lidia_size_t > const &,
		     ppair< single_factor< TYPE >, lidia_size_t > const &);
template istream & operator >> (istream &,
		    ppair< single_factor< TYPE >, lidia_size_t > &);
template ostream & operator << (ostream &,
		    const ppair< single_factor< TYPE >, lidia_size_t > &);
		    
template class comparator< ppair< single_factor< TYPE >, lidia_size_t > >;

template class base_vector< ppair< single_factor< TYPE >, lidia_size_t > >;
template class sort_vector< ppair< single_factor< TYPE >, lidia_size_t > >;

template class factorization< TYPE >;
template factorization< TYPE > factor_all_components(const factorization < TYPE >&F);
#endif

