//
// LiDIA - a library for computational number theory
// Copyright(c) 1995 by the LiDIA Group
//
// File: factorization_appl.c
// Author: Thomas Pfahler(TPf)
// Last change: TPf, Apr 10 1995, initial version
//

#if defined(HAVE_MAC_DIRS) || defined(__MWERKS__)

#include <LiDIA:Fp_polynomial.h>
#include <LiDIA:bigint.h>
#include <LiDIA:factorization.h>

#else

#include <LiDIA/Fp_polynomial.h>
#include <LiDIA/bigint.h>
#include <LiDIA/factorization.h>

#endif


typedef Fp_polynomial elem_type;
//typedef long elem_type;
//typedef bigint elem_type;

  

main()
{
  int err_num = 0;
  
  cout<<"\n\n This (very simple) program runs several tests to verify\n";
  cout<<" the correctness of the template class factorization<Fp_polynomial>.\n";
  cout<<" If an error occurs, a corresponding message\n";
  cout<<" is displayed. At the end, the program reports\n";
  cout<<" the number of detected errors.\n\n"<<endl;


  factorization<elem_type> F1;

  cout<<" Please enter a factorization with at least two entries\n";
  cout<<" (format: [ [base1, exp1], [base2, exp2], ... [basen, expn] ] :\n\n";
  cin >> F1;
  cout<<"\n\n"<<F1<<"\n"<<endl;

  cout<<"Please, check whether the output for a is correct."<<endl;
  cout<<"==================================================\n"<<endl;




  factorization< elem_type > F2(F1), F3;
  if (F1 != F2)
  {
	cout<<"factorization(factorization) or operator!= failed\n"<<endl;
	err_num++;
  }

  F2.kill();
  if (F2 != F3)
  {
	cout<<"factorization() or kill() or operator!= failed\n"<<endl;
	err_num++;
  }

  F2 = F1;
  if (F1 != F2)
  {
	cout<<"operator= or operator!= failed\n"<<endl;
	err_num++;
  }



  single_factor< elem_type > s1;
  if (F1.no_of_components() > 0)
  {
	s1 = F1.composite_base(0);
	F2.kill();
	F2 = s1;
	factorization< elem_type > F4(s1);
	if (F2 != F4)
	{
	  cout<<"factorization(single_factor) or operator!= failed\n"<<endl;
	  err_num++;
	}
  }

  elem_type t1;
  t1 = F1.unit();
  single_factor< elem_type > s2(t1), s3;
  s3 = t1;
  if (s2 != s3)
  {
	cout<<"single_factor(single_factor) or operator= failed\n"<<endl;
	err_num++;
  }


  cout<<"\nNumber of errors : "<<err_num<<endl;
  if (err_num == 0)
      cout<<"OK.\n";
}
