//
// LiDIA - a library for computational number theory
//   Copyright (c) 1994, 1995 by the LiDIA Group
//
// File        : Findhmain.c
// Author      : Michael Jacobson, Jr. (MJ)
// Last change : MJ, September 24, 1996, initial version
//

#if defined(HAVE_MAC_DIRS) || defined(__MWERKS__)
#include <LiDIA:quadratic_order.h>
#else
#include <LiDIA/quadratic_order.h>
#endif

main()
{
  bigint D;
  quadratic_order QO;
  int vb;

  cout << "Enter verbosity: ";
  cin >> vb;
  quadratic_order::verbose(vb);
  qi_class::verbose(vb);

  cout << "Enter a quadratic discriminant: ";
  cin >> D;
  cout << "\n";
  while (D != 0) {
    if (QO.assign(D)) {
      QO.class_group();
      QO.generators();
      QO.Lfunction();
      QO.factor_discriminant();

      cout << QO << "\n";
      cout << "   ULI = " << QO.ULI() << "\n";
      cout << "   LLI = " << QO.LLI() << "\n\n";
    }

    cout << "Enter a quadratic discriminant: ";
    cin >> D;
    cout << "\n";
  }
}
