
//
// LiDIA - a library for computational number theory
//   Copyright (c) 1994, 1995, 1996 by the LiDIA Group
//
// File        : divisors_appl.c
// Author      : Markus Maurer (MM)
// Last change : MM, SEp 26 1996, initial version
//

#include <LiDIA/nmbrthry_functions.h>

void main()
{
  bigint n;

  cout << "Please enter a bigint n = ";
  cin  >> n;

  rational_factorization f(n);
  f.factor();

  cout << "All positive divisors of " << n << ": " << divisors(n);
  cout << "\n";

  cout << "All positive and negative divisors of " << n << ": ";
  cout << all_divisors(n);
  cout << "\n";

  cout << "All positive square-free divisors of " << n << ": ";
  cout << square_free_divisors(n);
  cout << "\n";

  cout << "All positive and negative square-free divisors of " << n << ": ";
  cout << all_square_free_divisors(n);
  cout << "\n";

  cout << "All positive divisors of " << n << " whose square divides " << n << " : ";
  cout << square_divides_n_divisors(n);
  cout << "\n";

  cout << "All positive and negative divisors of " << n << " whose square divides " << n << " : ";
  cout << all_square_divides_n_divisors(n);
  cout << "\n";
}

