//
// LiDIA - a library for computational number theory
//   Copyright (c) 1994, 1995, 1996 by the LiDIA Group
//
// File        : ideal_appl.cc (based on bigrational_appl.c,
//                              based on the GNU Integer Test)
// Author      : Stefan Neis (SN)

/*
  $Id: ideal_appl.c,v 1.3 1996/12/18 13:28:59 neis Exp $
*/

#include <assert.h>
#include <stdlib.h>
#include <fstream.h>

#if defined(HAVE_MAC_DIRS) || defined(__MWERKS__)
#include <LiDIA:alg_number.h>
#else
#include <LiDIA/alg_number.h>
#endif

ifstream in("alg_appl_input");

void identitytest(const alg_ideal& a, const alg_ideal& b, const alg_ideal& c)
{
  alg_ideal res1;
  module res2;
  res1 = a/b;
  res2 = ((module)a)/b;
  assert( res1 == res2);
  assert( (a / b) ==  (module(a) / b));
  assert( (a * b) ==  (module(b) * module(a)));
  assert( (a / (b / c)) ==  ((a * c) / b));
  assert( ((a / b) * c) ==  ((a * c) / b));
  assert( ((a * b) / b) ==  a);
  debug_handler_c("module_appl::identitytest","preparing assertion 7",3,
                  cout<<a<<b<<(a/b)<<((a/b)*b));
  assert( ((module(a) / b) * b) ==  a);

  alg_ideal d;
  module d1;

  multiply(d1, b, a);
  debug_handler_c("module_appl::identitytest","preparing assertion 8",3,
                  cout<<a<<b<<(a*b)<<d1);
  assert( (a * b) ==  d1);
  multiply(d, b, a);
  debug_handler_c("module_appl::identitytest","preparing assertion 9",3,
                  cout<<d);
  assert( d ==  d1);
  divide(d1, a, b);
  debug_handler_c("module_appl::identitytest","preparing assertion 10",3,
                  cout<<a<<b<<(a/b)<<d1);
  assert( (a / b) ==  d1);
  divide(d, a, b); 
  assert( d ==  d1);
  assert( d ==  d);
}


void all_test(const bigint & ii)
{
  alg_ideal a,b;

  debug_handler_l("ideal_appl", "start all_test(const bigint &)",4);
  do{
    a.randomize(ii);
  } while (a*a.denominator()==order(a.which_base()));

  do{
    b.randomize(ii);
  } while (b*b.denominator()==order(b.which_base()));

  cout << "\n\n Test with \na = " << a << "\nb = " << b<<endl;

  debug_handler_l("ideal_appl", "call identitytest from all_test",4);
  identitytest(a, b, b);
  debug_handler_l("ideal_appl", "call identitytest again from all_test",4);
  identitytest(a, a, b);
}


int main()
{
  order O;
  cout << "Order:\n"<<flush;
  in >> O;

  order ext = O.maximize();

  cout <<O <<endl<< ext<<endl;
  bigint i=129099121;

  for(int j=0; j<10; j++)
    all_test(i);

  cout << "\nEnd of test\n";
  return 0;
}


