//
// LiDIA - a library for computational number theory
// Copyright (c) 1995 by the LiDIA Group
//
// xdouble_appl.c
// Copyright (c) 1995, 1996 by Keith Briggs
//
// File        : xdouble_appl.c
// Author      : Keith Briggs (KB)
// Last change : KB, Mar 1 1995, initial version
//               TP, Oct 5 1995, ported to LiDIA
//

#include <LiDIA/xdouble.h>
#include <stdlib.h>

main()
{
  cout << setprecision(17);
  xdouble one = 1.0, two = 2.0, x, y, z, e;
  int i;
  z = "1234567890.123456789012345678901234567890";
  cout << "Test 0: 1+1.0e-40 = ";
  cout << xdouble(1.0) + xdouble(1.0e-40) << endl;
  cout << "Test 1: input/output conversion\n";
  cout << "This should be 0.333333333: " << xdouble("0.333333333") << endl;
  cout << "This should be 0.0000333333333: " << xdouble("00000.0000333333333") << endl;
  cout << "This should be 333333333: " << xdouble("333333333") << endl;
  cout << "This should be 333333333e12: " << xdouble("333333333e12") << endl;
  cout << "This should be -333333333.3333: " << xdouble("-333333333.3333") << endl;
  cout << "This should be -333333333.33e-04: " << xdouble("-333333333.33e-04") << endl;
  cout << "The next output should be..\n";
  cout << "   1234567890.123456789012345678901234567890\n";
  cout << "z=" << z << "\n";
  cout << "Test 2: fmod(\",10)\n";
  cout << "z mod 10: " << fmod(z, 10) << endl;
  z = floor(z);
  cout << "Test 3: floor(\"\")\n";
  cout << "Floor: " << (z) << endl;
  cout << "Test 4: exp(1)\n";
  cout << "Should be\n" <<
    " 2.7182818284590452353602874713526624977572470936999\n";
  cout << setprecision(32);
  z = exp(one);
  cout << z << "\n";
  e = exp(one);
  cout << "Test 5: log\n";
  z = log(recip(e * e));
  cout << "log(1/e/e): " << z << endl;
  z = log(recip(e));
  cout << "log(1/e): " << z << endl;
  z = log(e);
  cout << "log(e): " << z << endl;
  y = log(e * e);
  cout << "log(e^2): " << y << endl;
  y = log(e * e * e);
  cout << "log(e^3): " << y << endl;
  z = 0.159;
  cout << "log(0.159): " << log(z) << endl;
  cout << "Test 6: exp: next output should be 1.23456789\n";
  // exp(z) is exactly 1.23456789...
  z = "0.2107210222156525610500017104882905489049";
  z = exp(z);
  cout << z << "\n";
  cout << "Test 7: two reciprocals of previous result\n";
  z = one / z;
  cout << z << "\n";
  z = one / z;
  cout << z << "\n";
  cout << "Test 8: multiplication: next output should be 2\n";
  z = "1.4142135623730950488016887242096980785696718753769";
  cout << z * z << endl;
  cout << "Timing...\n";
  for (i = 1; i < 100000; i++)
    y = z * z;
  cout << " sqrt(2) should be " <<
    " 1.4142135623730950488016887242096980785696718753769\n";
  cout << "Test 9: Start with 2, sqrt five times and sqr five times\n";
  x = sqrt(two);
  cout << x << "\n";
  x = sqrt(x);
  cout << x << "\n";
  x = sqrt(x);
  cout << x << "\n";
  x = sqrt(x);
  cout << x << "\n";
  x = sqrt(x);
  cout << x << "\n";
  x = x * x;
  cout << x << "\n";
  x = x * x;
  cout << x << "\n";
  x = x * x;
  cout << x << "\n";
  x = x * x;
  cout << x << "\n";
  x = x * x;
  cout << x << "\n";
  cout << "Test 10: Comparison\n";
  x = "123456789.1234567890123456789";
  y = "123456789.1234567891";
  cout << "Next 3 should be true...\n";
  cout << (x < y) << endl;
  cout << (y >= x) << endl;
  cout << (y != x) << endl;
  cout << "Next should be false...\n";
  cout << (y == x) << endl;
  cout << (x > y) << endl;
  cout << "Test 11: sin\n";
  const xdouble exact_sin[] = {
    "0.000099999999833333333416666666646825396828152557318973",
    "0.0009999998333333416666664682539710097001513147348086",
    "0.0099998333341666646825424382690997290389643853601692",
    "0.099833416646828152306814198410622026989915388017982",
    "0.84147098480789650665250232163029899962256306079837",
    "-0.54402111088936981340474766185137728168364301291622",
    "-0.50636564110975879365655761045978543206503272129066",
    "0.82687954053200256025588742910921814121272496784779",
    "-0.30561438888825214136091003523250697423185004386181",
  };
  x = "0.0001";
  for (i = 0; i < 9; i++)
    {
      y = sin(x);
      cout << "sin(" << x << ")=" << y << "; abs error=";
      cout << y - exact_sin[i] << endl;
      x = 10.0 * x;
    }
  cout << "Test 12: arctan\n";
  const xdouble exact_atan[] = {	// exact_atan[i]=atan(10^(i-4))
    "0.000099999999666666668666666652380952492063491154401162",
    "0.00099999966666686666652380963492054401162093455426801",
    "0.0099996666866652382063401162092795485613693525443766",
    "0.099668652491162027378446119878020590243278322504315",
    "0.78539816339744830961566084581987572104929234984378",
    "1.4711276743037345918528755717617308518553063771832",
    "1.5607966601082313810249815754304718935372153471432",
    "1.5697963271282297525647978820048308980869637651333",
    "1.5706963267952299525626550249873704896065212085332"
    };
  x = "0.0001";
  for (i = 0; i < 8; i++)
    {
      xdouble S = atan(x);
      cout << "arctan(" << x << ")=" << S << "; abs error=";
      cout << S - exact_atan[i] << endl;
      x = 10.0 * x;
    }
  x = "0.1";
  cout << "Test 13: tan(arctan(0.1))=" << sin(atan(x)) / cos(atan(x)) << endl;
  cout << "Test 14: input conversion\n";
  cout << "Please enter a number, terminate with <Enter>: ";
  cin >> x;
  cout << "\nYou entered " << x << endl;
}



