//
// LiDIA - a library for computational number theory
//   Copyright (c) 1994, 1995 by the LiDIA Group
//
// File        : hash_table_appl.c
// Author      : Michael Jacobson, Jr. (MJ)
// Last change : MJ, September 24, 1996
//

#include <LiDIA/hash_table.h>

bigint
ikey(const int & G) { return bigint(G); }


main()
{
  hash_table < int > HT,HT2;
  int i,x,*y;

  HT.initialize(20);
  HT.set_key_function(&ikey);

  cout << "#buckets = " << HT.no_of_buckets() << "\n";
  cout << "current size = " << HT.no_of_elements() << "\n\n";

  for (i=0; i<30; ++i)
    HT.hash(i);
  for (i=-50; i>-60; --i)
    HT.hash(i);

  cout << "\ncurrent size = " << HT.no_of_elements() << "\n";
  x = HT.last_entry();
  cout << "last entry = " << x << "\n";
  y = HT.search(x);
  if (y)
    cout << "search succeeded!  Last entry is in the table.\n";
  else
    cout << "search failed!  Please report this bug!\n";

  cout << "\nContents of HT:\n";
  cout << HT << "\n";

  cout << "\ncopying...\n\n";
  HT2 = HT;
  cout << "contents of new table:\n";
  cout << HT2 << "\n";
  cout << "#buckets = " << HT2.no_of_buckets() << "\n";
  cout << "current size = " << HT2.no_of_elements() << "\n\n";

  cout << "remove function...\n";
  for (i=7; i<50; i+=7) {
    cout << "remove " << i << "\n";
    HT2.remove(i);
  }
  cout << "contents of new table:\n";
  cout << HT2 << "\n";
  cout << "#buckets = " << HT2.no_of_buckets() << "\n";
  cout << "current size = " << HT2.no_of_elements() << "\n\n";

  cout << "emptying it...\n";
  cout << "contents of new table:\n";
  HT2.empty();
  cout << HT2 << "\n";
  cout << "#buckets = " << HT2.no_of_buckets() << "\n";
  cout << "current size = " << HT2.no_of_elements() << "\n\n";
}
