//
// LiDIA - a library for computational number theory
//   Copyright (c) 1995 by the LiDIA Group
//
// File        : timer.h 
// Author      : Thomas Papanikolaou (TP)
// Last change : TP, Feb 7 1995, initial version
//

#ifndef LIDIA_TIMER_H
#define LIDIA_TIMER_H

#include <LiDIA/lidia.h>

#define TIME_MODE 0
#define HMS_MODE 1

#ifdef sun
extern "C" {int getrusage(int who, struct rusage *rusage);}
#endif

class timer 
{
  private:

#ifdef HAVE_GETRUSAGE
  static struct rusage buffer;
#else
  static struct tms buffer;
#endif

  long user_t, sys_t;
  long t_user_t, t_sys_t;
  int print_mode;

  void print_hms(ostream & out = cout, long rt = 0) const;

  public:

  timer();
  timer(const timer &);
  ~timer();

  int set_print_mode(int x = 1);
  int get_print_mode() const;

  void start_timer(); 
  void stop_timer(); 
  void cont_timer(); 

  long user_time() const;
  long sys_time() const;
  long real_time() const;

  void print(ostream & out = cout) const;
  
  timer & operator = (const timer & t);

  friend ostream & operator << (ostream & out, const timer & t);

};

#endif



