#include "kant.h" 
 
 
main(
)
/*******************************************************************************
 
units_t2.c
  
S-Units (free choice of factor basis, T2 and number of relations)
  
*******************************************************************************/
{
	block_declarations;
 
	order		ord;
        integer_big     T2, MF, mink, bach;
        integer_small   numrel;
                    
	kant_start();

        anf_print_level = 1;
 
	while (order_read(&ord))
	{
		order_mult_assure(ord);
		order_disc_assure(ord);
                order_reals_assure(ord);
	        mink = order_minkowski_bound(ord);
	        bach = order_bach_bound(ord);

		for (;;)
		{
			printf("Give ideal bound / T2 bound:\n");
			scanf("%d %d", &MF, &T2);
			if (MF < 2 || T2 < 2) break;
                                                 
			printf("How many relations for each ideal?\n");
			scanf("%d", &numrel);                
			if (numrel < 1) break;
 
                        order_fac_basis_create(ord, MF);
                        order_relations_find(ord, T2, numrel);
                        order_relation_eval_units(ord);
                        order_relation_eval_class_group(ord);
 
                        order_fac_basis_delete(ord);
                        order_relation_delete(ord);
		}                  
                                           
                order_write(ord);
	        order_delete(&ord);
              
                integer_delref(mink);
                integer_delref(bach);
	}
}
