#ifndef _Z_E_
#define _Z_E_

#include "defs.h"
#include "integer.e"

/*
 *	Prototypes
 */

extern t_handle	z_quotient_ring P_((t_handle, t_handle));
extern t_handle z_abs P_((t_handle,t_handle));
extern t_void z_add P_((t_handle,integer_big,integer_big,integer_big *));
extern t_void z_base_sequence P_((t_int,t_int,t_handle*,t_handle *));
extern t_handle z_binomial P_((int,int));
extern t_handle z_carmichael_lambda P_((t_handle));
extern t_handle z_chinese_rem P_((t_handle,t_handle,t_handle));
extern t_handle z_div P_((t_handle,t_handle));
extern t_handle z_divisor_sigma P_((t_handle,t_handle));
extern t_handle z_divisors P_((t_handle));

extern t_logical z_elt_coerce P_((t_handle,t_handle,t_handle,t_int,t_handle *,t_int *,t_logical));
extern t_void z_elt_delete P_((t_handle,integer_big *));
extern integer_big z_elt_incref P_((t_handle,integer_big));
extern t_void z_elt_print P_((t_handle,integer_big));
extern t_handle z_eq P_((t_handle,t_handle,t_int,t_handle,t_handle,t_int));
extern t_handle z_euler_phi P_((t_handle));
extern t_logical z_is_even P_((t_handle,t_handle,t_handle));
extern t_void z_factor P_((t_handle,t_handle,t_handle*,t_handle *));
extern t_handle z_factorial P_((t_handle));
extern t_handle z_gcd P_((t_handle,t_handle,t_handle));
extern t_handle z_ge P_((t_handle,t_handle,t_int,t_handle,t_handle,t_int,int));
extern t_handle z_gt P_((t_handle,t_handle,t_int,t_handle,t_handle,t_int));
extern t_int z_int P_((t_handle));
extern t_logical z_is_member P_((t_handle,t_handle,t_handle,t_handle));
extern t_bool z_is_minus_one P_((t_handle,integer_big));
extern t_handle z_is_one P_((t_handle,integer_big));
extern t_logical z_is_square P_((t_handle,integer_big));
extern t_bool z_is_zero P_((t_handle,integer_big));
extern t_handle z_jacobi_symbol P_((t_handle,t_handle));
extern t_handle z_lcm P_((t_handle,t_handle,t_handle));
extern t_handle z_le P_((t_handle,t_handle,t_int,t_handle,t_handle,t_int));
extern t_handle z_legendre_symbol P_((t_handle,t_handle));
extern t_handle z_log2 P_((t_handle,t_handle));
extern t_handle z_lt P_((t_handle,t_handle,t_int,t_handle,t_handle,t_int));
extern t_handle z_max P_((t_handle,t_handle,t_handle));
extern t_handle z_min P_((t_handle,t_handle,t_handle));
extern t_handle z_mod P_((t_handle,t_handle,t_handle));
extern t_handle z_mod_order_sub P_((t_handle,t_handle));
extern t_handle z_modexp P_((t_handle,t_handle,t_handle));
extern t_handle z_moebius_mu P_((t_handle));
extern t_void z_mult P_((t_handle,integer_big,t_int,integer_big,t_int,integer_big*,t_int *));
extern t_int z_multinomial P_((t_handle));
extern t_void z_ne P_((t_handle,t_handle,t_int,t_handle,t_handle,t_int,t_handle *));
extern integer_big z_negate P_((t_handle,integer_big,integer_big *));
extern t_handle z_next_prime P_((t_handle,t_handle));
extern integer_small z_norm_eqn P_((t_handle,integer_big,integer_big,integer_big*,integer_big *, t_handle));
extern integer_small z_cornaccia P_((integer_big,integer_big,integer_big*,integer_big*,faclst *));
extern faclst z_find_m_i_factors P_((faclst,faclst,integer_big));
extern integer_small z_one P_((t_handle));
extern t_handle z_mod_order P_((t_handle,t_handle));
extern t_handle z_partitions P_((t_handle));
extern t_void z_pfactorisation P_((t_handle,t_handle,t_handle,t_handle*,t_handle *));
extern t_void z_power P_((t_handle,integer_big,t_int,integer_big,t_handle*,integer_big*,t_int *));
extern t_handle z_prev_prime P_((t_handle,t_handle));
extern t_int z_primality P_((int,int));
extern t_logical z_prime P_((int,int));
extern t_handle z_prime_basis P_((t_handle));
extern t_handle z_prime_cert P_((integer_big,t_handle));
extern t_logical z_prime_power P_((t_handle));
extern t_logical z_primitive P_((t_handle,t_handle,t_handle));
extern t_handle z_primitive_root P_((t_handle,t_handle,t_handle*,t_handle *));
extern t_void z_quotrem P_((t_handle,t_handle,t_handle,t_handle*,t_handle *));
extern t_handle z_ranbig P_((t_handle));
extern t_handle z_ranint P_((t_handle,t_handle,t_handle));
extern t_handle z_root P_((t_handle,t_handle,t_handle));
extern t_handle z_seq_divisors P_((t_handle));
extern t_int z_seq_gcd P_((t_handle,t_handle));
extern t_int z_seq_lcm P_((t_handle,t_handle));
extern t_int z_seq_max P_((t_handle,t_handle));
extern t_int z_seq_min P_((t_handle,t_handle));
extern t_void z_seq_xgcd P_((t_handle,t_handle,integer_big*,t_handle *));
extern t_void z_sequence_base P_((t_int,t_handle,t_handle*,t_int *));
extern t_handle z_solution P_((t_handle,t_handle,t_handle,t_handle));
extern t_handle z_solution_seq P_((t_handle,t_handle,t_handle));
extern t_handle z_sqrt P_((t_handle,t_handle));
extern t_int z_square_free P_((t_handle,t_handle*,t_handle*,t_handle*,t_handle*,t_handle *));
extern t_handle z_stirling_first P_((t_handle,t_handle));
extern t_handle z_stirling_second P_((t_handle,t_handle));
extern t_handle z_stk_divisors P_((t_handle));
extern t_handle z_lst_divisors P_((faclst));
extern t_handle z_str_create P_((void));
extern t_void z_str_delete P_((t_handle,t_handle *));
extern t_handle z_str_incref P_((t_handle,t_handle));
extern t_handle z_str_print P_((t_handle,t_handle));
extern t_void z_subtract P_((t_handle,integer_big,integer_big,integer_big *));
extern t_void z_xgcd P_((t_handle,t_handle,t_handle,t_handle*,t_handle*,t_handle *));

/*
 *	Macros for increffing and deleting z.
 */

#ifdef DEVELOP
#define m_z_str_incref(s)	block_incref(s)
#define m_z_str_delete(s)	z_str_delete(0,&s)
#else
#define m_z_str_incref(s)	(s)
#define m_z_str_delete(s) 	/* nothing */
#endif

#endif /* _Z_E_ */
