/*
 *	Global types and defines.
 */  
#define io_printf    printf

#ifndef _TYPES_H_
#define _TYPES_H_

#ifdef __STDC__
#    ifdef APOLLO
#	 undef ANSI_C
#        define SEMI_ANSI_C
#    else
#        define ANSI_C
#        define SEMI_ANSI_C
#    endif
#else
#    undef ANSI_C
#    undef SEMI_ANSI_C
#endif

#if defined(SEMI_ANSI_C) || defined(__cplusplus)
#define P_(s) s
#else
#define DO_NOT_USE_PROTOTYPES
#define P_(s) ()
#endif

#ifdef SEMI_ANSI_C

typedef void *t_ptr;
#define CONST	const

#else

typedef char *t_ptr;
#define	CONST

#endif

#define private 				static
#define public

#include "config.h"
#include "withargs.h"    /* Defines macros for prototyping or not */
#include "mem.e"

#define t_mem_word   t_word;


/*
 *	Types used everywhere.
 */

#ifdef VMS
/* The VMS compiler can't t_handle the typedef */
#define t_void	void
#else
typedef void t_void;
#endif

typedef int t_int;
typedef unsigned int t_uint;/* this should be unsigned <whatever a t_word is> */

typedef t_handle t_logical;
typedef char t_char;
typedef char t_byte;
typedef unsigned char t_ubyte;
typedef t_handle t_rat;
typedef t_handle t_chstr;
typedef double t_float;
typedef float t_int_sized_float;
typedef double t_double;
typedef t_handle t_bool;
typedef short t_short;
typedef t_int t_file;

typedef t_void (*t_pfv)();
typedef t_int (*t_pfi)();
typedef t_uint (*t_pfui)();
typedef t_logical (*t_pfl)();
typedef t_handle (*t_pfh)();

/*
 *	Useful defines.
 */

/* print levels */

enum
{
	PRINT_MINIMAL,
	PRINT_DEFAULT,
	PRINT_MAXIMAL,
	PRINT_DEBUG,
	PRINT_CAYLEY,
	PRINT_MAX				/* must be last */
};


/*
 *	V3 defs and caydefs stuff.
 */

#define v3_A(exp, var) (var = (exp), &var)

#define ARITHMETIC_IF(exp, l1, l2, l3)  \
{\
    int _ai_tmp;\
    _ai_tmp = (exp);\
    if ((_ai_tmp) < 0)\
        goto l1;\
    else if ((_ai_tmp) == 0)\
        goto l2;\
    else\
        goto l3;\
}

#define ifix(r)     ((t_int)(r))
#define idint(d)    ((t_int)(d))
#define sngl(d)     ((t_float)(d))
#define dble(i)     ((t_double)(i))
#define ichar(c)    ((t_int)(c))
#define dsqrt(x)    sqrt(x)
#define dexp(x, a)  pow(x, a)
#define alog(x)     log(x)
#define dlog(x)     log(x)
#define alog10(x)   log10(x)
#define dlog10(x)   log10(x)

#define DEFAULT	0
#define Public
#define Private		static

/* #define basic data-types in case we need to change them later
   e.g. to use long rather than int */

typedef t_void Void;
typedef t_char Char;
typedef t_short Short;
typedef t_int Int;
typedef t_logical Logical;
typedef t_float Float;
typedef t_double Double;

#define two_to_the_n(n)	(1 << (n))

/*  Decide whether a t_handle represents a valid stack or is null  */

#define handle_is_valid(h)	((h) != 0)
#define handle_is_null(h)	((h) == 0)

/* 
 *	The following allows direct access to y (master declaration is 
 *	in yinit.c) 
 */

typedef struct
{
	t_int	*yaddr;
	t_int	ywords;
} t_yinit_data;
extern t_yinit_data yinit_data;

/*	values for use by routines which have to access the prime tables */

#define NSPRIMES 168		/* number of small primes in table */
#define NRESIDUES 48		/* number of residues in 210 table */

typedef int	integer_small;
typedef int	integer_big;
typedef integer_big t_integer;
typedef	t_handle	faclst;
typedef	int	faclst_length;
typedef void	(*integer_break_action)( /* long int */ );
typedef t_int	decimal_digit;
typedef t_handle	inthdl_handle;
typedef short	inthdl_sign;
typedef short	inthdl_buf_index;
typedef	int	inthdl_length;
typedef t_handle t_string;

typedef t_handle t_ecart;
typedef t_handle t_eseq;
typedef t_handle t_eset;

typedef t_int	t_gf;

typedef t_handle  t_chtr;
typedef t_handle  t_chtr_table;

typedef t_handle	grp_pc;
typedef struct { t_int deg; t_handle b1, b2, b3, b4, tmp; } t_grp_perm_buff_str;

typedef t_handle t_map;
typedef t_map maps;				/* V3 compatability only */
typedef t_handle t_pow_map;

typedef t_handle t_pow_struct;
typedef t_handle t_process;
typedef t_handle t_tuple;

typedef t_int t_undef;

typedef int	dyn_arr_type;
typedef dyn_arr_type	t_dyn_arr;
typedef t_handle	dyn_arr_handle;
typedef int	dyn_arr_length;

typedef t_handle t_matrix;

typedef int		mp_int;
typedef mp_int		mp_bool;
typedef mp_int		mp_base_type;
typedef mp_int		mp_length;
typedef mp_int		mp_expt_type;
typedef mp_int		mp_sign_type;
typedef short		mp_digit_type;
typedef mp_int		mp_round_type;
typedef long		mp_debug_mask;
typedef void		(*void_func)();
typedef t_handle		mp_float_array;
typedef t_handle		mp_vector;
typedef t_handle		mp_build_context;

typedef mp_float_array	t_comp;


typedef t_handle t_bit_vector;

typedef t_uint t_bs_int;

typedef t_handle	t_pi_elt;
typedef t_int 		t_poly;

typedef t_handle	prime_cert_handle;
typedef int	prime_cert_length;
typedef t_word	rational;
typedef t_word          t_quad;
typedef t_word  t_qmelt;

/*	programs */

typedef t_handle t_prog;

typedef t_handle t_real;
typedef t_handle mp_float;

#if 0
typedef unsigned short int	trbl_block_type;
typedef unsigned short int	trbl_count;
#endif

typedef t_word	t_ring_elt;

/* hl: */
typedef t_word      hl_item_num, hl_sizes, hl_value, hl_hashkey, hl_logical;
typedef t_word  hl_call_types;

/* mat: */
typedef t_handle	t_mat;
typedef	short		t_mat_index;

/* modules: */
typedef t_mat	t_vec;
typedef t_handle	t_module;
typedef t_handle	t_modtuple;
typedef t_handle	t_modhom;
typedef t_handle	t_modkg_str;
typedef t_handle	t_modkg_elt;

/* code: */
typedef t_handle	t_code;
typedef t_mat	t_codeword;

/* gf_bigp: */

typedef t_int	t_gf_bigp;

/* grp_fp: */
typedef t_int	t_letter;

#ifndef KANT
#ifndef NO_SH_NEWNAMES
#include "sh_newnames.h" /* Stackhandler name mapping */
#endif
#define stack_ptr(h)	(mem_access(h) + 8)
#endif

#include "block.e"   /* Tracked block definitions for Cayley */

/*
 *	The definition of a structure.
 *	Public since all modules use it.
 */

typedef struct
{
    t_block_header block_header;   /* block header */
    t_int level;            /* level in the type heirarchy */
    t_handle parent;        /* parent structure */
    t_int flags;		    /* flags (stored, finite, etc.) */
    t_int repnum;           /* struct's representation class */
    t_int defined_vec;      /* bit vector of defined ops */
    t_handle algs;          /* structure specific algorithms */
    t_handle left;			/* Relationship list */
    t_handle right;		    /* Relationship list */
    t_handle type;		/* Class type */
} t_structure_hdr;

/*
 *	Defines and macros
 */

#ifdef ANSI_C
#define VARARGS_DECL(args)		args
#define VARARGS_LOCALS(args)
#define VARARGS_START(ap, type, arg)	va_start(ap, arg)
#define VARARGS_P_(args)		args
#else
#define VARARGS_DECL(args)		(va_alist) va_dcl
#define VARARGS_LOCALS(args)		args
#define VARARGS_START(ap, type, arg)	va_start(ap); arg = va_arg(ap, type)
#define VARARGS_P_(args)		()
#endif

#ifndef FALSE
#define FALSE		0
#define TRUE		1
#define UNKNOWN		2
#endif

#ifdef DEVELOP
extern t_void f_assert P_((t_int,t_char*,t_int,t_char *));

#ifdef ANSI_C
#define ASSERT(x)	f_assert((t_int)(x), __FILE__, __LINE__, #x)
#define CHECK(x)   	f_assert((t_int)(x), __FILE__, __LINE__, #x)
#else
#define ASSERT(x)	f_assert((t_int)(x), __FILE__, __LINE__, "x")
#define CHECK(x)	f_assert((t_int)(x), __FILE__, __LINE__, "x")
#endif

#define DEVELOP_ONLY(x)	(x)

#else

#define ASSERT(x)
#define CHECK(x)	(x)
#define DEVELOP_ONLY(x)

#endif

#define DENY(x)		ASSERT(!((t_int)(x)))
#define DIE()   	error_die(__FILE__, __LINE__)

#define NULL_PTR			((void *)0)

#define VARLEN				(VARIABLE_LENGTH)
#define NP					(NULL_PTR)
#define NULL_HANDLE			(MEM_NH)
#define NH					(NULL_HANDLE)
#define valid_handle(h)		(mem_valid_handle(h))
#define bad_handle(h)		(!valid_handle(h))
#define VH(h)				valid_handle(h)
#define NOT_NH(h)			((h)!=NH)	
#define IS_NH(h)			((h)==NH)	

#define is_undef(str,val,it)	(str==structure_undef)
#define is_def(str,val,it)		(str!=structure_undef)
#define set_undef(str,val,it)	{str=structure_undef;}

#ifdef KANT
#include "platform_dummies.h"
#endif

#endif /* _TYPES_H_ */
