      SUBROUTINE STR001(S,L,KOEF,N)
C
C     ***************************************************************
C     *                                                             *
C     *                    S U B R O U T I N E                      *
C     *                                                             *
C     *                        S T R 0 0 1                          *
C     *                                                             *
C     ***************************************************************
C
*
*DOC             Internal routine, used by COMINP
**DOC
*INDEX  STR001(IN/0): internal routine
**DOC
**DOC   (1) DESCRIPTION IN DETAIL:
**DOC       "Parser" for the way David Ford writes his quartic fields.
**DOC       (Analyse der Ganzheitsbasis)
**DOC       Example: (File //kant1/bsd4.2/user/kant/dat/im4.dat):
**DOC        2   -8   -4    4    4400    D8   +1xx/2, 2x+1xxx/4
**DOC        1   -7   -3    9    4525    D8   -1x-1xx+1xxx/3
**DOC       Explanation:
**DOC         1.) Coefficients of polynomial:  -F(1), F(2), -F(3), F(4)
**DOC         2.) Field discriminant
**DOC         3.) Galois group
**DOC         4.) Integral basis (the polynomials are adjointed to the
**DOC             power basis)
**DOC       STR001 decodes one polynomial of 4.)
**DOC
**DOC   (2) PARAMETER (IN):
**DOC       S      (STR)     String to be decoded
**DOC       N      (INT)     Degree of polynomial (perhaps only N=4 works)
**DOC       L      (INT)     Length of STR
**DOC
**DOC   (3) PARAMETER (OUT):
**DOC       KOEF    (INT1)   Coefficients of polynomial
**DOC
**DOC   (4) PARAMETER (IN/OUT):
**DOC       -
**DOC
**DOC   (5) MODIFICATIONS OF GLOBAL VARIABLES:
**DOC       -
**DOC
**DOC   (6) SUBROUTINES CALLED:
**DOC       -
**DOC
**DOC   (7) INCLUDE-FILES USED:
**DOC       -
**DOC
**DOC   (8) AUTHOR(S):
**DOC       JS       01.09.87
**DOC
**DOC   (9) MODIFICATIONS:
**DOC       -
**DOC
      INTEGER N,KOEF(*),L,I,L1,PTR,KOPTR,X
      CHARACTER*(*) S
      CHARACTER*4 FORM(5)
      DATA FORM /'(I1)','(I2)','(I3)','(I4)','(I5)'/
*
      DO 99 I=1,N
99       KOEF(I) = 0
*
      L1 = INDEX(S,'/')
      READ(S(L1+1:L),FORM(L-L1)) KOEF(N+1)
      L1 = L1 - 1
*
50    PTR = 1
53    DO 101 I=5,1,-1
         READ(S(PTR:PTR+I-1),FORM(I),END=101,ERR=101) X
         GOTO 51
101   CONTINUE
*
51    KOPTR = 0
      PTR = PTR + I - 1
52    KOPTR = KOPTR + 1
      PTR = PTR + 1
      IF (S(PTR:PTR).EQ.'x') GOTO 52
      KOEF(KOPTR) = KOEF(KOPTR) + X
      IF (PTR.LT.L1) GOTO 53
*
      RETURN
      END
