      SUBROUTINE END(*)
*
C     ******************************************************************
C     *                                                                *
C     *                    S U B R O U T I N E                         *
C     *                                                                *
C     *                           E N D                                *
C     *                                                                *
C     ******************************************************************
C
*DOC             Event-handling and debug routine
**DOC
*INDEX  END   (IN/1): Internal Event-handling and Debug routine
**DOC
**DOC   (1) DESCRIPTION IN DETAIL:
**DOC       This subroutine must be called exactly as often as the
**DOC       routine START. In case of IER<>0 RETURN 1 is executed
**DOC       and (if DLEVEL<8) a message is given on DNRIER.
**DOC       In dependence on DLEVEL additional messages are written
**DOC       on DNROUT.
**DOC       In case of  1<DLEVEL<5  the system time is measured for
**DOC       the statistics in SUMARY.
**DOC       The logging of time takes a lot of CPU-time (factor 1.2-3.0).
**DOC
**DOC       An additional feature of END is activated if you have called
**DOC       TIMLIM before with a positive time limit.
**DOC       If this limit is exceeded END causes RETURN 1 without condition.
**DOC       In this case IER is set to 8001.
**DOC
**DOC       DLEVEL=0:  (Default)
**DOC         If IER.NE.0: Output of nested subroutine calls
**DOC
**DOC       DLEVEL=1:  ("Small trace")
**DOC         If IER.NE.0: Output of nested subroutine calls
**DOC         Logging at every call of END.
**DOC
**DOC       DLEVEL=2:
**DOC         If IER.NE.0: Output of nested subroutine calls
**DOC         Logging of time
**DOC         Logging of number of subroutine calls
**DOC
**DOC      DLEVEL=3:  ("Full trace")
**DOC         If IER.NE.0: Output of nested subroutine calls
**DOC         Logging at every call of END.
**DOC         Logging of time
**DOC         Logging of number of subroutine calls
**DOC
**DOC      DLEVEL=4:
**DOC         If IER.NE.0: Output only of calling routine name
**DOC         Logging of time
**DOC         Logging of number of subroutine calls
**DOC
**DOC      DLEVEL=5:
**DOC         If IER.NE.0: Output of nested subroutine calls
**DOC         Logging of number of subroutine calls
**DOC
**DOC      DLEVEL=6:
**DOC         If IER.NE.0: Output only of calling routine name
**DOC         Logging of number of subroutine calls
**DOC
**DOC      DLEVEL=7:
**DOC         If IER.NE.0: Output only of calling routine name
**DOC
**DOC      DLEVEL=8:
**DOC         no Output at all
**DOC
**DOC   (2) PARAMETER (IN):
**DOC       -
**DOC
**DOC   (3) PARAMETER (OUT):
**DOC       -
**DOC
**DOC   (4) PARAMETER (IN/OUT):
**DOC       -
**DOC
**DOC   (5) MODIFICATIONS OF GLOBAL VARIABLES:
**DOC       ERRFLG = 1   If IER<>0 and ERRFLG has been 0.
**DOC                    (identification of first error level)
**DOC       LVLPTR       LVLPTR  <--  LVLPTR-1 (subroutine level)
**DOC       SUBTIM(.)    Collects the subroutine running time
**DOC                    ( only if  1 < DLEVEL < 5 )
**DOC       IER = 8001   if time limit is exceeded
**DOC
**DOC   (6) SUBROUTINES CALLED:
**DOC       START       GETSUB     TSTSET
**DOC       END         SECOND
**DOC
**DOC   (7) INCLUDE-FILES USED:
**DOC       FIELD
**DOC
**DOC   (8) AUTHOR(S):
**DOC       JS       19.02.87
**DOC
**DOC   (9) MODIFICATIONS:
**DOC       JS       03.06.88  Ausgaben auf englisch
**DOC       JS       22.09.88  DLEVEL = 8
**DOC       JS       14.10.88  Ausgaben auf DNROUT
**DOC       JS/MJ    14.08.89  ERRMSG
**DOC       JS/MJ    15.08.89  New layout of error message
**DOC       JS       08.02.90  Time limit handling
**DOC       JS       20.02.90  "Condition" instead of "Spin off"
**DOC       JS       05.03.90  "KANT message" instead of "Condition" 
**DOC       FS       18.07.90  Different handling for main programs
**DOC       JS       17.06.91  TSTSET
%include 'field.inc'
*
      DOUBLE PRECISION X
      CHARACTER*3 BLANKS,STRLVL
      DATA BLANKS /'   '/
*       
*  external logging
*
      IF (DLEVEL.EQ.1.OR.DLEVEL.EQ.3) THEN
          WRITE(STRLVL,'(I3)') LVLPTR-1
          WRITE(DNROUT,1000) SUBNAM(LVLPTR),((BLANKS),I=2,LVLPTR),STRLVL
1000      FORMAT(' END   ',A6,20A3)
      ENDIF
*
*  time logging
*
      IF (DLEVEL.GT.1.AND.DLEVEL.LT.5) THEN
         CALL SECOND(X)
         CALL GETSUB(SUBNAM(LVLPTR))
         SUBTIM(SUBPTR) = SUBTIM(SUBPTR) + X - SUBTI1(LVLPTR)
      ENDIF
*
*  time limit?
*
      IF(TIMSET.GT.0) THEN
         IF(DLEVEL.LE.1.OR.DLEVEL.GE.5) CALL SECOND(X)
         IF(X-TIMSTT.GT.TIMBND) THEN
            IER = 8001
            ERRMSG = 'KANT time limit exceeded after         seconds'
            WRITE(ERRMSG(32:38),'(I7)') IDNINT(X-TIMSTT)
         ENDIF
      ENDIF
*
*  output for main programs
*
      IF ( SUBNAM(LVLPTR)(1:2).EQ.'MP' ) THEN
         CALL SUMARY
         CALL OUT1MP(10)
      ENDIF
*
*  decrement subroutine level
*
      LVLPTR = LVLPTR - 1
*                                                   
* Setting TSTFLG.
*
      IF (LVLPTR.GE.1) CALL TSTSET (SUBNAM (LVLPTR))
*
*  no error condition?
*
      IF(IER.EQ.0) GOTO 9999
*
*  Event handling
*
      IF (ERRFLG.EQ.0) THEN
         ERRFLG = 1
         IF(DLEVEL.NE.8) THEN 
            IF(INDEX(ERRMSG,'(no error text)').EQ.0) THEN
               WRITE(DNRIER,*) ERRMSG
            ELSE
               WRITE (DNRIER,*) 'KANT message ',IER,' in subroutine ',
     *         SUBNAM(LVLPTR+1),'  (see documentation)'
            ENDIF
            IF (DLEVEL.LT.6.AND.DLEVEL.NE.4 .AND. ERRMSG(1:2).NE.'MP' )
     *         WRITE(DNRIER,1001) (SUBNAM(I),I=1,LVLPTR+1)
1001           FORMAT(' Nested subroutine calls: ',50('  ',A6)) 
            ERRMSG = ' (no error text)'    
         ENDIF
      ENDIF
*
*     IER <-- 0  if the error occurs in a main program
*
      IF ( IERMP.NE.0 ) THEN
         IERMP = 0
         IER   = 0
      ENDIF
*
      RETURN 1
9999  RETURN
      END
