#include "kant.h"
#include "thue.h"

t_logical
thue_baker_davenport WITH_3_ARGS(
                thue,           th,
                t_real,         c4,
                t_real,         c5
)
/*******************************************************************************

Description: 

Calling sequence: 
	
History:

*******************************************************************************/
{
	block_declarations;
 
	t_int		deg, r, precision, anz, anz1, hh1;
        t_real          Q1, h1, factor;
        order           ord;
        dyn_arr_handle  delta, log_delta_r;
        t_handle        R_ord, R, R_thue;
        t_logical       L;

        ord = thue_order(th);
        deg = thue_abs_degree(th);
        r = order_r(ord);
        R_thue = thue_reals(th);

        precision = thue_bd_precision(th)+20;
        if (thue_print_level(th) >= 2)
                printf("Baker: Precision = %d\n", precision);
        order_reals_delete(ord);
        order_reals_set(ord, precision);
        order_reals_create(ord);
        integer_delete(&precision);
        R_ord = order_reals(ord);

        delta = 0; log_delta_r = 0;
        L = thue_lf_init(th, &delta, &log_delta_r);
        
        hh1 = integer_power(10, deg);
        factor = conv_int_to_real(R_ord, hh1);
        integer_delete(&hh1);
	anz = 0;
        anz1 = 0;
        hh1 = integer_power(100, deg);
        Q1 = conv_int_to_real(R_ord, hh1);
        integer_delete(&hh1);
        for (;;)
                {
       		L = thue_bd_step(th, R_ord, delta, log_delta_r, c4, c5, Q1);
                anz1++;
                if (L || anz1 == 5) break;
                h1 = Q1;
                Q1 = real_mult(R_ord, Q1, factor);
                real_delete(&h1);
                }
        real_delete(&factor);
        real_delete(&Q1);
        anz++;
        if (L == FALSE)
	       	printf("1. Reduction failed!,  anz1 = %d\n", anz1);
        if (L != FALSE)
                {
        	for (;;)
                	{
                        anz1 = 0;
		        precision = thue_bd_precision(th);
        		if (thue_print_level(th) >= 2 )
                		printf("Baker: Precision = %d\n", precision);
                        R = real_str_create(precision);
        		factor = conv_double_to_real(R, 42.0);
                        Q1 = conv_double_to_real(R, 10E0);
                        for (;;)
                                {
        			L = thue_bd_step(th, R, delta, log_delta_r, c4, c5, Q1);
                                anz1++;
                                if (L || (anz1 == 5 && anz <=2) || (anz1 == 2 && anz > 2)) break;
                                h1 = Q1;
                                Q1 = real_mult(R, Q1, factor);
                                real_delete(&h1);
                                }
			real_delete(&factor);
			real_delete(&Q1);
                        anz++;
                        if ((!L) && (thue_print_level(th)>=3))
                                {
  		      		printf("%2d. Reduction failed!\n", anz);
                                }
                	if (L == FALSE) break;
                        ring_delete(&R);
        		integer_delete(&precision);
                	}
                ring_delete(&R);
                integer_delete(&precision);
                }

	thue_lf_delete(th, delta, log_delta_r); 
        if (thue_print_level(th)>=2)
                {
        	printf("Reduced upper bound B1 = ");real_write(R_thue, thue_B1(th), 20);puts("");
                }
}
        
