#include "kant.h" 
#include "rel_lattice.h" 
#include "anf_rel_sort.h" 



main()  
/*******************************************************************************
 
AJ Januar 1992
Last modification: -.

 
 
 
Description:
 
	Reads two algebraic number fields and determines the quadratic
	forms over the subfield.

        Input format

         1)  Field 1 
         2)  Subfield
         3)  r_1+r_2  integer bounds 
         4)  Which routines are called (0,1,2)
        
        
	 
	Planned: -.

 
Calling sequence:
 
	-
 
History:
 
	92-01-22 AJ    written
 
*******************************************************************************/
{
	block_declarations;         
         
  	int			i,j, n, l, k, nm, m, int1, sj, tj; 
	int			sub_r1, sub_r2, sub_r1r2, subr;

	char			str[200];

   	t_handle          	R, Z, C;  
	order			ord, ord_sub, ord_rel, ord_h2;   
        anf_elt         	a_elt, a_elt_con, beta_elt, beta_elt_con; 

	t_real			t2_norm, h1, h2, zero, ubound2, loceps, epsi;  
	vector			rel_basis, rel_con;

	anf_rel_sort		sort;

	matrix			mat_h1, trans, inv_trans;

	rel_lattice     	rel_lat;               
        rel_lat_enum_env	rel_env;            
	t_comp			comp_h1, comp;
	int 			lat_flag;

	lattice     	lat, lll_lat;               
        lat_enum_env	env, lll_env;    
        lat_elt         lat_vec;

        /*  definitions for the moving of elements  */

	anf_elt			elt_h1, elt_h2, elt_h3, rel_elt, ord_elt, elt_h4;
	matrix			trans_pow_ord, trans_pow_ord_sub;
	matrix			trans_ord_sub_in_ord, trans_rel_in_ord;
	matrix			trans_ord_to_rel;
	matrix			mat_h2, mat_h3, mat_h4, mat_h5;
	integer_big 		det, trans_ord_to_rel_den, denom;
	integer_small		erg, lauf1, lauf2, lauf3, lauf4, flag;
	vector			rel_norms;
	dyn_arr_handle		store1, store2;
                  

/*** Initialisation  **********************************************************/

	kant_start();
	printf("\n\nspri.x ...... \n\n");

/*** Input loop  **************************************************************/
 
	while ( order_read(&ord) && order_read(&ord_sub) ) 
	{   
          /*** Initialisation of the orders  ***/
             
		order_reals_set(ord, 20);
		order_reals_create(ord);
		order_mult_table_create(ord); 
		nm=  order_abs_degree(ord);  

                R = order_reals(ord);            
		zero= conv_int_to_real(R,0); 
                loceps= real_make(R, 10, -real_dec_prec(R)+2 );  
                epsi= real_make(R, 10, -real_dec_prec(R)+5 );  
		C = comp_create(real_dec_prec(R));
	        Z= m_z_str_incref(structure_z);
            

		order_reals_set(ord_sub, 20);
		order_reals_create(ord_sub);      

		ord_h2= order_lll_reduce(ord_sub);
                order_delete(&ord_sub); 
	        ord_sub= order_incref(ord_h2);
                order_delete(&ord_h2);        

		order_reals_set(ord_sub, 20);
		order_reals_create(ord_sub);
		order_mult_table_create(ord_sub);

		order_reals_set(ord_sub, 20);
		order_reals_create(ord_sub);
		order_mult_table_create(ord_sub);
		n=  order_abs_degree(ord_sub);
		sub_r1=  order_r1(ord_sub);
		sub_r2=  order_r2(ord_sub);
		sub_r1r2=  sub_r1+sub_r2;

		if (nm%n) 
		 {
		  printf("\n\nThe second field is not a subfield!\n\n");
		  printf(  "Terminated.\n\n");  

		  goto input_false;
		 }      
                                      
          /*** Construct a relative  basis  ***/

		m= nm/n;
		rel_basis= vec_new(m);  

		elt_h1= order_primitive_elt(ord);
	        for (i=1; i<=m; i++)      
	          vec_entry(rel_basis,i)= anf_power(ord, elt_h1, i-1);
	        anf_elt_delete(ord, &elt_h1);
	


          /*** Shortest primitive element:                                ***/
          /***                                                            ***/
          /***    beta_elt <---  a shortest prim. element in ord_sub      ***/
          /***                                                            ***/

		beta_elt= order_shortest_primitive_elt(ord_sub);  

                /*** Output of beta_elt           ***/

                beta_elt_con= anf_elt_con(ord_sub, beta_elt);  
               
		if (anf_print_level >=2 )
		 {
		  printf("The conjugates of a shortest primitive");
	  	  printf(" element in the sub_order:\n\n");
                  anf_elt_write(ord_sub,beta_elt); printf("  =  \n");
                  anf_elt_write(ord_sub,beta_elt_con); printf("\n\n");
		 }

                /*** Output of the T_2-norm of beta_elt              ***/

		t2_norm= anf_elt_t2(ord_sub, beta_elt);

		if (anf_print_level >=2 )
		 {
                  printf("T_2-norm of this element:                 "); 		 
                  real_write(R, t2_norm, 20); printf("\n\n\n\n\n\n");
		 }


          /*** Find the representation of beta_elt_con in the integral  ***/
          /*** basis of ord:                                            ***/
          /***                                                          ***/
          /***     a_elt <---  represent. of beta_elt in ord            ***/
          /***                                                          ***/


		if (anf_elt_embed_aj(ord_sub, beta_elt, 0, ord, &a_elt))
 		 {
		  if (anf_print_level >=2 )
		   {
		    printf("Representation of this element in the extention order:\n\n");
		    printf("   ");
                    anf_elt_write(ord,a_elt); printf(" =  ");
                    elt_h1= anf_elt_con(ord, a_elt);
                    anf_elt_write(ord,elt_h1); printf("\n");
		    printf("\nT2-Norm of this element: ");
		    h1= anf_elt_t2(ord, a_elt);
                    real_write(R, h1, 20); 
		    printf("\n\n");
		    real_delete(&h1);                    
		    anf_elt_delete(ord, &elt_h1);
		   }
	   	 }
		else
		 {
		  printf("The second field is not a subfield!\n\n"); 
		  goto  no_sub_order;
		 }




          /*** Find the representation of the powers of beta_elt in ord_sub:  ***/
          /***                                                                ***/
	  /***     trans_pow_ord_sub(*,i) <---  beta_elt^{i-1} in ord_sub     ***/
          /***                                                                ***/
                   
         	trans_pow_ord_sub= mat_new(n,n);
	
 		elt_h1= integer_anf_elt_lift(ord_sub, 1);
                anf_elt_to_mat_order_col(ord_sub, elt_h1, trans_pow_ord_sub, 1);
                anf_elt_to_mat_order_col(ord_sub, beta_elt, trans_pow_ord_sub, 2);
		anf_elt_delete(ord_sub, &elt_h1);

        	elt_h1= anf_elt_incref(beta_elt);
	        for (i=3; i<=n; i++)
		 {                  
		  elt_h2= elt_h1;
		  elt_h1= anf_mult(ord_sub, elt_h1, beta_elt);
		  anf_elt_delete(ord_sub, &elt_h2);
                  anf_elt_to_mat_order_col(ord_sub,elt_h1,trans_pow_ord_sub,i);
		 }
		anf_elt_delete(ord_sub, &elt_h1);  

		if (anf_print_level >=3 )
		 {
		  printf("\n\n\n\ntrans_pow_ord_sub= \n");
                  for (i=1; i<=n; i++)
		   {
                    for (j=1; j<=n; j++)
		      printf(" \t %d", mat_elt(trans_pow_ord_sub, i,j) );
	            printf("\n");
	           }
		  printf("\n \n");
		 }



          /*** Find the representation of the powers of a_elt in ord:         ***/
          /***                                                                ***/
          /***      trans_pow_ord(*,i) <---  a_elt^{i-1} in ord               ***/
          /***                                                                ***/
                   
         	trans_pow_ord= mat_new(nm,n);
	
 		elt_h1= integer_anf_elt_lift(ord, 1);
                anf_elt_to_mat_order_col(ord, elt_h1, trans_pow_ord, 1);
                anf_elt_to_mat_order_col(ord, a_elt, trans_pow_ord, 2);
		anf_elt_delete(ord, &elt_h1);

        	elt_h1= anf_elt_incref(a_elt);
                for (i=3; i<=n; i++)
		 {            
		  elt_h2= elt_h1;
		  elt_h1= anf_mult(ord, elt_h1, a_elt);
		  anf_elt_delete(ord, &elt_h2);
                  anf_elt_to_mat_order_col(ord, elt_h1, trans_pow_ord, i);
		 }
		anf_elt_delete(ord, &elt_h1);


		if (anf_print_level >=3 )
		 {
		  printf("\n\ntrans_pow_ord= \n");
                  for (i=1; i<=nm; i++)
		   {
                    for (j=1; j<=n; j++)
		      printf(" \t %d", mat_elt(trans_pow_ord, i,j) );
	            printf("\n");
	           }
		  printf("\n \n");
		 }

          /*** Find the representation of the basis of ord_sub in ord         ***/
          /***                                                                ***/
          /***   trans_ord_sub_in_ord <--- order_basis_real(ord_sub)          ***/
          /***                             in ord                             ***/
          /***                                                                ***/

                mat_h2= mat_z_to_mat_real(R, trans_pow_ord);
                mat_h3= mat_z_to_mat_real(R, trans_pow_ord_sub);
                mat_h4= mat_ring_inverse(R,mat_h3);
		mat_h5= mat_ring_mult(R, mat_h2, mat_h4);  
	        trans_ord_sub_in_ord= mat_real_to_mat_z(R, mat_h5);

		if (anf_print_level >=3 )
		 {
		  printf("\n\ntrans_ord_sub_in_ord= \n");
                  for (i=1; i<=nm; i++)
		   {
                    for (j=1; j<=n; j++)
		      printf(" \t %d", mat_elt(trans_ord_sub_in_ord, i,j) );
	            printf("\n");
	           }
		  printf("\n \n");
		 }

		mat_delref(R, &mat_h2);
		mat_delref(R, &mat_h3);
		mat_delref(R, &mat_h4);
		mat_delref(R, &mat_h5);
		                                    

          /*** Find the basis of the absolute order defined by the            ***/
          /*** the relative basis in ord:                                     ***/
          /***                                                                ***/
          /***   trans_rel_in_ord <---  relative basis multiplied by the      ***/
          /***                          basis of ord_sub in ord               ***/
          /***                                                                ***/

                                                                   
		trans_rel_in_ord= mat_new(nm, nm);
                for (i=1; i<=m; i++)
		 { 
                  elt_h1= anf_elt_incref(vec_entry(rel_basis,i));
                  for (j=1; j<=n; j++)
		   { 
		    elt_h3= mat_order_col_to_anf_elt(ord, trans_ord_sub_in_ord, j);
		    elt_h2= anf_mult(ord, elt_h1, elt_h3);
                    anf_elt_to_mat_order_col(ord, elt_h2, trans_rel_in_ord, (i-1)*n+j);
	  	    anf_elt_delete(ord, &elt_h2);
	  	    anf_elt_delete(ord, &elt_h3);
		   }
		  anf_elt_delete(ord, &elt_h1);
	         }

		if (anf_print_level >=3 )
		 {
		  printf("\n\ntrans_rel_in_ord= \n");
                  for (i=1; i<=nm; i++)
		   {
                    for (j=1; j<=nm; j++)
		      printf(" \t %d", mat_elt(trans_rel_in_ord, i,j) );
	            printf("\n");
	           }
		  printf("\n \n");
		 }
		 
		det= mat_z_det(Z, trans_rel_in_ord);
		if (anf_print_level >=3 )
		 {
		  printf("\nDeterminant of trans_rel_in_ord: ");
		  integer_write(det);
		  printf("\n \n");
		 }




          /*** Find transformation of the basis of ord to the basis defined   ***/
          /*** by the matrix trans_rel_in_ord                                 ***/
          /***                                                                ***/
          /***   trans_ord_to_rel <--- transformation from ord to the         ***/
          /***                         relative order                         ***/
          /***                                                                ***/
                                                                   
		mat_h4= mat_z_to_mat_real(R, trans_rel_in_ord);
		h1=  conv_int_to_real(R, det); 
		h2= real_inverse(R, h1); 
		real_delete(&h1);
		h1= real_abs(R, h2);
		real_delete(&h2);
		mat_h5= mat_ring_scalar_right_mult(R,mat_h4,h1);
		mat_delref(R, &mat_h4);
		real_delete(&h1);
		mat_h4= mat_ring_inverse(R, mat_h5);

	        trans_ord_to_rel= mat_real_to_mat_z(R, mat_h4);  
		trans_ord_to_rel_den= integer_abs(det);
		mat_delref(R, &mat_h4);
		mat_delref(R, &mat_h5);        


		mat_h4= mat_ring_mult(Z, trans_ord_to_rel, trans_rel_in_ord);

		if (anf_print_level >=3 )
		 {
		  printf("\n\ntrans_ord_to_rel= \n");
                  for (i=1; i<=nm; i++)
		   {
                    for (j=1; j<=nm; j++)
		      printf(" \t %d", mat_elt(trans_ord_to_rel, i,j) );
	            printf("\n");
	           }
		  printf("\n \n");
		 }
		 
		det= mat_z_det(Z, trans_rel_in_ord);
		if (anf_print_level >=3 )
		 {
		  printf("\nDenominator of trans_ord_to_rel: ");
		  integer_write(trans_ord_to_rel_den);
		  printf("\n \n");
		 }                         

		if (anf_print_level >=3 )
		 {
		  printf("\n\nInverse test of trans_ord_to_rel and trans_rel_in_ord: \n");
                  for (i=1; i<=nm; i++)
		   {
                    for (j=1; j<=nm; j++)
		      printf(" \t %d", mat_elt(mat_h4, i,j) );
	            printf("\n");
	           }
		  printf("\n \n");
		 }
		mat_delref(Z, &mat_h4);


        
		
          /*** The order of relative basis multiplied by ord_sub basis  ***/

		ord_rel= order_trans_down(ord, trans_rel_in_ord);
                                                                 

          /*** Find the right order of the conjugates of ord over       ***/
          /***  ord_sub                                                 ***/
		 
                a_elt_con= anf_elt_con(ord, a_elt);  

		sort= anf_con_sort_sub(ord, ord_sub, a_elt_con, beta_elt_con); 

		if (anf_print_level >=2 )
		 {
                  printf("\n\n\n\nThe conjugates of this element in the suborder:\n");
                  anf_elt_write(ord_sub,beta_elt_con); printf("\n\n");
                  printf("\nThe conjugates of this element in the extention order:\n");
                  anf_elt_write(ord,a_elt_con); printf("\n\n");
  
                  printf("\nThe right order of the conjugates over the suborder:\n\n");
		  printf("   ");
		  for( j=1; j<= n; j++)   
	           {
		    for( i=1; i<= m; i++) 
		      printf("  %d ", anf_rel_sort_ordering_elt(sort,j,i));
	            printf("     ");
	           }
		  printf("\n");

	 	  printf("\n\n\nF^(j)'s without signature: %d \n", 2*order_r2(ord_sub));
	 	  printf("\n\n\nSignatures over F^(j): \n");
                  for (j= 1;j<= order_r1(ord_sub); j++) 
	  	   {
	 	    sj= anf_rel_sort_real_zeroes_elt(sort,j);
		    tj= anf_rel_sort_comp_zeroes_elt(sort,j);
		    printf("\nF^(%d):  s= %d,  t= %d ", j, sj, tj); 
		   }
                  printf("\n\n");

                  printf("\n\nThe sorted conjugates over the suborder:\n\n");  
		  for( j=1; j<= n; j++) 
	           {
		    for( i=1; i<=m; i++) 
		     {       
                      int1= anf_rel_sort_ordering_elt(sort,j,i);
		      comp_h1= anf_elt_ith_con(ord, a_elt_con, int1 );
		      comp_write_aj(C, comp_h1, 20);
		      printf("\n");
                      comp_elt_delete(C, &comp_h1);
		     }  
	 	    printf("\n");
	           }
		  printf("\n\n");                                             

		 }  /* endif: anf_print_level */

          /*** Computation of the conjugated relativ integral bases     ***/

		rel_con= rel_bases_con(ord, ord_sub, rel_basis, sort);
                
		if (anf_print_level >=2 )
		 {
                  printf("\n\n\nOutput of the conjugated relativ integral bases:\n\n");
		  for( i=1; i<= sub_r1r2; i++) 
		   {
	  	    printf("\n(i= %d):\n", i);
		    mat_comp_write_aj(C, vec_entry(rel_con,i), 20);
		    printf("\n\n");
		   }
		  printf("\n\n");     
		 }


          /*** Calculation of the relative lattices                    ***/


		rel_lat= rel_lat_create();   
		rel_lat_rank(rel_lat)= m;
		rel_lat_number_con(rel_lat)= n;
		rel_env= rel_lat_enum_create(rel_lat);

		rel_lat_coef_ord(rel_lat)= order_incref(ord_sub);
                rel_lat_basis_ring(rel_lat)= ring_incref(C);  

		rel_lat_basis(rel_lat)= vec_new(sub_r1r2);
		for (i=1; i<=sub_r1r2; i++)
                  rel_lat_basis_con(rel_lat,i)= mat_incref(vec_entry(rel_con,i));  

		rel_lat_gram_calc(rel_lat);
		rel_lat_chol_calc(rel_lat);
                  

		if (anf_print_level >=2 )
		 {
		  for (i=1; i<=sub_r1r2; i++)
		   {
	  	    printf("\nCholesky-matrix (i= %d):\n", i);
	 	    mat_comp_write_aj(rel_lat_chol_ring(rel_lat), 
		                      rel_lat_chol_con(rel_lat,i), 20); 
		    printf("\n\n\n");
		   }      
		 }
                    
		rel_lat_disc_ring(rel_lat)= 
		           ring_incref(rel_lat_chol_ring(rel_lat));
		mat_h1= rel_lat_chol_con(rel_lat,1);
		rel_lat_disc(rel_lat)= comp_incref(mat_elt(mat_h1,1,1));
		for (i=2; i<=m; i++)
		 {
		  comp_h1= rel_lat_disc(rel_lat);
		  rel_lat_disc(rel_lat)= 
		       comp_mult( rel_lat_chol_ring(rel_lat),
		                  comp_h1, mat_elt(mat_h1,i,i) );
		  comp_elt_delete(C, &comp_h1);
		 }               

		if (anf_print_level >=2 )
		 {
		  printf("\nRelative discriminant:  ");
                  comp_write(rel_lat_disc_ring(rel_lat), rel_lat_disc(rel_lat), 20);
		  printf("\n\n");    
		 }


	        /***  Upper bounds  ************/


		store1= dyn_arr_alloc(0);
		store2= dyn_arr_alloc(0);

	        lauf1= 0;
	        lauf2= 0;


                /*** Read the bounds for the enumeration (not the conjugate complex)  ***/

                rel_lat_enum_ubounds(rel_env)= vec_new(sub_r1r2);
		h1= real_incref(zero);
                for (i=1; i<= sub_r1; i++)
		 {
		  scanf("%d", &int1); 
		  gets(str); 
		  rel_lat_enum_ubounds_con(rel_env,i)= conv_int_to_real(R, int1);
		  h2= h1;
		  h1= real_add(R, h2, rel_lat_enum_ubounds_con(rel_env,i) );
		  real_delete(&h2);
		 }
                for (i=sub_r1+1; i<= sub_r1r2; i++)
		 {
		  scanf("%d", &int1); 
		  gets(str); 
		  rel_lat_enum_ubounds_con(rel_env,i)= conv_int_to_real(R, int1);
		  h2= h1;
		  h1= real_add(R, h2, rel_lat_enum_ubounds_con(rel_env,i) );
		  real_delete(&h2);
		  h2= h1;
		  h1= real_add(R, h2, rel_lat_enum_ubounds_con(rel_env,i) );
		  real_delete(&h2);
		 }

               
		ubound2= real_incref(h1);
		real_delete(&h1);


                /*** Which subroutine: both (0) or rel_lat_enum (1) or    ***/
                /***                   lat_enum (2)                       ***/ 
                
		scanf("%d", &subr); 

		if ( (subr<0) || (subr>2) )    
		  error_internal("spri.c: subr has a false value!");

		if ( (subr==0) )    
                  printf("\nBoth routines are called! \n");
		if ( (subr==1) )    
                  printf("\nOnly rel_lat_enum is called! \n");
		if ( (subr==2) )    
                  printf("\nonly lat_enum is called! \n");


		if (subr>1)  goto label_lat_enum;


                /*** rel_lat_enum:                                        ***/
		
		rel_lat_enum_status_set_new(rel_env);
		rel_lat_enum_request_set_next(rel_env);


		printf("\n\nUpper bounds for the conjugated T2-norms:  \n");
		mat_real_write_aj(R, rel_lat_enum_ubounds(rel_env) , 20);
		printf("\n \n");


		while(rel_lat_enum(rel_lat, rel_env))
	         {       
		  if (anf_print_level >= 1)
		   {
	            printf("\nrel_lat_enum_counter= \t %d\n", rel_lat_enum_counter(rel_env));
     		    printf(      "act_coefs:           \t ");
     		    for (i=1;i<=m;i++) 
     	             {
     		      anf_elt_write(ord_sub, rel_lat_enum_act_coefs_entry(rel_env,i));
		      if (i<m) printf(" ,      "); 
     	             }

     		    printf("\nlength: "); 
	 	    h1= real_incref(zero);
     		    for (i=1;i<=sub_r1;i++) 
     	             {                                                            
		      h2= h1;
		      h1= real_add(R,h2,rel_lat_enum_act_lengths_con(rel_env,i));
	              real_delete(&h2);
     		      real_write_aj(R, rel_lat_enum_act_lengths_con(rel_env,i), 15);
		      if (i!=sub_r1r2)  printf(" + ");
     	             }                         
     		    for (i=sub_r1+1;i<=sub_r1r2;i++) 
     	             {                                                            
		      h2= h1;
		      h1= real_add(R,h2,rel_lat_enum_act_lengths_con(rel_env,i));
	              real_delete(&h2);
		      h2= h1;
		      h1= real_add(R,h2,rel_lat_enum_act_lengths_con(rel_env,i));
	              real_delete(&h2);
		      printf("  2*");
     		      real_write_aj(R, rel_lat_enum_act_lengths_con(rel_env,i), 15);
		      if (i!=sub_r1r2)  printf(" + ");
     	             }                         


     		    printf(" =  "); 
      	            real_write_aj(R, h1, 15);
		    printf("\n");
	            real_delete(&h1);   
                   }

		  anf_elt_alloc(rel_elt, nm);
		  anf_elt_den(rel_elt) = 1;
		  for(i=1;i<=m;i++) 
		   {
		    for (j=1; j<=n; j++)
		     {	
		      elt_h1= rel_lat_enum_act_coefs_entry(rel_env,i);
		      anf_elt_coef(rel_elt,(i-1)*n+j) = 
		                integer_incref(anf_elt_coef(elt_h1,j));
		     }
		   }


		  lauf1= rel_lat_enum_counter(rel_env);

                  dyn_arr_assure_space(store1, lauf1,1);
		  dyn_arr_element(store1,lauf1-1)= anf_elt_incref(rel_elt);
                            
 		  if (anf_print_level >= 1)
		   {  
		    printf("\nord_elt=  ");
     		    anf_elt_write(ord_rel, rel_elt);
     		    printf("\nlength in ord_rel: "); 
		    h1= anf_elt_t2(ord_rel, rel_elt); 
     		    real_write_aj(R, h1, 15);
		    printf("\n\n");
		    real_delete(&h1);
	  	   }

		  anf_elt_delete(ord_rel, &rel_elt);

	 	 }


          /*** Control calculation with the global lattices               ***/
                     

		if (subr==1)  goto output;


label_lat_enum:

        	order_lat(ord_rel, &lat, &env);         
	        
                if (0)
                 {
                  lll_lat = lat_lll_reduce(lat,&trans,&inv_trans);
                  lll_env = lat_enum_create(lll_lat);

                  lat_enum_status_set_new   (lll_env);
                  lat_enum_request_set_next (lll_env);
                 }  
                else     
                 {
                  order_lat(ord_rel, &lll_lat, &lll_env);          
                  trans= mat_ring_create_id(Z,  nm);
                  inv_trans= mat_incref(trans);
                 }

                printf("\nlll transf.: \n\n");
                for (i=1;i<=nm;i++) 
                 {
                  for (j=1;j<=nm;j++) 
                   {
                    printf(" %d  ", mat_elt(trans, i,j) );
                   }                                    
                  printf("\n");
                 }          
                printf("\n \n");
            
/*		lat_enum_ubound(lll_env) = real_incref(ubound2);*/

		lat_enum_ubound(lll_env) = real_add(R, epsi, ubound2);

		lat_enum_status_set_new(lll_env);
		lat_enum_request_set_next(lll_env);
                lat_enum_strategy_set_up  (lll_env);          
                                                
		printf("\n\n\n\n\nUpper bound for lat_enum::\n\n");
		real_write_aj(R, ubound2, 20);
		printf("\n \n");        
           
		lauf4= 0;

		while(lat_enum(lll_lat, lll_env))
	         {       
                  lat_vec  = lat_elt_move (lll_lat,lat_enum_act_coefs(lll_env),trans);

                  ord_elt= lat_elt_to_anf_elt(lat,lat_vec, ord_rel); 

                  lat_elt_delete(lat, &lat_vec);

                  rel_norms= anf_elt_rel_t2(ord_rel, ord_sub, ord_elt, sort);  

                  /* Has the solution the right relative norms  */

		  erg= 0;
     		  for (i=1;i<=sub_r1r2;i++) 
     	           {                                                            
     		    if (real_compare_eps(R,vec_entry(rel_norms,i), 
	                             rel_lat_enum_ubounds_con(rel_env,i),loceps)==1)
		     {
		      erg= 1;
		     }
     	           }                         

	 	  if ( erg )   
		    {  
		     lat_enum_counter(lll_env)= lat_enum_counter(lll_env)-1;
		     lauf4= lauf4 + 1;
		    }
		   else
		    {
		     if (anf_print_level >= 1)
		      {
	               printf("\nlat_enum_counter= \t %d\n", lat_enum_counter(lll_env));
		       printf("\nlat_elt=    ");
  	  	       for(i=1;i<=lat_rank(lat);i++)
	      	       printf("%d  ",lat_elt_coef(lat_enum_act_coefs(lll_env),i));		
	   	       real_write(lat_chol_ring(lat),lat_enum_act_length(lll_env),20);
	 	       printf("\n");
		      }

		     lauf2= lat_enum_counter(lll_env);

                     dyn_arr_assure_space(store2, lauf2,1);
		     dyn_arr_element(store2,lauf2-1)= anf_elt_incref(ord_elt);


		     if (anf_print_level >= 1)
		      {
     		       printf("rel. length: "); 
	 	       h1= real_incref(zero);
     		       for (i=1;i<=sub_r1;i++) 
     	                {                                                            
		         h2= h1;
		         h1= real_add(R,h2,vec_entry(rel_norms,i));
	                 real_delete(&h2);
     		         real_write_aj(R, vec_entry(rel_norms,i), 15);
		         if (i!=sub_r1r2)  printf(" + ");
     	                }                         
     		       for (i=sub_r1+1;i<=sub_r1r2;i++) 
     	                {                                                            
		         h2= h1;
		         h1= real_add(R,h2,vec_entry(rel_norms,i));
	                 real_delete(&h2);
		         h2= h1;
		         h1= real_add(R,h2,vec_entry(rel_norms,i));
	                 real_delete(&h2);
			 printf("  2*");
     		         real_write_aj(R, vec_entry(rel_norms,i), 15);
		         if (i!=sub_r1r2)  printf(" + ");
     	                }                         
     		       printf(" =  "); 
      	               real_write_aj(R, h1, 15);
		       printf("\n");
	               real_delete(&h1);   
		      }
                    
	 	    }                                      
		  anf_elt_delete(ord_rel, &ord_elt);
	          vec_delete(R, &rel_norms);

	 	 }   

		lat_enum_delete(lat,&env);
		lat_enum_delete(lll_lat,&lll_env);
		lat_delete(&lat);
		lat_delete(&lll_lat);

                mat_delref(Z, &trans);
                mat_delref(Z, &inv_trans);

                                                                           


          /*** Test if all vectors are found    ***/ 
                  

	       if (subr!=0)  goto output;              

	       printf("\n\n\nVectors not found: \n\n");
                             
	       lauf3= 0;
	       for (i=1;i<=lauf2;i++) 
	        {
        	 flag= 0;
	         for (j=1;j<=lauf1;j++) 
                  {
                   elt_h1= anf_negate(ord_rel, dyn_arr_element(store1,j-1));

                   if ( anf_elt_equal(ord_rel, dyn_arr_element(store1,j-1), 
		                               dyn_arr_element(store2,i-1)) ||
                        anf_elt_equal(ord_rel, elt_h1, dyn_arr_element(store2,i-1)) )
		    {
		     flag=1;
		     anf_elt_delete(ord_rel, &elt_h1);
	             break;
		    }
		   anf_elt_delete(ord_rel, &elt_h1);
	          }        

		 if (flag==0)
		  {     
		   lauf3= lauf3 + 1;
		   printf("ord_elt=   ");
     		   anf_elt_write(ord_rel, dyn_arr_element(store2,i-1));
		   printf("\n"); 

     		   printf("rel. length: "); 
		   rel_norms= anf_elt_rel_t2(ord_rel, ord_sub,
		                             dyn_arr_element(store2,i-1), sort); 
	 	   h1= real_incref(zero);
     		   for (l=1;l<=n;l++) 
     	            {                                                            
		     h2= h1;
		     h1= real_add(R,h2,vec_entry(rel_norms,l));
	             real_delete(&h2);
     		     real_write_aj(R, vec_entry(rel_norms,l), 15);
		     if (l!=n)  printf(" + ");
     	            }                         
     		   printf(" =  "); 
      	           real_write_aj(R, h1, 15);
		   printf("\n\n");
	           real_delete(&h1);   
	           vec_delete(R, &rel_norms);
		  }
	        }  

output:

               if (subr <= 1)
                {
                 printf("\n\n\n");
	         printf("Number of vectors of rel_lat_enum:              %d \n", lauf1);
                }

               if ( (subr==0)|| (subr==2) )
                {
	         printf("Number of vectors of     lat_enum:              %d \n\n", lauf2);
  	         printf("Number of false vectors in lat_enum:            %d \n\n", lauf4);
  	         printf("Number of false and right vectors in lat_enum:  %d \n\n", lauf4+lauf2);
                }
                 
               if ( subr == 0 )
                {
	         printf("Difference                       :              %d \n\n", lauf2-lauf1);
	         printf("Number of vectors not found by rel_lat_enum:    %d \n\n", lauf3);
                }

               printf("\n \n");


          /*** End of while loop: delete storage  ***/ 
	
deleting_storage:

		anf_rel_sort_delete(&sort); 

		for (i=1; i<=m; i++)
		 {
		  anf_elt_delete(ord, &vec_entry(rel_basis,i));
		  vec_entry(rel_basis,i)= 0;
	         }
		vec_delete(Z, &rel_basis);   

		for (i=1; i<=sub_r1r2; i++)
		 {
		  mat_delref(C, &vec_entry(rel_con,i));
		  vec_entry(rel_con,i)= 0;
		 }
		vec_delete(Z, &rel_con);      


no_sub_order:	anf_elt_delete (ord,&a_elt);
		anf_elt_delete (ord,&a_elt_con);  

		anf_elt_delete (ord_sub,&beta_elt);	 
		anf_elt_delete (ord_sub,&beta_elt_con); 
 
		real_delete(&t2_norm);  

		rel_lat_enum_delete(rel_lat, &rel_env);
		rel_lat_delete(&rel_lat);

		mat_delref(Z, &trans_pow_ord);
		mat_delref(Z, &trans_pow_ord_sub);
		mat_delref(Z, &trans_ord_sub_in_ord);
		mat_delref(Z, &trans_rel_in_ord);
		mat_delref(Z, &trans_ord_to_rel);
		integer_delref(trans_ord_to_rel_den);
 		order_delete(&ord_rel);
		real_delete(&ubound2);  

		for (i=1; i<=lauf1; i++)
		 {
		  anf_elt_delete(ord, &dyn_arr_element(store1,i-1));
		  dyn_arr_element(store1,i-1)= 0;
	         }
		dyn_arr_delete(&store1);   
 
		for (i=1; i<=lauf2; i++)
		 {
		  anf_elt_delete(ord, &dyn_arr_element(store2,i-1));
		  dyn_arr_element(store2,i-1)= 0;
	         }
		dyn_arr_delete(&store2);   


input_false:	real_delete(&zero);
		real_delete(&loceps);
		real_delete(&epsi);
		order_delete(&ord);
 		order_delete(&ord_sub); 

		ring_delete(&C);
		ring_delete(&Z);
                          
	} 

/*** End  *********************************************************************/
    

}
