/******************************************************************************
  rel_lat_enum_delete.c                                                           
******************************************************************************/
#include "kant.h"
#include "rel_lattice.h"  


t_void
rel_lat_enum_delete WITH_2_ARGS (
	rel_lattice,		rel_lat,
	rel_lat_enum_env*,	rel_env
)

/*******************************************************************************
 
Description:
 

 
Calling sequence:
 

 
History:
                                   
	92-03-12 AJ	written
 
*******************************************************************************/
{
	block_declarations;

	integer_small	i, rtype, r1, r2, r1r2;  
	integer_small	j,l,k;  
	t_handle  	reals, Z;


	if (block_ref_count(*rel_env) == 1)
	 {               
	  Z= m_z_str_incref(structure_z);
	  
	  r1= order_r1(rel_lat_coef_ord(rel_lat)); 
	  r2= order_r2(rel_lat_coef_ord(rel_lat)); 
	  r1r2= r1+r2;

          if (rel_lat_enum_level_flag(*rel_env)!= MEM_NH)
	      vec_delete(Z,&rel_lat_enum_level_flag(*rel_env));

          if (rel_lat_enum_termination_flag(*rel_env)!= MEM_NH)
	      vec_delete(Z,&rel_lat_enum_termination_flag(*rel_env));

          if (rel_lat_enum_act_coefs(*rel_env)!= MEM_NH)
	      rel_lat_elt_delete(rel_lat,&rel_lat_enum_act_coefs(*rel_env));

          if (rel_lat_enum_act_coefs_con(*rel_env)!= MEM_NH)
	      rel_lat_elt_delete(rel_lat,&rel_lat_enum_act_coefs_con(*rel_env));

	  if (rel_lat_chol_known(rel_lat))
	   {

	    reals= comp_real_field(rel_lat_chol_ring(rel_lat));

	    if (rel_lat_enum_ubounds(*rel_env)!= MEM_NH)
	     {
	      for(i=1;i<= r1r2;i++)     
	       {                                                       
	        if (rel_lat_enum_ubounds_con(*rel_env,i)!= MEM_NH)
	           real_delete(&rel_lat_enum_ubounds_con(*rel_env,i));
                rel_lat_enum_ubounds_con(*rel_env,i)= 0;
	       }
	      vec_delete(Z,&rel_lat_enum_ubounds(*rel_env));
	     }
                             

	    if (rel_lat_enum_act_lengths(*rel_env)!= MEM_NH)
	     {
	      for(i=1;i<= r1r2;i++)     
	       {                                                       
	        if (rel_lat_enum_act_lengths_con(*rel_env,i)!= MEM_NH)
	           real_delete(&rel_lat_enum_act_lengths_con(*rel_env,i));
                rel_lat_enum_act_lengths_con(*rel_env,i)= 0;
	       }
	      vec_delete(Z,&rel_lat_enum_act_lengths(*rel_env));
	     }


	    if (rel_lat_enum_part_sums(*rel_env)!= MEM_NH)
	     {
	      for(i=1;i<= r1r2;i++)     
	       {
		if (rel_lat_enum_part_sums_con(*rel_env,i)!= MEM_NH)
	           vec_delete(rel_lat_chol_ring(rel_lat),
	                      &rel_lat_enum_part_sums_con(*rel_env,i));
	        rel_lat_enum_part_sums_con(*rel_env,i)= 0;
	       }
	      vec_delete(Z,&rel_lat_enum_part_sums(*rel_env));
	     }                           

	    if (rel_lat_enum_tmp_bounds(*rel_env)!= MEM_NH)
	     {
	      for(i=1;i<= r1r2;i++)     
	       {                                                       
	        if (rel_lat_enum_tmp_bounds_con(*rel_env,i)!= MEM_NH)
	           vec_delete(reals,&rel_lat_enum_tmp_bounds_con(*rel_env,i));
                rel_lat_enum_tmp_bounds_con(*rel_env,i)= 0;
	       }
	      vec_delete(Z,&rel_lat_enum_tmp_bounds(*rel_env));
	     }

     
	    if (rel_lat_enum_coefs_env(*rel_env)!= MEM_NH)
	     {
	      for(i=1;i<=rel_lat_rank(rel_lat);i++)     
	       {                                                       
	        if (rel_lat_enum_coefs_env_level(*rel_env,i)!= MEM_NH)
	           lat_enum_delete(rel_lat_enum_coefs_lat_level(*rel_env,i),
		                   &rel_lat_enum_coefs_env_level(*rel_env,i));
                rel_lat_enum_coefs_env_level(*rel_env,i)= 0;
	       }
	      vec_delete(Z,&rel_lat_enum_coefs_env(*rel_env));
	     }


	    if (rel_lat_enum_coefs_lat(*rel_env)!= MEM_NH)
	     {
	      for(i=1;i<=rel_lat_rank(rel_lat);i++)     
	       {                                                       
	        if (rel_lat_enum_coefs_lat_level(*rel_env,i)!= MEM_NH)
	           lat_delete(&rel_lat_enum_coefs_lat_level(*rel_env,i));
                rel_lat_enum_coefs_lat_level(*rel_env,i)= 0;
	       }
	      vec_delete(Z,&rel_lat_enum_coefs_lat(*rel_env));
	     }

	   }

      	    ring_delete(&Z);
 	 }

	block_decref_delete(*rel_env);

	*rel_env = MEM_NH;

}
