#include "defs.h"
#include "zm.e"
#include "z.e"
#include "ring.h"
#include "error.e"
#include "structure.e"
#include "globals.e"
#ifndef KANT
#include "principal_ideal.e"
#include "vararg.e"
#include "alg.e"
#endif /* KANT */

static t_logical zm_str_create_arg P_((t_int,integer_big,integer_big));
static t_handle zm_str_create_hard P_((integer_big));

private t_logical zm_str_create_arg( n, m1, m2 )
t_int n;
integer_big m1, m2;
{
	switch( n )
	{
		case 0:
			return integer_eq( m1, m2 );
			break;
		default:
			DIE();
	}
	return FALSE;
}

private t_handle zm_str_create_hard( m )
integer_big 	m;
{
	block_declarations;
	t_handle r;

	r = structure_alloc( sizeof( t_zm_table ), 0, 1, REP_ZM, TRUE );
	ring_put_type( r, RING_ZM );

	zm_modulus(r) = integer_incref(m);
	zm_factors(r) = NH;

	return r;
}

public t_handle zm_str_create( m, varblock )
integer_big	m; 
t_handle	varblock;
{
	block_declarations;
	t_eseq		fseq;
	t_handle	res;
	integer_big	check;
	
	if (integer_compare(m, 1) <= 0)
	{
		error_runtime(ERR_ARG_LT_INT, 1, m, 2);
	}

#ifndef KANT
	res =  structure_create( REP_ZM, zm_str_create_hard, 
		zm_str_create_arg, 1, m );
#else /* KANT */
	res = zm_str_create_hard(m);
#endif /* KANT */

#ifndef KANT
	/* if given a factorisation check it */

	if (vararg_lhs_to_rhs(varblock, VARARG_LHS_FACTORIZATION, &fseq))
	{
		check = z_int(fseq);
		if (integer_eq(m, check))
		{
			integer_delref(check);
			/* remember the factorisation */
			if( IS_NH(zm_factors(res)) )
			{
				zm_factors(res) = faclst_seq_to_faclst(fseq);
			}
		}
		else
		{
			integer_delref(check);
			m_zm_str_delete(res);
			error_runtime(ERR_INCORRECT_FACTORISATION);
		}
	}
	ring_set_is_quotient_true(res);
	m_ring_ideal(res) = principal_ideal_str_create(structure_z, m);
	m_ring_free_ring(res) = m_z_str_incref(structure_z);
#endif /* KANT */

	return res;
}
