
/*
 *	Useful gdb,dbx stuff
 */

#include "defs.h"

#ifndef KANT
#include "gf.e"
#endif

int
f_block_type WITH_1_ARG(
	t_handle,	h
)
{
	return block_type( h );
}

int
f_block_ref_count WITH_1_ARG(
	t_handle,	h
)
{
	return block_ref_count( h );
}

/*
 *	Dump a block
 */
void
f_dump WITH_1_ARG(
	t_handle,		h
) 
/*
** Dumps a block/stack h.
*/
{
	t_int	j;
	t_int	sz;

	if( !VH( h ) )
		error_internal( "bad t_handle to f_dump()" );
	if( block_is_stack( h ) )
		prstk( h, 0, 0, 1 );
	else
	{
		sz = mem_words(h);
		cay_print( "Block with t_handle %l,   size %l,   block type %l,   ref count %l", (int) h, (int) sz, (int) block_type(h), (int) block_ref_count(h) );
		for (j = 0; j < sz; j++)
		{
		    if (j % 5 == 0)
			cay_print("\n");
		    cay_print("%l    ", ((int *) mem_access(h))[j]);
		}
		cay_print("\n");
	}
	dmplin();
}

#ifndef KANT

t_gf_table *ma_gf(K)
t_handle	K;
{
	return (t_gf_table *)mem_access(K);
}

#endif
