#include "kant.h"
#include "ring.h"
#include "v3glue.e"
#include "anf.e"


t_pfh ring_comparison(h)
t_handle	h;
{
        switch (m_ring_type(h))
        {
        case RING_Z:
                return v3glue_z_compare;
        case RING_Q:
                return v3glue_q_compare;
        case RING_R:
                return v3glue_real_compare;
        default:
                return NP;
        }
}

t_pfh ring_multiplication(h)  
t_handle	h;
{
	switch (m_ring_type(h))
	{
	case RING_Z:
		return v3glue_z_mult;
	case RING_Q:
		return v3glue_q_mult;
	case RING_ZM:
		return v3glue_zm_mult;
	case RING_ORDER:
		return anf_elt_mult;
	case RING_C:
		return v3glue_comp_mult;
	case RING_R:
		return v3glue_real_mult;
	case RING_POLY:
		return v3glue_poly_mult;
	default:
		return NP;
	}
}
t_pfh ring_inversion(h) 
t_handle	h;
{ 
        switch (m_ring_type(h)) 
        { 
        case RING_Z: 
                return NP; 
        case RING_Q:   
                return v3glue_q_inv;
        case RING_ZM: 
                return v3glue_zm_inv;
        case RING_ORDER:
                return anf_elt_inverse;
        case RING_C: 
                return v3glue_comp_inv;
        case RING_R: 
                return v3glue_real_inv;
        case RING_POLY: 
                return NP;
        default: 
                return NP; 
        }
} 

t_pfh ring_slash_op(h)
t_handle	h;
{ 
        switch (m_ring_type(h)) 
        { 
        case RING_Z: 
                return NP; 
        case RING_Q:   
                return v3glue_q_slash_op;
        case RING_ZM: 
                return v3glue_zm_slash_op;
        case RING_ORDER:
                return anf_elt_div;
        case RING_C: 
                return v3glue_comp_slash_op;
        case RING_R: 
                return v3glue_real_slash_op;
        case RING_POLY: 
                return NP;
        default: 
                return NP; 
        }
}


t_pfh ring_addition(h) 
t_handle	h;
{ 
        switch (m_ring_type(h)) 
        { 
        case RING_Z: 
                return v3glue_z_add; 
        case RING_Q:   
                return v3glue_q_add;
        case RING_ZM: 
                return v3glue_zm_add;
        case RING_ORDER:
                return anf_elt_add;
        case RING_C: 
                return v3glue_comp_add;
        case RING_R: 
                return v3glue_real_add;
        case RING_POLY: 
                return v3glue_poly_add;
        default: 
                return NP; 
        }
}
t_pfh ring_subtraction(h)   
t_handle	h;
{ 
        switch (m_ring_type(h)) 
        { 
        case RING_Z: 
                return v3glue_z_subtract; 
        case RING_Q:   
                return v3glue_q_subtract;
        case RING_ZM: 
                return v3glue_zm_subtract;
        case RING_ORDER:
                return anf_elt_subtract;
        case RING_C: 
                return v3glue_comp_subtract;
        case RING_R: 
                return v3glue_real_subtract;
        case RING_POLY: 
                return v3glue_poly_subtract;
        default: 
                return NP; 
        }
}
t_pfh ring_negation(h)        
t_handle	h;
{ 
        switch (m_ring_type(h)) 
        { 
        case RING_Z: 
                return v3glue_z_negate; 
        case RING_Q:   
                return v3glue_q_negate;
        case RING_ZM: 
                return v3glue_zm_negate;
        case RING_ORDER:
                return anf_elt_negate;
        case RING_C: 
                return v3glue_comp_negate;
        case RING_R: 
                return v3glue_real_negate;
        case RING_POLY: 
                return v3glue_poly_negate;
        default: 
                return NP; 
        }
}
t_pfh ring_exponentiation(h) 
t_handle	h;
{ 
        switch (m_ring_type(h)) 
        { 
        case RING_Z: 
                return v3glue_z_power; 
        case RING_Q:   
                return v3glue_q_power;
        case RING_ZM: 
                return v3glue_zm_power;
        case RING_ORDER:
                return anf_elt_power;
        case RING_C: 
                return v3glue_comp_power;
        case RING_R: 
                return v3glue_real_power;
        case RING_POLY: 
                return v3glue_poly_power;
        default: 
                return NP; 
        }
}
t_pfh ring_equality(h) 
t_handle	h;
{ 
        switch (m_ring_type(h)) 
        { 
        case RING_Z: 
                return v3glue_z_eq; 
        case RING_Q:   
                return v3glue_q_eq;
        case RING_ZM: 
                return v3glue_zm_eq;
        case RING_ORDER:
                return anf_elt_equal;
        case RING_C: 
                return v3glue_comp_eq;
        case RING_R: 
                return v3glue_real_eq;
        case RING_POLY: 
                return v3glue_poly_eq;
        default: 
                return NP; 
        }
}
t_pfh ring_one_test(h)  
t_handle	h;
{ 
        switch (m_ring_type(h)) 
        { 
        case RING_Z: 
                return v3glue_z_is_one; 
        case RING_Q:   
                return v3glue_q_is_one;
        case RING_ZM: 
                return v3glue_zm_is_one;
        case RING_ORDER:
                return anf_elt_is_one;
        case RING_C: 
                return v3glue_comp_is_one;
        case RING_R: 
                return v3glue_real_is_one;
        case RING_POLY: 
                return v3glue_poly_is_one;
        default: 
                return NP; 
        }
}
t_pfh ring_zero_test(h)    
t_handle	h;
{ 
        switch (m_ring_type(h)) 
        { 
        case RING_Z: 
                return v3glue_z_is_zero; 
        case RING_Q:   
                return v3glue_q_is_zero;
        case RING_ZM: 
                return v3glue_zm_is_zero;
        case RING_ORDER:
                return anf_elt_is_zero;
        case RING_C: 
                return v3glue_comp_is_zero;
        case RING_R: 
                return v3glue_real_is_zero;
        case RING_POLY: 
                return v3glue_poly_is_zero;
        default: 
                return NP; 
        }
}
t_pfh ring_minus_one_test(h)
t_handle	h;
{ 
        switch (m_ring_type(h)) 
        { 
        case RING_Z: 
                return v3glue_z_is_minus_one; 
        case RING_Q:   
                return v3glue_q_is_minus_one;
        case RING_ZM: 
                return v3glue_zm_is_minus_one;
        case RING_ORDER:
                return anf_elt_is_minus1;
        case RING_C: 
                return v3glue_comp_is_minus_one;
        case RING_R: 
                return v3glue_real_is_minus_one;
        case RING_POLY: 
                return v3glue_poly_is_minus_one;
        default: 
                return NP; 
        }
}


